/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.path;

import java.util.Iterator;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.helpers.collection.IterableWrapper;
import org.springframework.data.neo4j.core.EntityPath;
import org.springframework.data.neo4j.core.GraphBacked;
import org.springframework.data.neo4j.core.NodeBacked;
import org.springframework.data.neo4j.core.RelationshipBacked;
import org.springframework.data.neo4j.support.GraphDatabaseContext;
import org.springframework.data.neo4j.support.path.DefaultRelationshipBacked;

public class ConvertingEntityPath<S extends NodeBacked, E extends NodeBacked>
implements EntityPath<S, E> {
    private final GraphDatabaseContext graphDatabaseContext;
    private final Path delegate;

    @Override
    public <T extends NodeBacked> T startEntity(Class<T> ... types) {
        return this.createNodeEntityFromFirstParameterOrStoredType(this.startNode(), types);
    }

    private <T extends NodeBacked> T createNodeEntityFromFirstParameterOrStoredType(Node node, Class<T> ... types) {
        if (node == null) {
            return null;
        }
        if (types == null || types.length == 0) {
            return (T)((NodeBacked)this.graphDatabaseContext.createEntityFromStoredType(node));
        }
        return (T)((NodeBacked)this.graphDatabaseContext.createEntityFromState(node, types[0]));
    }

    @Override
    public <T extends NodeBacked> T endEntity(Class<T> ... types) {
        return this.createNodeEntityFromFirstParameterOrStoredType(this.endNode(), types);
    }

    @Override
    public <T extends RelationshipBacked> T lastRelationshipEntity(Class<T> ... types) {
        Relationship relationship = this.lastRelationship();
        if (relationship == null) {
            return null;
        }
        return (T)((RelationshipBacked)this.graphDatabaseContext.createEntityFromState(relationship, ConvertingEntityPath.getFirstOrDefault(DefaultRelationshipBacked.class, types)));
    }

    private static <T> T getFirstOrDefault(T defaultValue, T ... values) {
        if (values == null || values.length == 0) {
            return defaultValue;
        }
        return values[0];
    }

    @Override
    public <T extends NodeBacked> Iterable<T> nodeEntities() {
        return new IterableWrapper<T, Node>(this.nodes()){

            protected T underlyingObjectToObject(Node node) {
                return (NodeBacked)ConvertingEntityPath.this.graphDatabaseContext.createEntityFromStoredType(node);
            }
        };
    }

    @Override
    public <T extends RelationshipBacked> Iterable<T> relationshipEntities(final Class<T> ... relationships) {
        return new IterableWrapper<T, Relationship>(this.relationships()){

            protected T underlyingObjectToObject(Relationship relationship) {
                return (RelationshipBacked)ConvertingEntityPath.this.graphDatabaseContext.createEntityFromState(relationship, (Class)ConvertingEntityPath.getFirstOrDefault(DefaultRelationshipBacked.class, relationships));
            }
        };
    }

    @Override
    public <T extends GraphBacked> Iterable<T> allPathEntities(final Class<T> ... relationships) {
        return new IterableWrapper<T, PropertyContainer>((Iterable)this.delegate){

            protected T underlyingObjectToObject(PropertyContainer element) {
                return ConvertingEntityPath.this.graphDatabaseContext.createEntityFromState(element, (Class)ConvertingEntityPath.getFirstOrDefault(DefaultRelationshipBacked.class, relationships));
            }
        };
    }

    public ConvertingEntityPath(GraphDatabaseContext graphDatabaseContext, Path delegate) {
        this.graphDatabaseContext = graphDatabaseContext;
        this.delegate = delegate;
    }

    public Node startNode() {
        return this.delegate.startNode();
    }

    public Node endNode() {
        return this.delegate.endNode();
    }

    public Relationship lastRelationship() {
        return this.delegate.lastRelationship();
    }

    public Iterable<Relationship> relationships() {
        return this.delegate.relationships();
    }

    public Iterable<Node> nodes() {
        return this.delegate.nodes();
    }

    public int length() {
        return this.delegate.length();
    }

    public Iterator<PropertyContainer> iterator() {
        return this.delegate.iterator();
    }
}

