/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.node;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import javax.persistence.PersistenceUnitUtil;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.beans.factory.aspectj.AbstractDependencyInjectionAspect;
import org.springframework.beans.factory.aspectj.AnnotationBeanConfigurerAspect;
import org.springframework.core.convert.ConversionService;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.data.neo4j.annotation.GraphProperty;
import org.springframework.data.neo4j.annotation.RelatedTo;
import org.springframework.data.neo4j.core.NodeBacked;
import org.springframework.data.neo4j.fieldaccess.ConvertingNodePropertyFieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.DefaultEntityState;
import org.springframework.data.neo4j.fieldaccess.DelegatingFieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.FieldAccessor;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorListenerFactory;
import org.springframework.data.neo4j.fieldaccess.IndexingPropertyFieldAccessorListenerFactory;
import org.springframework.data.neo4j.fieldaccess.JpaIdFieldAccessListenerFactory;
import org.springframework.data.neo4j.fieldaccess.OneToNRelationshipEntityFieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.OneToNRelationshipFieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.PropertyFieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.QueryFieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.ReadOnlyOneToNRelationshipFieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.SingleRelationshipFieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.TraversalFieldAccessorFactory;
import org.springframework.data.neo4j.support.GraphDatabaseContext;
import org.springframework.data.neo4j.support.node.Neo4jNodeBacking;

public class PartialNodeEntityState<ENTITY extends NodeBacked>
extends DefaultEntityState<ENTITY, Node> {
    public static final String FOREIGN_ID = "foreignId";
    public static final String FOREIGN_ID_INDEX = "foreign_id";
    private final GraphDatabaseContext graphDatabaseContext;
    private PersistenceUnitUtil persistenceUnitUtil;

    public PartialNodeEntityState(Node underlyingState, ENTITY entity, Class<? extends ENTITY> type, GraphDatabaseContext graphDatabaseContext, PersistenceUnitUtil persistenceUnitUtil, PartialNodeDelegatingFieldAccessorFactory delegatingFieldAccessorFactory) {
        super(underlyingState, entity, type, delegatingFieldAccessorFactory);
        this.graphDatabaseContext = graphDatabaseContext;
        this.persistenceUnitUtil = persistenceUnitUtil;
    }

    @Override
    public void createAndAssignState() {
        if (Neo4jNodeBacking.ajc$interMethodDispatch1$org_springframework_data_neo4j_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_core_NodeBacked$getPersistentState((NodeBacked)this.entity) != null) {
            return;
        }
        try {
            Node node;
            Object id = this.getId(this.entity);
            if (id == null) {
                return;
            }
            String foreignId = this.createForeignId(id);
            IndexHits indexHits = this.getForeignIdIndex().get(FOREIGN_ID, (Object)foreignId);
            Node node2 = node = indexHits.hasNext() ? (Node)indexHits.next() : null;
            if (node == null) {
                node = this.graphDatabaseContext.createNode();
                this.persistForeignId(node, id);
                this.setPersistentState(node);
                DefaultEntityState.log.info((Object)("User-defined constructor called on class " + ((NodeBacked)this.entity).getClass() + "; created Node [" + Neo4jNodeBacking.ajc$interMethodDispatch1$org_springframework_data_neo4j_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_core_NodeBacked$getPersistentState((NodeBacked)this.entity) + "]; Updating metamodel"));
                this.graphDatabaseContext.postEntityCreation(node, this.type);
            } else {
                this.setPersistentState(node);
                Neo4jNodeBacking.ajc$interMethodDispatch1$org_springframework_data_neo4j_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_core_NodeBacked$setPersistentState((NodeBacked)this.entity, node);
            }
        }
        catch (NotInTransactionException e) {
            throw new InvalidDataAccessResourceUsageException("Not in a Neo4j transaction.", (Throwable)e);
        }
    }

    @Override
    public ENTITY persist() {
        if (this.getPersistentState() == null) {
            this.createAndAssignState();
        }
        return (ENTITY)((NodeBacked)this.entity);
    }

    @Override
    public boolean isWritable(Field field) {
        FieldAccessor<NodeBacked> accessor = this.accessorFor(field);
        if (accessor == null) {
            return false;
        }
        return accessor.isWriteable((NodeBacked)this.entity);
    }

    private void persistForeignId(Node node, Object id) {
        if (!node.hasProperty(FOREIGN_ID) && id != null) {
            String foreignId = this.createForeignId(id);
            node.setProperty(FOREIGN_ID, id);
            this.getForeignIdIndex().add((PropertyContainer)node, FOREIGN_ID, (Object)foreignId);
        }
    }

    private Index<Node> getForeignIdIndex() {
        return this.graphDatabaseContext.getIndex(this.type);
    }

    private String createForeignId(Object id) {
        return String.valueOf(this.type.getName()) + ":" + id;
    }

    public Object getId(Object entity) {
        return this.persistenceUnitUtil != null ? this.persistenceUnitUtil.getIdentifier(entity) : null;
    }

    public static class PartialNodeDelegatingFieldAccessorFactory
    extends DelegatingFieldAccessorFactory {
        public PartialNodeDelegatingFieldAccessorFactory(GraphDatabaseContext graphDatabaseContext) {
            super(graphDatabaseContext);
        }

        @Override
        protected Collection<FieldAccessorListenerFactory<?>> createListenerFactories() {
            return Arrays.asList(new IndexingPropertyFieldAccessorListenerFactory(this.getGraphDatabaseContext(), this.newPropertyFieldAccessorFactory(), this.newConvertingNodePropertyFieldAccessorFactory()){

                @Override
                public boolean accept(Field f) {
                    return f.isAnnotationPresent(GraphProperty.class) && super.accept(f);
                }
            }, new JpaIdFieldAccessListenerFactory());
        }

        @Override
        protected Collection<? extends FieldAccessorFactory<?>> createAccessorFactories() {
            return Arrays.asList(new TraversalFieldAccessorFactory(), new QueryFieldAccessorFactory(), this.newPropertyFieldAccessorFactory(), this.newConvertingNodePropertyFieldAccessorFactory(), new SingleRelationshipFieldAccessorFactory(this.getGraphDatabaseContext()){

                @Override
                public boolean accept(Field f) {
                    return f.isAnnotationPresent(RelatedTo.class) && super.accept(f);
                }
            }, new OneToNRelationshipFieldAccessorFactory(this.getGraphDatabaseContext()), new ReadOnlyOneToNRelationshipFieldAccessorFactory(this.getGraphDatabaseContext()), new OneToNRelationshipEntityFieldAccessorFactory(this.getGraphDatabaseContext()));
        }

        private ConvertingNodePropertyFieldAccessorFactory newConvertingNodePropertyFieldAccessorFactory() {
            return new ConvertingNodePropertyFieldAccessorFactory(this.getGraphDatabaseContext().getConversionService()){
                private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
                {
                    PartialNodeDelegatingFieldAccessorFactory partialNodeDelegatingFieldAccessorFactory2 = PartialNodeDelegatingFieldAccessorFactory.this;
                    ConversionService conversionService = $anonymous0;
                    JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)partialNodeDelegatingFieldAccessorFactory2, (Object)conversionService);
                    if (!AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)this.getClass().getAnnotation(Configurable.class)) && AbstractDependencyInjectionAspect.ajc$if$6f1((JoinPoint)joinPoint)) {
                        AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c((Object)this);
                    }
                }

                @Override
                public boolean accept(Field f) {
                    return f.isAnnotationPresent(GraphProperty.class) && super.accept(f);
                }

                static {
                    3.ajc$preClinit();
                }

                private static /* synthetic */ void ajc$preClinit() {
                    Factory factory = new Factory("PartialNodeEntityState.java", 3.class);
                    ajc$tjp_0 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("0", "org.springframework.data.neo4j.support.node.PartialNodeEntityState$PartialNodeDelegatingFieldAccessorFactory$3", "org.springframework.data.neo4j.support.node.PartialNodeEntityState$PartialNodeDelegatingFieldAccessorFactory:org.springframework.core.convert.ConversionService", "arg0:$anonymous0", ""), 156);
                }
            };
        }

        private PropertyFieldAccessorFactory newPropertyFieldAccessorFactory() {
            return new PropertyFieldAccessorFactory(this.getGraphDatabaseContext().getConversionService()){

                @Override
                public boolean accept(Field f) {
                    return f.isAnnotationPresent(GraphProperty.class) && super.accept(f);
                }
            };
        }
    }
}

