/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.conversion;

import org.springframework.core.convert.ConversionService;
import org.springframework.data.neo4j.conversion.DefaultConverter;
import org.springframework.data.neo4j.core.EntityPath;
import org.springframework.data.neo4j.core.NodeBacked;
import org.springframework.data.neo4j.core.RelationshipBacked;
import org.springframework.data.neo4j.support.GraphDatabaseContext;
import org.springframework.data.neo4j.support.path.ConvertingEntityPath;

public class EntityResultConverter<T, R>
extends DefaultConverter<T, R> {
    private final GraphDatabaseContext ctx;
    private final ConversionService conversionService;

    public EntityResultConverter(GraphDatabaseContext ctx) {
        this.ctx = ctx;
        this.conversionService = this.ctx.getConversionService();
    }

    @Override
    protected Object doConvert(Object value, Class<?> sourceType, Class targetType) {
        if (NodeBacked.class.isAssignableFrom(targetType)) {
            return this.ctx.createEntityFromState(this.toNode(value, sourceType), targetType);
        }
        if (RelationshipBacked.class.isAssignableFrom(targetType)) {
            return this.ctx.createEntityFromState(this.toRelationship(value, sourceType), targetType);
        }
        if (EntityPath.class.isAssignableFrom(targetType)) {
            return new ConvertingEntityPath(this.ctx, this.toPath(value, sourceType));
        }
        Object result = super.doConvert(value, sourceType, targetType);
        if (result != null) {
            return result;
        }
        if (this.conversionService.canConvert(sourceType, targetType)) {
            return this.conversionService.convert(value, targetType);
        }
        return result;
    }
}

