/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import org.springframework.data.neo4j.mapping.Neo4JMappingContext;
import org.springframework.data.neo4j.mapping.Neo4JPersistentProperty;
import org.springframework.data.neo4j.mapping.RelationshipInfo;
import org.springframework.data.repository.query.parser.Property;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class MatchClause {
    private final Iterable<Neo4JPersistentProperty> properties;

    public MatchClause(Neo4JMappingContext context, Property property) {
        Assert.notNull((Object)((Object)context));
        Assert.notNull((Object)property);
        Class rootType = property.getOwningType().getType();
        this.properties = context.getPersistentPropertyPath(rootType, property.toDotPath());
    }

    public String toString() {
        String intermediate = null;
        for (Neo4JPersistentProperty property : this.properties) {
            if (!property.isRelationship()) {
                return intermediate;
            }
            RelationshipInfo info = property.getRelationshipInfo();
            Class ownerType = property.getOwner().getType();
            intermediate = intermediate == null ? MatchClause.asVariableReference(StringUtils.uncapitalize((String)ownerType.getSimpleName())) : intermediate;
            intermediate = String.format(MatchClause.getPattern(info), intermediate, info.getType(), MatchClause.asVariableReference(property.getName()));
        }
        return intermediate.toString();
    }

    private static String asVariableReference(String value) {
        return String.format("(%s)", value);
    }

    private static String getPattern(RelationshipInfo info) {
        switch (info.getDirection()) {
            case OUTGOING: {
                return "%s-[:%s]->%s";
            }
            case INCOMING: {
                return "%s<-[:%s]-%s";
            }
            case BOTH: {
                return "%s-[:%s]-%s";
            }
        }
        throw new IllegalArgumentException("Unsupported direction!");
    }
}

