/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.helpers.collection.IteratorUtil;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.neo4j.annotation.Query;
import org.springframework.data.neo4j.core.NodeBacked;
import org.springframework.data.neo4j.core.RelationshipBacked;
import org.springframework.data.neo4j.repository.GraphEntityInformation;
import org.springframework.data.neo4j.repository.GraphMetamodelEntityInformation;
import org.springframework.data.neo4j.repository.NodeGraphRepository;
import org.springframework.data.neo4j.repository.RelationshipGraphRepository;
import org.springframework.data.neo4j.support.GenericTypeExtractor;
import org.springframework.data.neo4j.support.GraphDatabaseContext;
import org.springframework.data.neo4j.support.conversion.EntityResultConverter;
import org.springframework.data.neo4j.support.node.Neo4jNodeBacking;
import org.springframework.data.neo4j.support.query.CypherQueryExecutor;
import org.springframework.data.neo4j.support.query.GremlinQueryEngine;
import org.springframework.data.neo4j.support.relationship.Neo4jRelationshipBacking;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.util.Assert;

public class GraphRepositoryFactory
extends RepositoryFactorySupport {
    private final GraphDatabaseContext graphDatabaseContext;

    public GraphRepositoryFactory(GraphDatabaseContext graphDatabaseContext) {
        Assert.notNull((Object)graphDatabaseContext);
        this.graphDatabaseContext = graphDatabaseContext;
    }

    protected Object getTargetRepository(RepositoryMetadata metadata) {
        return this.getTargetRepository(metadata, this.graphDatabaseContext);
    }

    protected Object getTargetRepository(RepositoryMetadata metadata, GraphDatabaseContext graphDatabaseContext) {
        metadata.getRepositoryInterface();
        Class type = metadata.getDomainClass();
        GraphEntityInformation entityInformation = (GraphEntityInformation)this.getEntityInformation(type);
        if (entityInformation.isNodeEntity()) {
            return new NodeGraphRepository(type, graphDatabaseContext);
        }
        return new RelationshipGraphRepository(type, graphDatabaseContext);
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata repositoryMetadata) {
        Class domainClass = repositoryMetadata.getDomainClass();
        GraphEntityInformation entityInformation = (GraphEntityInformation)this.getEntityInformation(domainClass);
        if (entityInformation.isNodeEntity()) {
            return NodeGraphRepository.class;
        }
        if (entityInformation.isRelationshipEntity()) {
            return RelationshipGraphRepository.class;
        }
        throw new IllegalArgumentException("Invalid Domain Class " + domainClass + " neither Node- nor RelationshipEntity");
    }

    public <T, ID extends Serializable> EntityInformation<T, ID> getEntityInformation(Class<T> type) {
        return new GraphMetamodelEntityInformation(type, this.graphDatabaseContext);
    }

    protected QueryLookupStrategy getQueryLookupStrategy(QueryLookupStrategy.Key key) {
        return new QueryLookupStrategy(){

            public RepositoryQuery resolveQuery(Method method, RepositoryMetadata repositoryMetadata, NamedQueries namedQueries) {
                GraphQueryMethod queryMethod = new GraphQueryMethod(method, repositoryMetadata, namedQueries);
                return queryMethod.createQuery(repositoryMetadata, GraphRepositoryFactory.this.graphDatabaseContext);
            }
        };
    }

    private static class CypherGraphRepositoryQuery
    extends GraphRepositoryQuery {
        private CypherQueryExecutor queryExecutor;

        public CypherGraphRepositoryQuery(GraphQueryMethod queryMethod, RepositoryMetadata metadata, GraphDatabaseContext graphDatabaseContext) {
            super(queryMethod, metadata, graphDatabaseContext);
            this.queryExecutor = new CypherQueryExecutor(graphDatabaseContext);
        }

        @Override
        protected Object dispatchQuery(String queryString, Map<String, Object> params, Pageable pageable) {
            GraphQueryMethod queryMethod = this.getQueryMethod();
            Class compoundType = queryMethod.getCompoundType();
            QueryMethod.Type queryResultType = queryMethod.getType();
            if (queryResultType == QueryMethod.Type.PAGING) {
                return this.queryPaged(queryString, params, pageable);
            }
            if (queryMethod.isIterableResult()) {
                if (compoundType.isAssignableFrom(Map.class)) {
                    return this.queryExecutor.queryForList(queryString, params);
                }
                return this.queryExecutor.query(queryString, queryMethod.getCompoundType(), params);
            }
            return this.queryExecutor.queryForObject(queryString, queryMethod.getReturnType(), params);
        }

        private Object queryPaged(String queryString, Map<String, Object> params, Pageable pageable) {
            Iterable result = this.queryExecutor.query(queryString, this.getQueryMethod().getCompoundType(), params);
            return this.createPage(result, pageable);
        }
    }

    static class GraphQueryMethod
    extends QueryMethod {
        private final Method method;
        private final Query queryAnnotation;
        private final String query;

        public GraphQueryMethod(Method method, RepositoryMetadata metadata, NamedQueries namedQueries) {
            super(method, metadata);
            this.method = method;
            this.queryAnnotation = method.getAnnotation(Query.class);
            String string = this.query = this.queryAnnotation != null ? this.queryAnnotation.value() : this.getNamedQuery(namedQueries);
            if (this.query == null) {
                throw new IllegalArgumentException("Could not extract a query from " + method);
            }
        }

        public boolean isValid() {
            return this.query != null;
        }

        private String getNamedQuery(NamedQueries namedQueries) {
            String namedQueryName = this.getNamedQueryName();
            if (namedQueries.hasQuery(namedQueryName)) {
                return namedQueries.getQuery(namedQueryName);
            }
            return null;
        }

        public Class<?> getReturnType() {
            return this.method.getReturnType();
        }

        private String prepareQuery(Object[] args) {
            Pageable pageable;
            Parameters parameters = this.getParameters();
            String queryString = this.query;
            if (parameters.hasSortParameter()) {
                queryString = this.addSorting(queryString, (Sort)args[parameters.getSortIndex()]);
            }
            if (parameters.hasPageableParameter() && (pageable = this.getPageable(args)) != null) {
                queryString = this.addSorting(queryString, pageable.getSort());
                queryString = this.addPaging(queryString, pageable);
            }
            return queryString;
        }

        private Map<String, Object> resolveParams(Object[] parameters) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            for (Parameter parameter : this.getParameters().getBindableParameters()) {
                Object value = parameters[parameter.getIndex()];
                params.put(parameter.getName(), this.resolveParameter(value));
            }
            return params;
        }

        private Pageable getPageable(Object[] args) {
            Parameters parameters = this.getParameters();
            if (parameters.hasPageableParameter()) {
                return (Pageable)args[parameters.getPageableIndex()];
            }
            return null;
        }

        private String addPaging(String baseQuery, Pageable pageable) {
            if (pageable == null) {
                return baseQuery;
            }
            return String.valueOf(baseQuery) + " skip " + pageable.getOffset() + " limit " + pageable.getPageSize();
        }

        private String addSorting(String baseQuery, Sort sort) {
            if (sort == null) {
                return baseQuery;
            }
            String sortOrder = this.getSortOrder(sort);
            if (sortOrder.isEmpty()) {
                return baseQuery;
            }
            return String.valueOf(baseQuery) + " order by " + sortOrder;
        }

        private String getSortOrder(Sort sort) {
            String result = "";
            for (Sort.Order order : sort) {
                result = String.valueOf(result) + order.getProperty() + " " + order.getDirection();
            }
            return result;
        }

        private Object resolveParameter(Object parameter) {
            if (parameter instanceof NodeBacked) {
                return Neo4jNodeBacking.ajc$interMethodDispatch1$org_springframework_data_neo4j_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_core_NodeBacked$getNodeId((NodeBacked)parameter);
            }
            if (parameter instanceof RelationshipBacked) {
                return Neo4jRelationshipBacking.ajc$interMethodDispatch1$org_springframework_data_neo4j_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_core_RelationshipBacked$getRelationshipId((RelationshipBacked)parameter);
            }
            return parameter;
        }

        private Class<?> getCompoundType() {
            Class<?> elementClass = this.getElementClass();
            if (elementClass != null) {
                return elementClass;
            }
            return GenericTypeExtractor.resolveReturnedType(this.method);
        }

        private Class<?> getElementClass() {
            if (!this.hasAnnotation() || this.queryAnnotation.elementClass().equals(Object.class)) {
                return null;
            }
            return this.queryAnnotation.elementClass();
        }

        public String getQueryString() {
            return this.query;
        }

        public boolean hasAnnotation() {
            return this.queryAnnotation != null;
        }

        private boolean isIterableResult() {
            return Iterable.class.isAssignableFrom(this.getReturnType());
        }

        private RepositoryQuery createQuery(RepositoryMetadata repositoryMetadata, GraphDatabaseContext context) {
            if (!this.isValid()) {
                return null;
            }
            if (this.queryAnnotation == null) {
                return new CypherGraphRepositoryQuery(this, repositoryMetadata, context);
            }
            switch (this.queryAnnotation.type()) {
                case Cypher: {
                    return new CypherGraphRepositoryQuery(this, repositoryMetadata, context);
                }
                case Gremlin: {
                    return new GremlinGraphRepositoryQuery(this, repositoryMetadata, context);
                }
            }
            throw new IllegalStateException("@Query Annotation has to be configured as Cypher or Gremlin Query");
        }
    }

    private static abstract class GraphRepositoryQuery
    implements RepositoryQuery {
        private final GraphQueryMethod queryMethod;

        public GraphRepositoryQuery(GraphQueryMethod queryMethod, RepositoryMetadata metadata, GraphDatabaseContext graphDatabaseContext) {
            this.queryMethod = queryMethod;
        }

        public Object execute(Object[] parameters) {
            Map params = this.queryMethod.resolveParams(parameters);
            String queryString = this.queryMethod.prepareQuery(parameters);
            return this.dispatchQuery(queryString, params, this.queryMethod.getPageable(parameters));
        }

        protected abstract Object dispatchQuery(String var1, Map<String, Object> var2, Pageable var3);

        public GraphQueryMethod getQueryMethod() {
            return this.queryMethod;
        }

        protected Object createPage(Iterable<?> result, Pageable pageable) {
            List resultList = (List)IteratorUtil.addToCollection(result, new ArrayList());
            if (pageable == null) {
                return new PageImpl(resultList);
            }
            int currentTotal = pageable.getOffset() + pageable.getPageSize();
            return new PageImpl(resultList, pageable, (long)currentTotal);
        }
    }

    private static class GremlinGraphRepositoryQuery
    extends GraphRepositoryQuery {
        private GremlinQueryEngine queryExecutor;

        public GremlinGraphRepositoryQuery(GraphQueryMethod queryMethod, RepositoryMetadata metadata, GraphDatabaseContext graphDatabaseContext) {
            super(queryMethod, metadata, graphDatabaseContext);
            this.queryExecutor = new GremlinQueryEngine(graphDatabaseContext.getGraphDatabaseService(), new EntityResultConverter(graphDatabaseContext));
        }

        @Override
        protected Object dispatchQuery(String queryString, Map<String, Object> params, Pageable pageable) {
            GraphQueryMethod queryMethod = this.getQueryMethod();
            QueryMethod.Type queryResultType = queryMethod.getType();
            if (queryResultType == QueryMethod.Type.PAGING) {
                return this.queryPaged(queryString, params, pageable);
            }
            if (queryMethod.isIterableResult()) {
                return this.queryExecutor.query(queryString, params).to(queryMethod.getCompoundType());
            }
            return this.queryExecutor.query(queryString, params).to(queryMethod.getReturnType()).single();
        }

        private Object queryPaged(String queryString, Map<String, Object> params, Pageable pageable) {
            Iterable result = this.queryExecutor.query(queryString, params).to(this.getQueryMethod().getCompoundType());
            return this.createPage(result, pageable);
        }
    }
}

