/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository;

import org.springframework.data.neo4j.core.GraphBacked;
import org.springframework.data.neo4j.core.NodeBacked;
import org.springframework.data.neo4j.core.RelationshipBacked;
import org.springframework.data.neo4j.repository.GraphRepository;
import org.springframework.data.neo4j.repository.NodeGraphRepository;
import org.springframework.data.neo4j.repository.RelationshipGraphRepository;
import org.springframework.data.neo4j.support.GraphDatabaseContext;

public class DirectGraphRepositoryFactory {
    private final GraphDatabaseContext graphDatabaseContext;

    public DirectGraphRepositoryFactory(GraphDatabaseContext graphDatabaseContext) {
        this.graphDatabaseContext = graphDatabaseContext;
    }

    public <T extends GraphBacked<?>> GraphRepository<T> createGraphRepository(Class<T> clazz) {
        if (NodeBacked.class.isAssignableFrom(clazz)) {
            return new NodeGraphRepository<T>(clazz, this.graphDatabaseContext);
        }
        if (RelationshipBacked.class.isAssignableFrom(clazz)) {
            return new RelationshipGraphRepository<T>(clazz, this.graphDatabaseContext);
        }
        throw new IllegalArgumentException("Can't create graph repository for non graph entity of type " + clazz);
    }
}

