/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import java.util.Date;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.core.convert.support.ConversionServiceFactory;
import org.springframework.core.convert.support.GenericConversionService;

public class Neo4jConversionServiceFactoryBean
implements FactoryBean<ConversionService> {
    public ConversionService getObject() throws Exception {
        GenericConversionService conversionService = new GenericConversionService();
        this.addConverters(conversionService);
        ConversionServiceFactory.addDefaultConverters((GenericConversionService)conversionService);
        return conversionService;
    }

    private void addConverters(GenericConversionService conversionService) {
        conversionService.addConverter((Converter)new DateToLongConverter());
        conversionService.addConverter((Converter)new LongToDateConverter());
        conversionService.addConverter((Converter)new EnumToStringConverter());
        conversionService.addConverterFactory((ConverterFactory)new StringToEnumConverterFactory());
    }

    public Class<?> getObjectType() {
        return GenericConversionService.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public static class DateToLongConverter
    implements Converter<Date, String> {
        public String convert(Date source) {
            return String.valueOf(source.getTime());
        }
    }

    public static class EnumToStringConverter
    implements Converter<Enum, String> {
        public String convert(Enum source) {
            return source.name();
        }
    }

    public static class LongToDateConverter
    implements Converter<String, Date> {
        public Date convert(String source) {
            return new Date(Long.valueOf(source));
        }
    }

    public static class StringToEnumConverterFactory
    implements ConverterFactory<String, Enum> {
        public <T extends Enum> Converter<String, T> getConverter(Class<T> targetType) {
            return new StringToEnum<T>(targetType);
        }

        private static class StringToEnum<T extends Enum>
        implements Converter<String, T> {
            private final Class<T> enumType;

            public StringToEnum(Class<T> enumType) {
                this.enumType = enumType;
            }

            public T convert(String source) {
                if (source == null) {
                    return null;
                }
                String trimmed = source.trim();
                if (trimmed.isEmpty()) {
                    return null;
                }
                return Enum.valueOf(this.enumType, trimmed);
            }
        }
    }
}

