/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.neo4j.graphdb.Transaction;
import org.springframework.data.neo4j.core.EntityState;
import org.springframework.data.neo4j.core.GraphBacked;
import org.springframework.data.neo4j.core.NodeBacked;
import org.springframework.data.neo4j.support.DoReturn;
import org.springframework.data.neo4j.support.GraphDatabaseContext;
import org.springframework.data.neo4j.support.node.Neo4jNodeBacking;
import org.springframework.util.ObjectUtils;

public class DetachedEntityState<ENTITY extends GraphBacked<STATE>, STATE>
implements EntityState<ENTITY, STATE> {
    private final Map<Field, ExistingValue> dirty = new HashMap<Field, ExistingValue>();
    protected final EntityState<ENTITY, STATE> delegate;
    private static final Log log = LogFactory.getLog(DetachedEntityState.class);
    private GraphDatabaseContext graphDatabaseContext;

    public DetachedEntityState(EntityState<ENTITY, STATE> delegate, GraphDatabaseContext graphDatabaseContext) {
        this.delegate = delegate;
        this.graphDatabaseContext = graphDatabaseContext;
    }

    @Override
    public boolean isWritable(Field field) {
        return this.delegate.isWritable(field);
    }

    @Override
    public ENTITY getEntity() {
        return this.delegate.getEntity();
    }

    @Override
    public boolean hasPersistentState() {
        return this.delegate.hasPersistentState();
    }

    @Override
    public STATE getPersistentState() {
        return this.delegate.getPersistentState();
    }

    @Override
    public Object getValue(Field field) {
        if (this.isDetached() && (this.getEntity().getPersistentState() == null || this.isDirty(field))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Outside of transaction, GET value from field " + field));
            }
            return null;
        }
        return this.delegate.getValue(field);
    }

    protected boolean isDetached() {
        return !this.transactionIsRunning() || !this.hasPersistentState() || this.isDirty();
    }

    protected boolean transactionIsRunning() {
        return this.getGraphDatabaseContext().transactionIsRunning();
    }

    @Override
    public Object setValue(Field field, Object newVal) {
        if (this.isDetached()) {
            if (!this.isDirty(field) && this.isWritable(field)) {
                if (this.hasPersistentState()) {
                    this.addDirty(field, DoReturn.unwrap(this.delegate.getValue(field)), true);
                } else {
                    this.addDirty(field, newVal, false);
                }
            }
            return newVal;
        }
        return this.delegate.setValue(field, newVal);
    }

    private Object getDefaultValue(Class<?> type) {
        if (type.isPrimitive()) {
            if (type.equals(Boolean.TYPE)) {
                return false;
            }
            return 0;
        }
        return null;
    }

    @Override
    public void createAndAssignState() {
        if (this.graphDatabaseContext.transactionIsRunning()) {
            this.delegate.createAndAssignState();
        } else {
            log.warn((Object)("New Nodebacked created outside of transaction " + this.delegate.getEntity().getClass()));
        }
    }

    private void flushDirty() {
        ENTITY entity = this.getEntity();
        if (!this.hasPersistentState()) {
            throw new IllegalStateException("Flushing detached entity without a persistent state, this had to be created first.");
        }
        if (this.isDirty()) {
            HashMap<Field, ExistingValue> dirtyCopy = new HashMap<Field, ExistingValue>(this.dirty);
            this.clearDirty();
            for (Map.Entry<Field, ExistingValue> entry : dirtyCopy.entrySet()) {
                Field field = (Field)entry.getKey();
                Object valueFromEntity = this.getValueFromEntity(field);
                this.cascadePersist(valueFromEntity);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Flushing dirty Entity new node " + entity.getPersistentState() + " field " + field + " with value " + valueFromEntity));
                }
                this.checkConcurrentModification(entity, entry, field);
                this.delegate.setValue(field, valueFromEntity);
            }
        }
    }

    private void cascadePersist(Object valueFromEntity) {
        if (valueFromEntity instanceof NodeBacked) {
            Neo4jNodeBacking.ajc$interMethodDispatch1$org_springframework_data_neo4j_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_core_NodeBacked$persist((NodeBacked)valueFromEntity);
        }
        if (valueFromEntity instanceof Collection) {
            for (Object o : (Collection)valueFromEntity) {
                if (!(o instanceof NodeBacked)) continue;
                Neo4jNodeBacking.ajc$interMethodDispatch1$org_springframework_data_neo4j_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_core_NodeBacked$persist((NodeBacked)o);
            }
        }
    }

    @Override
    public void setPersistentState(STATE state) {
        this.delegate.setPersistentState(state);
    }

    private Object getValueFromEntity(Field field) {
        ENTITY entity = this.getEntity();
        try {
            field.setAccessible(true);
            return field.get(entity);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error accessing field " + field + " in " + entity.getClass(), e);
        }
    }

    private void checkConcurrentModification(ENTITY entity, Map.Entry<Field, ExistingValue> entry, Field field) {
        Object nodeValue;
        ExistingValue previousValue = entry.getValue();
        if (previousValue.mustCheckConcurrentModification() && !ObjectUtils.nullSafeEquals((Object)(nodeValue = DoReturn.unwrap(this.delegate.getValue(field))), (Object)previousValue.value)) {
            throw new ConcurrentModificationException("Node " + entity.getPersistentState() + " field " + field + " changed in between previous " + previousValue + " current " + nodeValue);
        }
    }

    private boolean isDirty() {
        return !this.dirty.isEmpty();
    }

    private boolean isDirty(Field f) {
        return this.dirty.containsKey(f);
    }

    private void clearDirty() {
        this.dirty.clear();
    }

    private void addDirty(Field f, Object previousValue, boolean fromGraph) {
        this.dirty.put(f, new ExistingValue(previousValue, fromGraph));
    }

    public GraphDatabaseContext getGraphDatabaseContext() {
        return this.graphDatabaseContext;
    }

    @Override
    public ENTITY persist() {
        if (!this.isDetached()) {
            return this.getEntity();
        }
        Transaction tx = this.graphDatabaseContext.beginTx();
        try {
            ENTITY result = this.delegate.persist();
            this.flushDirty();
            tx.success();
            ENTITY ENTITY = result;
            return ENTITY;
        }
        finally {
            tx.finish();
        }
    }

    static class ExistingValue {
        public final Object value;
        private final boolean fromGraph;

        ExistingValue(Object value, boolean fromGraph) {
            this.value = value;
            this.fromGraph = fromGraph;
        }

        public String toString() {
            return String.format("ExistingValue{value=%s, fromGraph=%s}", this.value, this.fromGraph);
        }

        private boolean mustCheckConcurrentModification() {
            return this.fromGraph;
        }
    }
}

