/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.config;

import javax.annotation.PostConstruct;
import org.neo4j.graphdb.Transaction;
import org.springframework.data.neo4j.support.GraphDatabaseContext;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;

public class ConfigurationCheck {
    GraphDatabaseContext graphDatabaseContext;
    PlatformTransactionManager transactionManager;

    public ConfigurationCheck(GraphDatabaseContext graphDatabaseContext, PlatformTransactionManager transactionManager) {
        this.graphDatabaseContext = graphDatabaseContext;
        this.transactionManager = transactionManager;
    }

    @PostConstruct
    private void checkConfiguration() {
        this.checkInjection();
        this.checkSpringTransactionManager();
        this.checkNeo4jTransactionManager();
    }

    private void checkInjection() {
        assert (this.graphDatabaseContext.getGraphDatabaseService() != null) : "graphDatabaseService not correctly configured, please refer to the manual, setup section";
    }

    private void checkSpringTransactionManager() {
        try {
            TransactionStatus transaction = this.transactionManager.getTransaction(null);
            this.updateStartTime();
            this.transactionManager.commit(transaction);
        }
        catch (Exception e) {
            AssertionError error = new AssertionError((Object)"transactionManager not correctly configured, please refer to the manual, setup section");
            ((Throwable)((Object)error)).initCause(e);
            throw error;
        }
    }

    private void checkNeo4jTransactionManager() {
        Transaction tx = null;
        try {
            try {
                tx = this.graphDatabaseContext.beginTx();
                this.updateStartTime();
                tx.success();
            }
            catch (Exception e) {
                AssertionError error = new AssertionError((Object)"transactionManager not correctly configured, please refer to the manual, setup section");
                ((Throwable)((Object)error)).initCause(e);
                throw error;
            }
        }
        catch (Throwable throwable) {
            try {
                if (tx != null) {
                    tx.finish();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (tx != null) {
                tx.finish();
            }
        }
        catch (Exception exception) {}
    }

    private void updateStartTime() {
        this.graphDatabaseContext.getReferenceNode().setProperty("startTime", (Object)System.currentTimeMillis());
    }
}

