/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.aot;

import org.jspecify.annotations.NullUnmarked;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoPage;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.NearQuery;
import org.springframework.data.mongodb.repository.aot.MongoCodeBlocks;
import org.springframework.data.mongodb.repository.aot.Snippet;
import org.springframework.data.mongodb.repository.aot.VariableSnippet;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.repository.aot.generate.AotQueryMethodGenerationContext;
import org.springframework.data.repository.aot.generate.MethodReturn;
import org.springframework.data.support.PageableExecutionUtils;
import org.springframework.javapoet.CodeBlock;
import org.springframework.util.ClassUtils;

class GeoBlocks {
    GeoBlocks() {
    }

    @NullUnmarked
    static class GeoNearExecutionCodeBlockBuilder {
        private final AotQueryMethodGenerationContext context;
        private String queryVariableName;

        GeoNearExecutionCodeBlockBuilder(AotQueryMethodGenerationContext context) {
            this.context = context;
        }

        GeoNearExecutionCodeBlockBuilder referencing(String queryVariableName) {
            this.queryVariableName = queryVariableName;
            return this;
        }

        CodeBlock build() {
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add("\n", new Object[0]);
            MethodReturn methodReturn = this.context.getMethodReturn();
            VariableSnippet queryExecutor = Snippet.declare(builder).variable(this.context.localVariable("nearFinder")).as("$L.query($T.class).near($L)", this.context.fieldNameOf(MongoOperations.class), this.context.getRepositoryInformation().getDomainType(), this.queryVariableName);
            if (ClassUtils.isAssignable(GeoPage.class, (Class)methodReturn.toClass())) {
                VariableSnippet geoResult = Snippet.declare(builder).variable(this.context.localVariable("geoResult")).as("$L.all()", queryExecutor.getVariableName());
                builder.beginControlFlow("if($L.isUnpaged())", new Object[]{this.context.getPageableParameterName()});
                builder.addStatement("return new $T<>($L)", new Object[]{GeoPage.class, geoResult.getVariableName()});
                builder.endControlFlow();
                VariableSnippet resultPage = Snippet.declare(builder).variable(this.context.localVariable("resultPage")).as("$T.getPage($L.getContent(), $L, () -> $L.count())", PageableExecutionUtils.class, geoResult.getVariableName(), this.context.getPageableParameterName(), queryExecutor.getVariableName());
                builder.addStatement("return new $T<>($L, $L, $L.getTotalElements())", new Object[]{GeoPage.class, geoResult.getVariableName(), this.context.getPageableParameterName(), resultPage.getVariableName()});
            } else if (ClassUtils.isAssignable(GeoResults.class, (Class)methodReturn.toClass())) {
                builder.addStatement("return $L.all()", new Object[]{queryExecutor.getVariableName()});
            } else {
                builder.addStatement("return $L.all().getContent()", new Object[]{queryExecutor.getVariableName()});
            }
            return builder.build();
        }
    }

    @NullUnmarked
    static class GeoNearCodeBlockBuilder {
        private final AotQueryMethodGenerationContext context;
        private final MongoQueryMethod queryMethod;
        private String variableName;

        GeoNearCodeBlockBuilder(AotQueryMethodGenerationContext context, MongoQueryMethod queryMethod) {
            this.context = context;
            this.queryMethod = queryMethod;
        }

        CodeBlock build() {
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add("\n", new Object[0]);
            VariableSnippet query = Snippet.declare(builder).variable(NearQuery.class, this.variableName).as("$T.near($L)", NearQuery.class, this.context.getParameterName(this.queryMethod.getParameters().getNearIndex()));
            if (this.queryMethod.getParameters().getRangeIndex() != -1) {
                String rangeParameter = this.context.getParameterName(this.queryMethod.getParameters().getRangeIndex());
                builder.beginControlFlow("if($L.getLowerBound().isBounded())", new Object[]{rangeParameter});
                VariableSnippet min = Snippet.declare(builder).variable(Distance.class, this.context.localVariable("min")).as("$L.getLowerBound().getValue().get()", rangeParameter);
                builder.addStatement("$1L.minDistance($2L).in($2L.getMetric())", new Object[]{query.getVariableName(), min.getVariableName()});
                builder.endControlFlow();
                builder.beginControlFlow("if($L.getUpperBound().isBounded())", new Object[]{rangeParameter});
                VariableSnippet max = Snippet.declare(builder).variable(Distance.class, this.context.localVariable("max")).as("$L.getUpperBound().getValue().get()", rangeParameter);
                builder.addStatement("$1L.maxDistance($2L).in($2L.getMetric())", new Object[]{query.getVariableName(), max.getVariableName()});
                builder.endControlFlow();
            } else {
                String distanceParameter = this.context.getParameterName(this.queryMethod.getParameters().getMaxDistanceIndex());
                builder.addStatement("$1L.maxDistance($2L).in($2L.getMetric())", new Object[]{query.code(), distanceParameter});
            }
            if (this.context.getPageableParameterName() != null) {
                builder.addStatement("$L.with($L)", new Object[]{query.code(), this.context.getPageableParameterName()});
            }
            MongoCodeBlocks.appendReadPreference(this.context, builder, query.getVariableName());
            return builder.build();
        }

        public GeoNearCodeBlockBuilder usingQueryVariableName(String variableName) {
            this.variableName = variableName;
            return this;
        }
    }
}

