/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import org.jspecify.annotations.Nullable;
import org.springframework.data.mapping.model.ValueExpressionEvaluator;
import org.springframework.data.mongodb.InvalidMongoDbApiUsageException;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.query.AbstractMongoQuery;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoQueryExecution;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.mongodb.repository.query.VectorSearchDelegate;
import org.springframework.data.mongodb.util.json.ParameterBindingContext;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ValueExpressionDelegate;

public class VectorSearchAggregation
extends AbstractMongoQuery {
    private final MongoOperations mongoOperations;
    private final MongoPersistentEntity<?> collectionEntity;
    private final VectorSearchDelegate delegate;

    public VectorSearchAggregation(MongoQueryMethod method, MongoOperations mongoOperations, ValueExpressionDelegate delegate) {
        super(method, mongoOperations, delegate);
        if (!method.isSearchQuery() && !method.isCollectionQuery()) {
            throw new InvalidMongoDbApiUsageException(String.format("Repository Vector Search method '%s' must return either return SearchResults<T> or List<T> but was %s", method.getName(), method.getReturnType().getType().getSimpleName()));
        }
        this.mongoOperations = mongoOperations;
        this.collectionEntity = method.getEntityInformation().getCollectionEntity();
        this.delegate = new VectorSearchDelegate(method, mongoOperations.getConverter(), delegate);
    }

    @Override
    protected Object doExecute(MongoQueryMethod method, ResultProcessor processor, ConvertingParameterAccessor accessor, @Nullable Class<?> typeToRead) {
        VectorSearchDelegate.QueryContainer query = this.createVectorSearchQuery(processor, accessor, typeToRead);
        MongoQueryExecution.VectorSearchExecution execution = new MongoQueryExecution.VectorSearchExecution(this.mongoOperations, method, this.collectionEntity.getCollection(), query);
        return execution.execute(query.query());
    }

    VectorSearchDelegate.QueryContainer createVectorSearchQuery(ResultProcessor processor, MongoParameterAccessor accessor, @Nullable Class<?> typeToRead) {
        ValueExpressionEvaluator evaluator = this.getExpressionEvaluatorFor(accessor);
        ParameterBindingContext bindingContext = this.prepareBindingContext(this.delegate.getQueryString(), accessor);
        return this.delegate.createQuery(evaluator, processor, accessor, typeToRead, this.getParameterBindingCodec(), bindingContext);
    }

    @Override
    protected Query createQuery(ConvertingParameterAccessor accessor) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean isCountQuery() {
        return false;
    }

    @Override
    protected boolean isExistsQuery() {
        return false;
    }

    @Override
    protected boolean isDeleteQuery() {
        return false;
    }

    @Override
    protected boolean isLimiting() {
        return false;
    }
}

