/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.WriteConcern;
import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.core.MongoActionOperation;
import org.springframework.util.Assert;

public class MongoAction {
    private final String collectionName;
    private final MongoActionOperation mongoActionOperation;
    private final @Nullable WriteConcern defaultWriteConcern;
    private final @Nullable Class<?> entityType;
    private final @Nullable Document query;
    private final @Nullable Document document;

    public MongoAction(@Nullable WriteConcern defaultWriteConcern, MongoActionOperation mongoActionOperation, String collectionName, @Nullable Class<?> entityType, @Nullable Document document, @Nullable Document query) {
        Assert.hasText((String)collectionName, (String)"Collection name must not be null or empty");
        Assert.notNull((Object)((Object)mongoActionOperation), (String)"MongoActionOperation must not be null");
        this.defaultWriteConcern = defaultWriteConcern;
        this.mongoActionOperation = mongoActionOperation;
        this.collectionName = collectionName;
        this.entityType = entityType;
        this.query = query;
        this.document = document;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public @Nullable WriteConcern getDefaultWriteConcern() {
        return this.defaultWriteConcern;
    }

    public @Nullable Class<?> getEntityType() {
        return this.entityType;
    }

    public @Nullable MongoActionOperation getMongoActionOperation() {
        return this.mongoActionOperation;
    }

    public @Nullable Document getQuery() {
        return this.query;
    }

    public @Nullable Document getDocument() {
        return this.document;
    }
}

