/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.client.result.DeleteResult;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.core.ExecutableRemoveOperation;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.QueryResultConverter;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class ExecutableRemoveOperationSupport
implements ExecutableRemoveOperation {
    private static final Query ALL_QUERY = new Query();
    private final MongoTemplate tempate;

    public ExecutableRemoveOperationSupport(MongoTemplate tempate) {
        this.tempate = tempate;
    }

    @Override
    @Contract(value="_ -> new")
    public <T> ExecutableRemoveOperation.ExecutableRemove<T> remove(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null");
        return new ExecutableRemoveSupport(this.tempate, domainType, ALL_QUERY, null, QueryResultConverter.entity());
    }

    static class ExecutableRemoveSupport<S, T>
    implements ExecutableRemoveOperation.ExecutableRemove<T>,
    ExecutableRemoveOperation.RemoveWithCollection<T> {
        private final MongoTemplate template;
        private final Class<S> domainType;
        private final Query query;
        private final @Nullable String collection;
        private final QueryResultConverter<? super S, ? extends T> resultConverter;

        public ExecutableRemoveSupport(MongoTemplate template, Class<S> domainType, Query query, @Nullable String collection, QueryResultConverter<? super S, ? extends T> resultConverter) {
            this.template = template;
            this.domainType = domainType;
            this.query = query;
            this.collection = collection;
            this.resultConverter = resultConverter;
        }

        @Override
        @Contract(value="_ -> new")
        public ExecutableRemoveOperation.RemoveWithQuery<T> inCollection(String collection) {
            Assert.hasText((String)collection, (String)"Collection must not be null nor empty");
            return new ExecutableRemoveSupport<S, T>(this.template, this.domainType, this.query, collection, this.resultConverter);
        }

        @Override
        @Contract(value="_ -> new")
        public ExecutableRemoveOperation.TerminatingRemove<T> matching(Query query) {
            Assert.notNull((Object)query, (String)"Query must not be null");
            return new ExecutableRemoveSupport<S, T>(this.template, this.domainType, query, this.collection, this.resultConverter);
        }

        @Override
        public DeleteResult all() {
            return this.template.doRemove(this.getCollectionName(), this.query, this.domainType, true);
        }

        @Override
        public DeleteResult one() {
            return this.template.doRemove(this.getCollectionName(), this.query, this.domainType, false);
        }

        @Override
        public List<T> findAndRemove() {
            String collectionName = this.getCollectionName();
            return this.template.doFindAndDelete(collectionName, this.query, this.domainType, this.resultConverter);
        }

        @Override
        public <R> ExecutableRemoveOperation.TerminatingResults<R> map(QueryResultConverter<? super T, ? extends R> converter) {
            return new ExecutableRemoveSupport<T, R>(this.template, this.domainType, this.query, this.collection, converter);
        }

        private String getCollectionName() {
            return StringUtils.hasText((String)this.collection) ? this.collection : this.template.getCollectionName(this.domainType);
        }
    }
}

