/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.client.result.DeleteResult;
import java.util.List;
import org.springframework.data.mongodb.core.QueryResultConverter;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.lang.Contract;

public interface ExecutableRemoveOperation {
    public <T> ExecutableRemove<T> remove(Class<T> var1);

    public static interface ExecutableRemove<T>
    extends RemoveWithCollection<T> {
    }

    public static interface RemoveWithQuery<T>
    extends TerminatingRemove<T> {
        public TerminatingRemove<T> matching(Query var1);

        default public TerminatingRemove<T> matching(CriteriaDefinition criteria) {
            return this.matching(Query.query(criteria));
        }
    }

    public static interface RemoveWithCollection<T>
    extends RemoveWithQuery<T> {
        public RemoveWithQuery<T> inCollection(String var1);
    }

    public static interface TerminatingRemove<T>
    extends TerminatingResults<T> {
        public DeleteResult all();

        public DeleteResult one();
    }

    public static interface TerminatingResults<T> {
        @Contract(value="_ -> new")
        public <R> TerminatingResults<R> map(QueryResultConverter<? super T, ? extends R> var1);

        public List<T> findAndRemove();
    }
}

