/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.client.MongoCollection;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.core.CollectionPreparer;
import org.springframework.data.mongodb.core.ReadConcernAware;
import org.springframework.data.mongodb.core.ReadPreferenceAware;

class CollectionPreparerSupport
implements ReadConcernAware,
ReadPreferenceAware {
    private final List<Object> sources;

    private CollectionPreparerSupport(List<Object> sources) {
        this.sources = sources;
    }

    <T> T doPrepare(T collection, Function<T, ReadConcern> concernAccessor, BiFunction<T, ReadConcern, T> concernFunction, Function<T, ReadPreference> preferenceAccessor, BiFunction<T, ReadPreference, T> preferenceFunction) {
        T collectionToUse = collection;
        for (Object source : this.sources) {
            ReadConcernAware rca;
            if (!(source instanceof ReadConcernAware) || !(rca = (ReadConcernAware)source).hasReadConcern()) continue;
            ReadConcern concern = rca.getReadConcern();
            if (concernAccessor.apply(collectionToUse) == concern) break;
            collectionToUse = concernFunction.apply(collectionToUse, concern);
            break;
        }
        for (Object source : this.sources) {
            ReadPreferenceAware rpa;
            if (!(source instanceof ReadPreferenceAware) || !(rpa = (ReadPreferenceAware)source).hasReadPreference()) continue;
            ReadPreference preference = rpa.getReadPreference();
            if (preferenceAccessor.apply(collectionToUse) == preference) break;
            collectionToUse = preferenceFunction.apply(collectionToUse, preference);
            break;
        }
        return collectionToUse;
    }

    @Override
    public boolean hasReadConcern() {
        for (Object aware : this.sources) {
            ReadConcernAware rca;
            if (!(aware instanceof ReadConcernAware) || !(rca = (ReadConcernAware)aware).hasReadConcern()) continue;
            return true;
        }
        return false;
    }

    @Override
    public @Nullable ReadConcern getReadConcern() {
        for (Object aware : this.sources) {
            ReadConcernAware rca;
            if (!(aware instanceof ReadConcernAware) || !(rca = (ReadConcernAware)aware).hasReadConcern()) continue;
            return rca.getReadConcern();
        }
        return null;
    }

    @Override
    public boolean hasReadPreference() {
        for (Object aware : this.sources) {
            ReadPreferenceAware rpa;
            if (!(aware instanceof ReadPreferenceAware) || !(rpa = (ReadPreferenceAware)aware).hasReadPreference()) continue;
            return true;
        }
        return false;
    }

    @Override
    public @Nullable ReadPreference getReadPreference() {
        for (Object aware : this.sources) {
            ReadPreferenceAware rpa;
            if (!(aware instanceof ReadPreferenceAware) || !(rpa = (ReadPreferenceAware)aware).hasReadPreference()) continue;
            return rpa.getReadPreference();
        }
        return null;
    }

    static class ReactiveCollectionPreparerDelegate
    extends CollectionPreparerSupport
    implements CollectionPreparer<com.mongodb.reactivestreams.client.MongoCollection<Document>> {
        private ReactiveCollectionPreparerDelegate(List<Object> sources) {
            super(sources);
        }

        public static ReactiveCollectionPreparerDelegate of(ReadPreferenceAware ... awares) {
            return ReactiveCollectionPreparerDelegate.of((Object[])awares);
        }

        public static ReactiveCollectionPreparerDelegate of(Object ... mixedAwares) {
            if (mixedAwares.length == 1 && mixedAwares[0] instanceof CollectionPreparerDelegate) {
                return (ReactiveCollectionPreparerDelegate)mixedAwares[0];
            }
            return new ReactiveCollectionPreparerDelegate(Arrays.asList(mixedAwares));
        }

        @Override
        public com.mongodb.reactivestreams.client.MongoCollection<Document> prepare(com.mongodb.reactivestreams.client.MongoCollection<Document> collection) {
            return this.doPrepare(collection, com.mongodb.reactivestreams.client.MongoCollection::getReadConcern, com.mongodb.reactivestreams.client.MongoCollection::withReadConcern, com.mongodb.reactivestreams.client.MongoCollection::getReadPreference, com.mongodb.reactivestreams.client.MongoCollection::withReadPreference);
        }
    }

    static class CollectionPreparerDelegate
    extends CollectionPreparerSupport
    implements CollectionPreparer<MongoCollection<Document>> {
        private CollectionPreparerDelegate(List<Object> sources) {
            super(sources);
        }

        public static CollectionPreparerDelegate of(ReadPreferenceAware ... awares) {
            return CollectionPreparerDelegate.of((Object[])awares);
        }

        public static CollectionPreparerDelegate of(Object ... mixedAwares) {
            if (mixedAwares.length == 1 && mixedAwares[0] instanceof CollectionPreparerDelegate) {
                return (CollectionPreparerDelegate)mixedAwares[0];
            }
            return new CollectionPreparerDelegate(Arrays.asList(mixedAwares));
        }

        @Override
        public MongoCollection<Document> prepare(MongoCollection<Document> collection) {
            return this.doPrepare(collection, MongoCollection::getReadConcern, MongoCollection::withReadConcern, MongoCollection::getReadPreference, MongoCollection::withReadPreference);
        }
    }
}

