/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.config;

import com.mongodb.MongoClientSettings;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.bson.UuidRepresentation;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.mapping.model.CamelCaseAbbreviatingFieldNamingStrategy;
import org.springframework.data.mapping.model.FieldNamingStrategy;
import org.springframework.data.mapping.model.PropertyNameFieldNamingStrategy;
import org.springframework.data.mongodb.MongoManagedTypes;
import org.springframework.data.mongodb.core.convert.MongoCustomConversions;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public abstract class MongoConfigurationSupport {
    protected abstract String getDatabaseName();

    protected Collection<String> getMappingBasePackages() {
        Package mappingBasePackage = this.getClass().getPackage();
        return Collections.singleton(mappingBasePackage == null ? null : mappingBasePackage.getName());
    }

    @Bean
    public MongoMappingContext mongoMappingContext(MongoCustomConversions customConversions, MongoManagedTypes mongoManagedTypes) {
        MongoMappingContext mappingContext = new MongoMappingContext();
        mappingContext.setManagedTypes(mongoManagedTypes);
        mappingContext.setSimpleTypeHolder(customConversions.getSimpleTypeHolder());
        mappingContext.setFieldNamingStrategy(this.fieldNamingStrategy());
        mappingContext.setAutoIndexCreation(this.autoIndexCreation());
        return mappingContext;
    }

    @Bean
    public MongoManagedTypes mongoManagedTypes() throws ClassNotFoundException {
        return MongoManagedTypes.fromIterable(this.getInitialEntitySet());
    }

    @Bean
    public MongoCustomConversions customConversions() {
        return MongoCustomConversions.create(this::configureConverters);
    }

    protected void configureConverters(MongoCustomConversions.MongoConverterConfigurationAdapter converterConfigurationAdapter) {
    }

    protected Set<Class<?>> getInitialEntitySet() throws ClassNotFoundException {
        HashSet initialEntitySet = new HashSet();
        for (String basePackage : this.getMappingBasePackages()) {
            initialEntitySet.addAll(this.scanForEntities(basePackage));
        }
        return initialEntitySet;
    }

    protected Set<Class<?>> scanForEntities(String basePackage) throws ClassNotFoundException {
        if (!StringUtils.hasText((String)basePackage)) {
            return Collections.emptySet();
        }
        HashSet initialEntitySet = new HashSet();
        if (StringUtils.hasText((String)basePackage)) {
            ClassPathScanningCandidateComponentProvider componentProvider = new ClassPathScanningCandidateComponentProvider(false);
            componentProvider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Document.class));
            for (BeanDefinition candidate : componentProvider.findCandidateComponents(basePackage)) {
                String beanClassName = candidate.getBeanClassName();
                Assert.notNull((Object)beanClassName, (String)"BeanClassName cannot be null");
                initialEntitySet.add(ClassUtils.forName((String)beanClassName, (ClassLoader)MongoConfigurationSupport.class.getClassLoader()));
            }
        }
        return initialEntitySet;
    }

    protected boolean abbreviateFieldNames() {
        return false;
    }

    protected FieldNamingStrategy fieldNamingStrategy() {
        return this.abbreviateFieldNames() ? new CamelCaseAbbreviatingFieldNamingStrategy() : PropertyNameFieldNamingStrategy.INSTANCE;
    }

    protected boolean autoIndexCreation() {
        return false;
    }

    protected MongoClientSettings mongoClientSettings() {
        MongoClientSettings.Builder builder = MongoClientSettings.builder();
        builder.uuidRepresentation(UuidRepresentation.STANDARD);
        this.configureClientSettings(builder);
        return builder.build();
    }

    protected void configureClientSettings(MongoClientSettings.Builder builder) {
    }
}

