/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.util.BsonUtils;
import org.springframework.util.ObjectUtils;

record BasicAggregationOperation(Object value) implements AggregationOperation
{
    @Override
    public Document toDocument(AggregationOperationContext context) {
        String json;
        Object object = this.value;
        if (object instanceof Bson) {
            Bson bson = (Bson)object;
            return BsonUtils.asDocument(bson, context.getCodecRegistry());
        }
        object = this.value;
        if (object instanceof String && BsonUtils.isJsonDocument(json = (String)object)) {
            return BsonUtils.parse(json, context);
        }
        throw new IllegalStateException(String.format("%s cannot be converted to org.bson.Document", ObjectUtils.nullSafeClassName((Object)this.value)));
    }
}

