/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.encryption;

import org.bson.BsonBinary;
import org.bson.types.Binary;
import org.springframework.data.mongodb.core.encryption.EncryptionContext;
import org.springframework.data.mongodb.core.encryption.EncryptionKey;
import org.springframework.data.mongodb.core.encryption.KeyAltName;
import org.springframework.data.mongodb.core.mapping.Encrypted;
import org.springframework.data.mongodb.core.mapping.ExplicitEncrypted;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.util.BsonUtils;
import org.springframework.data.mongodb.util.encryption.EncryptionUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@FunctionalInterface
public interface EncryptionKeyResolver {
    public EncryptionKey getKey(EncryptionContext var1);

    public static EncryptionKeyResolver annotated(EncryptionKeyResolver fallback) {
        Assert.notNull((Object)fallback, (String)"Fallback EncryptionKeyResolver must not be nul");
        return encryptionContext -> {
            MongoPersistentProperty property = encryptionContext.getProperty();
            ExplicitEncrypted annotation = (ExplicitEncrypted)property.findAnnotation(ExplicitEncrypted.class);
            if (annotation == null || !StringUtils.hasText((String)annotation.keyAltName())) {
                Encrypted encrypted = (Encrypted)property.getOwner().findAnnotation(Encrypted.class);
                if (encrypted == null) {
                    return fallback.getKey(encryptionContext);
                }
                Object o = EncryptionUtils.resolveKeyId(encrypted.keyId()[0], () -> encryptionContext.getEvaluationContext(new Object()));
                if (o instanceof BsonBinary) {
                    BsonBinary binary = (BsonBinary)o;
                    return EncryptionKey.keyId(binary);
                }
                if (o instanceof Binary) {
                    Binary binary = (Binary)o;
                    return EncryptionKey.keyId((BsonBinary)BsonUtils.simpleToBsonValue(binary));
                }
                if (o instanceof String) {
                    String string = (String)o;
                    return EncryptionKey.keyAltName(string);
                }
                throw new IllegalStateException(String.format("Cannot determine encryption key for %s.%s using key type %s", property.getOwner().getName(), property.getName(), o == null ? "null" : o.getClass().getName()));
            }
            String keyAltName = annotation.keyAltName();
            if (keyAltName.startsWith("/")) {
                Object fieldValue = encryptionContext.lookupValue(keyAltName.replace("/", ""));
                if (fieldValue == null) {
                    throw new IllegalStateException(String.format("Key Alternative Name for %s was null", keyAltName));
                }
                return new KeyAltName(fieldValue.toString());
            }
            return new KeyAltName(keyAltName);
        };
    }
}

