/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.schema;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.bson.BsonTimestamp;
import org.bson.Document;
import org.bson.types.BSONTimestamp;
import org.bson.types.Binary;
import org.bson.types.Code;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.core.schema.TypedJsonSchemaObject;
import org.springframework.data.mongodb.core.schema.UntypedJsonSchemaObject;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public interface JsonSchemaObject {
    public Set<Type> getTypes();

    public Document toDocument();

    public static TypedJsonSchemaObject.ObjectJsonSchemaObject object() {
        return new TypedJsonSchemaObject.ObjectJsonSchemaObject();
    }

    public static TypedJsonSchemaObject.StringJsonSchemaObject string() {
        return new TypedJsonSchemaObject.StringJsonSchemaObject();
    }

    public static TypedJsonSchemaObject.NumericJsonSchemaObject number() {
        return new TypedJsonSchemaObject.NumericJsonSchemaObject();
    }

    public static TypedJsonSchemaObject.ArrayJsonSchemaObject array() {
        return new TypedJsonSchemaObject.ArrayJsonSchemaObject();
    }

    public static TypedJsonSchemaObject.BooleanJsonSchemaObject bool() {
        return new TypedJsonSchemaObject.BooleanJsonSchemaObject();
    }

    public static TypedJsonSchemaObject.NullJsonSchemaObject nil() {
        return new TypedJsonSchemaObject.NullJsonSchemaObject();
    }

    public static TypedJsonSchemaObject.DateJsonSchemaObject date() {
        return new TypedJsonSchemaObject.DateJsonSchemaObject();
    }

    public static TypedJsonSchemaObject.TimestampJsonSchemaObject timestamp() {
        return new TypedJsonSchemaObject.TimestampJsonSchemaObject();
    }

    public static TypedJsonSchemaObject of(Type type) {
        return TypedJsonSchemaObject.of(new Type[]{type});
    }

    public static UntypedJsonSchemaObject untyped() {
        return new UntypedJsonSchemaObject(null, null, false);
    }

    public static TypedJsonSchemaObject of(@Nullable Class<?> type) {
        if (type == null) {
            return JsonSchemaObject.of(Type.nullType());
        }
        if (type.isArray() || ClassUtils.isAssignable(Collection.class, type)) {
            if (type.equals(byte[].class)) {
                return JsonSchemaObject.of(Type.binaryType());
            }
            return JsonSchemaObject.of(Type.arrayType());
        }
        if (type.equals(Document.class) || ClassUtils.isAssignable(Map.class, type)) {
            return JsonSchemaObject.of(Type.objectType());
        }
        if (type.equals(Object.class)) {
            return JsonSchemaObject.of(Type.objectType());
        }
        if (type.equals(ObjectId.class)) {
            return JsonSchemaObject.of(Type.objectIdType());
        }
        if (ClassUtils.isAssignable(String.class, type)) {
            return JsonSchemaObject.of(Type.stringType());
        }
        if (ClassUtils.isAssignable(Date.class, type)) {
            return JsonSchemaObject.of(Type.dateType());
        }
        if (ClassUtils.isAssignable(Binary.class, type)) {
            return JsonSchemaObject.of(Type.binaryType());
        }
        if (ClassUtils.isAssignable(Code.class, type)) {
            return JsonSchemaObject.of(Type.javascriptType());
        }
        if (ClassUtils.isAssignable(Decimal128.class, type)) {
            return JsonSchemaObject.of(Type.bigDecimalType());
        }
        if (ClassUtils.isAssignable(BsonTimestamp.class, type) || ClassUtils.isAssignable(BSONTimestamp.class, type)) {
            return JsonSchemaObject.of(Type.timestampType());
        }
        if (ClassUtils.isAssignable(Pattern.class, type)) {
            return JsonSchemaObject.of(Type.regexType());
        }
        if (ClassUtils.isAssignable(Enum.class, type)) {
            return JsonSchemaObject.of(Type.stringType());
        }
        Class resolved = ClassUtils.resolvePrimitiveIfNecessary(type);
        if (ClassUtils.isAssignable(Boolean.class, (Class)resolved)) {
            return JsonSchemaObject.of(Type.booleanType());
        }
        if (ClassUtils.isAssignable(Number.class, (Class)resolved)) {
            if (resolved.equals(Long.class)) {
                return JsonSchemaObject.of(Type.longType());
            }
            if (resolved.equals(Float.class)) {
                return JsonSchemaObject.of(Type.doubleType());
            }
            if (resolved.equals(Double.class)) {
                return JsonSchemaObject.of(Type.doubleType());
            }
            if (resolved.equals(Integer.class)) {
                return JsonSchemaObject.of(Type.intType());
            }
            if (resolved.equals(BigDecimal.class)) {
                return JsonSchemaObject.of(Type.bigDecimalType());
            }
            return JsonSchemaObject.of(Type.numberType());
        }
        throw new IllegalArgumentException(String.format("No JSON schema type found for %s", type));
    }

    public static interface Type {
        public static final Type OBJECT_ID = Type.bsonTypeOf("objectId");
        public static final Type REGULAR_EXPRESSION = Type.bsonTypeOf("regex");
        public static final Type DOUBLE = Type.bsonTypeOf("double");
        public static final Type BINARY_DATA = Type.bsonTypeOf("binData");
        public static final Type DATE = Type.bsonTypeOf("date");
        public static final Type JAVA_SCRIPT = Type.bsonTypeOf("javascript");
        public static final Type INT_32 = Type.bsonTypeOf("int");
        public static final Type INT_64 = Type.bsonTypeOf("long");
        public static final Type DECIMAL_128 = Type.bsonTypeOf("decimal");
        public static final Type TIMESTAMP = Type.bsonTypeOf("timestamp");
        public static final Set<Type> BSON_TYPES = new HashSet<Type>(Arrays.asList(OBJECT_ID, REGULAR_EXPRESSION, DOUBLE, BINARY_DATA, DATE, JAVA_SCRIPT, INT_32, INT_64, DECIMAL_128, TIMESTAMP));
        public static final Type OBJECT = Type.jsonTypeOf("object");
        public static final Type ARRAY = Type.jsonTypeOf("array");
        public static final Type NUMBER = Type.jsonTypeOf("number");
        public static final Type BOOLEAN = Type.jsonTypeOf("boolean");
        public static final Type STRING = Type.jsonTypeOf("string");
        public static final Type NULL = Type.jsonTypeOf("null");
        public static final Set<Type> JSON_TYPES = new HashSet<Type>(Arrays.asList(OBJECT, ARRAY, NUMBER, BOOLEAN, STRING, NULL));

        public static Type objectIdType() {
            return OBJECT_ID;
        }

        public static Type regexType() {
            return REGULAR_EXPRESSION;
        }

        public static Type doubleType() {
            return DOUBLE;
        }

        public static Type binaryType() {
            return BINARY_DATA;
        }

        public static Type dateType() {
            return DATE;
        }

        public static Type javascriptType() {
            return JAVA_SCRIPT;
        }

        public static Type intType() {
            return INT_32;
        }

        public static Type longType() {
            return INT_64;
        }

        public static Type bigDecimalType() {
            return DECIMAL_128;
        }

        public static Type timestampType() {
            return TIMESTAMP;
        }

        public static Type objectType() {
            return OBJECT;
        }

        public static Type arrayType() {
            return ARRAY;
        }

        public static Type numberType() {
            return NUMBER;
        }

        public static Type booleanType() {
            return BOOLEAN;
        }

        public static Type stringType() {
            return STRING;
        }

        public static Type nullType() {
            return NULL;
        }

        public static Type bsonTypeOf(String name) {
            return new BsonType(name);
        }

        public static Type jsonTypeOf(String name) {
            return new JsonType(name);
        }

        public static Type of(String name) {
            Type type = Type.jsonTypeOf(name);
            if (Type.jsonTypes().contains(type)) {
                return type;
            }
            return Type.bsonTypeOf(name);
        }

        public static Set<Type> jsonTypes() {
            return JSON_TYPES;
        }

        public static Set<Type> bsonTypes() {
            return BSON_TYPES;
        }

        public String representation();

        public Object value();

        default public Type toBsonType() {
            if (this.representation().equals("bsonType")) {
                return this;
            }
            if (this.value().equals(Type.booleanType().value())) {
                return Type.bsonTypeOf("bool");
            }
            if (this.value().equals(Type.numberType().value())) {
                return Type.bsonTypeOf("long");
            }
            return Type.bsonTypeOf((String)this.value());
        }

        public static class BsonType
        implements Type {
            private final String name;

            BsonType(String name) {
                this.name = name;
            }

            @Override
            public String representation() {
                return "bsonType";
            }

            @Override
            public String value() {
                return this.name;
            }

            public boolean equals(@Nullable Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                BsonType bsonType = (BsonType)o;
                return ObjectUtils.nullSafeEquals((Object)this.name, (Object)bsonType.name);
            }

            public int hashCode() {
                return ObjectUtils.nullSafeHashCode((Object)this.name);
            }
        }

        public static class JsonType
        implements Type {
            private final String name;

            public JsonType(String name) {
                this.name = name;
            }

            @Override
            public String representation() {
                return "type";
            }

            @Override
            public String value() {
                return this.name;
            }

            public boolean equals(@Nullable Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                JsonType jsonType = (JsonType)o;
                return ObjectUtils.nullSafeEquals((Object)this.name, (Object)jsonType.name);
            }

            public int hashCode() {
                return ObjectUtils.nullSafeHashCode((Object)this.name);
            }
        }
    }
}

