/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.observability;

import com.mongodb.ConnectionString;
import com.mongodb.RequestContext;
import com.mongodb.event.CommandFailedEvent;
import com.mongodb.event.CommandListener;
import com.mongodb.event.CommandStartedEvent;
import com.mongodb.event.CommandSucceededEvent;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.mongodb.observability.DefaultMongoHandlerObservationConvention;
import org.springframework.data.mongodb.observability.MongoHandlerContext;
import org.springframework.data.mongodb.observability.MongoHandlerObservationConvention;
import org.springframework.data.mongodb.observability.MongoObservation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class MongoObservationCommandListener
implements CommandListener {
    private static final Log log = LogFactory.getLog(MongoObservationCommandListener.class);
    private final ObservationRegistry observationRegistry;
    @Nullable
    private final ConnectionString connectionString;
    private final MongoHandlerObservationConvention observationConvention = new DefaultMongoHandlerObservationConvention();

    public MongoObservationCommandListener(ObservationRegistry observationRegistry) {
        Assert.notNull((Object)observationRegistry, (String)"ObservationRegistry must not be null");
        this.observationRegistry = observationRegistry;
        this.connectionString = null;
    }

    public MongoObservationCommandListener(ObservationRegistry observationRegistry, ConnectionString connectionString) {
        Assert.notNull((Object)observationRegistry, (String)"ObservationRegistry must not be null");
        Assert.notNull((Object)connectionString, (String)"ConnectionString must not be null");
        this.observationRegistry = observationRegistry;
        this.connectionString = connectionString;
    }

    public void commandStarted(CommandStartedEvent event) {
        String databaseName;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Instrumenting the command started event");
        }
        if ("admin".equals(databaseName = event.getDatabaseName())) {
            return;
        }
        RequestContext requestContext = event.getRequestContext();
        if (requestContext == null) {
            return;
        }
        Observation parent = MongoObservationCommandListener.observationFromContext(requestContext);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found the following observation passed from the mongo context [" + parent + "]"));
        }
        MongoHandlerContext observationContext = new MongoHandlerContext(this.connectionString, event, requestContext);
        observationContext.setRemoteServiceName("mongo");
        Observation observation = MongoObservation.MONGODB_COMMAND_OBSERVATION.observation(this.observationRegistry, () -> observationContext).observationConvention((ObservationConvention)this.observationConvention);
        if (parent != null) {
            observation.parentObservation(parent);
        }
        observation.start();
        requestContext.put((Object)"micrometer.observation", (Object)observation);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created a child observation  [" + observation + "] for Mongo instrumentation and put it in Mongo context"));
        }
    }

    public void commandSucceeded(CommandSucceededEvent event) {
        RequestContext requestContext = event.getRequestContext();
        if (requestContext == null) {
            return;
        }
        Observation observation = (Observation)requestContext.getOrDefault((Object)"micrometer.observation", null);
        if (observation == null) {
            return;
        }
        MongoHandlerContext context = (MongoHandlerContext)observation.getContext();
        context.setCommandSucceededEvent(event);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Command succeeded - will stop observation [" + observation + "]"));
        }
        observation.stop();
    }

    public void commandFailed(CommandFailedEvent event) {
        RequestContext requestContext = event.getRequestContext();
        if (requestContext == null) {
            return;
        }
        Observation observation = (Observation)requestContext.getOrDefault((Object)"micrometer.observation", null);
        if (observation == null) {
            return;
        }
        MongoHandlerContext context = (MongoHandlerContext)observation.getContext();
        context.setCommandFailedEvent(event);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Command failed - will stop observation [" + observation + "]"));
        }
        observation.error(event.getThrowable());
        observation.stop();
    }

    @Nullable
    private static Observation observationFromContext(RequestContext context) {
        Observation observation = (Observation)context.getOrDefault((Object)"micrometer.observation", null);
        if (observation != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found a observation in Mongo context [" + observation + "]"));
            }
            return observation;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"No observation was found - will not create any child observations");
        }
        return null;
    }
}

