/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.gridfs;

import com.mongodb.client.MongoDatabase;
import com.mongodb.client.gridfs.GridFSBucket;
import com.mongodb.client.gridfs.GridFSBuckets;
import com.mongodb.client.gridfs.GridFSFindIterable;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.client.gridfs.model.GridFSUploadOptions;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Optional;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.gridfs.AntPath;
import org.springframework.data.mongodb.gridfs.GridFsCriteria;
import org.springframework.data.mongodb.gridfs.GridFsObject;
import org.springframework.data.mongodb.gridfs.GridFsOperations;
import org.springframework.data.mongodb.gridfs.GridFsOperationsSupport;
import org.springframework.data.mongodb.gridfs.GridFsResource;
import org.springframework.data.mongodb.util.BsonUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class GridFsTemplate
extends GridFsOperationsSupport
implements GridFsOperations,
ResourcePatternResolver {
    private final MongoDatabaseFactory dbFactory;
    @Nullable
    private final String bucket;

    public GridFsTemplate(MongoDatabaseFactory dbFactory, MongoConverter converter) {
        this(dbFactory, converter, null);
    }

    public GridFsTemplate(MongoDatabaseFactory dbFactory, MongoConverter converter, @Nullable String bucket) {
        super(converter);
        Assert.notNull((Object)dbFactory, (String)"MongoDbFactory must not be null!");
        this.dbFactory = dbFactory;
        this.bucket = bucket;
    }

    @Override
    public ObjectId store(InputStream content, @Nullable String filename, @Nullable String contentType, @Nullable Object metadata) {
        return this.store(content, filename, contentType, this.toDocument(metadata));
    }

    @Override
    public <T> T store(GridFsObject<T, InputStream> upload) {
        GridFSUploadOptions uploadOptions = this.computeUploadOptionsFor(upload.getOptions().getContentType(), upload.getOptions().getMetadata());
        if (upload.getOptions().getChunkSize() > 0) {
            uploadOptions.chunkSizeBytes(Integer.valueOf(upload.getOptions().getChunkSize()));
        }
        if (upload.getFileId() == null) {
            return (T)this.getGridFs().uploadFromStream(upload.getFilename(), upload.getContent(), uploadOptions);
        }
        this.getGridFs().uploadFromStream(BsonUtils.simpleToBsonValue(upload.getFileId()), upload.getFilename(), upload.getContent(), uploadOptions);
        return upload.getFileId();
    }

    @Override
    public GridFSFindIterable find(Query query) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Document queryObject = this.getMappedQuery(query.getQueryObject());
        Document sortObject = this.getMappedQuery(query.getSortObject());
        GridFSFindIterable iterable = this.getGridFs().find((Bson)queryObject).sort((Bson)sortObject);
        if (query.getSkip() > 0L) {
            iterable = iterable.skip(Math.toIntExact(query.getSkip()));
        }
        if (query.getLimit() > 0) {
            iterable = iterable.limit(query.getLimit());
        }
        return iterable;
    }

    @Override
    public GridFSFile findOne(Query query) {
        return (GridFSFile)this.find(query).first();
    }

    @Override
    public void delete(Query query) {
        for (GridFSFile gridFSFile : this.find(query)) {
            this.getGridFs().delete(gridFSFile.getId());
        }
    }

    public ClassLoader getClassLoader() {
        return this.dbFactory.getClass().getClassLoader();
    }

    @Override
    public GridFsResource getResource(String location) {
        return Optional.ofNullable(this.findOne(Query.query(GridFsCriteria.whereFilename().is(location)))).map(this::getResource).orElseGet(() -> GridFsResource.absent(location));
    }

    @Override
    public GridFsResource getResource(GridFSFile file) {
        Assert.notNull((Object)file, (String)"GridFSFile must not be null!");
        return new GridFsResource(file, (InputStream)this.getGridFs().openDownloadStream(file.getId()));
    }

    @Override
    public GridFsResource[] getResources(String locationPattern) {
        if (!StringUtils.hasText((String)locationPattern)) {
            return new GridFsResource[0];
        }
        AntPath path = new AntPath(locationPattern);
        if (path.isPattern()) {
            GridFSFindIterable files = this.find(Query.query(GridFsCriteria.whereFilename().regex(path.toRegex())));
            ArrayList<GridFsResource> resources = new ArrayList<GridFsResource>();
            for (GridFSFile file : files) {
                resources.add(this.getResource(file));
            }
            return resources.toArray(new GridFsResource[0]);
        }
        return new GridFsResource[]{this.getResource(locationPattern)};
    }

    private GridFSBucket getGridFs() {
        MongoDatabase db = this.dbFactory.getMongoDatabase();
        return this.bucket == null ? GridFSBuckets.create((MongoDatabase)db) : GridFSBuckets.create((MongoDatabase)db, (String)this.bucket);
    }
}

