/*
 * Copyright 2011-2023 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.data.mongodb.core.index;

import org.bson.Document;

/**
 * @author Jon Brisbin <jbrisbin@vmware.com>
 * @author Christoph Strobl
 * @author Mark Paluch
 */
public interface IndexDefinition {

	/**
	 * Get the {@link Document} containing properties covered by the index.
	 *
	 * @return never {@literal null}.
	 */
	Document getIndexKeys();

	/**
	 * Get the index properties such as {@literal unique},...
	 *
	 * @return never {@literal null}.
	 */
	Document getIndexOptions();
}
