/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapping;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.AssociationHandler;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.mongodb.MongoCollectionUtils;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.mapping.ShardKey;
import org.springframework.data.mongodb.core.mapping.Sharded;
import org.springframework.data.mongodb.core.mapping.ShardingStrategy;
import org.springframework.data.mongodb.core.mapping.TextScore;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class BasicMongoPersistentEntity<T>
extends BasicPersistentEntity<T, MongoPersistentProperty>
implements MongoPersistentEntity<T> {
    private static final String AMBIGUOUS_FIELD_MAPPING = "Ambiguous field mapping detected! Both %s and %s map to the same field name %s! Disambiguate using @Field annotation!";
    private static final SpelExpressionParser PARSER = new SpelExpressionParser();
    private final String collection;
    private final String language;
    @Nullable
    private final Expression expression;
    @Nullable
    private final String collation;
    @Nullable
    private final Expression collationExpression;
    private final ShardKey shardKey;

    public BasicMongoPersistentEntity(TypeInformation<T> typeInformation) {
        super(typeInformation, (Comparator)MongoPersistentPropertyComparator.INSTANCE);
        Class rawType = typeInformation.getType();
        String fallback = MongoCollectionUtils.getPreferredCollectionName(rawType);
        if (this.isAnnotationPresent(Document.class)) {
            Document document = (Document)this.getRequiredAnnotation(Document.class);
            this.collection = StringUtils.hasText((String)document.collection()) ? document.collection() : fallback;
            this.language = StringUtils.hasText((String)document.language()) ? document.language() : "";
            this.expression = BasicMongoPersistentEntity.detectExpression(document.collection());
            this.collation = document.collation();
            this.collationExpression = BasicMongoPersistentEntity.detectExpression(document.collation());
        } else {
            this.collection = fallback;
            this.language = "";
            this.expression = null;
            this.collation = null;
            this.collationExpression = null;
        }
        this.shardKey = this.detectShardKey();
    }

    private ShardKey detectShardKey() {
        if (!this.isAnnotationPresent(Sharded.class)) {
            return ShardKey.none();
        }
        Sharded sharded = (Sharded)this.getRequiredAnnotation(Sharded.class);
        Object[] keyProperties = sharded.shardKey();
        if (ObjectUtils.isEmpty((Object[])keyProperties)) {
            keyProperties = new String[]{"_id"};
        }
        ShardKey shardKey = ShardingStrategy.HASH.equals((Object)sharded.shardingStrategy()) ? ShardKey.hash((String[])keyProperties) : ShardKey.range((String[])keyProperties);
        return sharded.immutableKey() ? ShardKey.immutable(shardKey) : shardKey;
    }

    @Override
    public String getCollection() {
        return this.expression == null ? this.collection : (String)this.expression.getValue(this.getEvaluationContext(null), String.class);
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    @Nullable
    public MongoPersistentProperty getTextScoreProperty() {
        return (MongoPersistentProperty)this.getPersistentProperty(TextScore.class);
    }

    @Override
    public boolean hasTextScoreProperty() {
        return this.getTextScoreProperty() != null;
    }

    @Override
    public Collation getCollation() {
        String collationValue;
        String string = collationValue = this.collationExpression != null ? this.collationExpression.getValue(this.getEvaluationContext(null), String.class) : this.collation;
        if (collationValue == null) {
            return null;
        }
        if (collationValue instanceof org.bson.Document) {
            return Collation.from((org.bson.Document)collationValue);
        }
        if (collationValue instanceof Collation) {
            return (Collation)Collation.class.cast(collationValue);
        }
        return StringUtils.hasText((String)collationValue.toString()) ? Collation.parse(collationValue.toString()) : null;
    }

    @Override
    public ShardKey getShardKey() {
        return this.shardKey;
    }

    public void verify() {
        super.verify();
        this.verifyFieldUniqueness();
        this.verifyFieldTypes();
    }

    public EvaluationContext getEvaluationContext(Object rootObject) {
        return super.getEvaluationContext(rootObject);
    }

    private void verifyFieldUniqueness() {
        AssertFieldNameUniquenessHandler handler = new AssertFieldNameUniquenessHandler();
        this.doWithProperties(handler);
        this.doWithAssociations(handler);
    }

    private void verifyFieldTypes() {
        this.doWithProperties(new PropertyTypeAssertionHandler());
    }

    protected MongoPersistentProperty returnPropertyIfBetterIdPropertyCandidateOrNull(MongoPersistentProperty property) {
        Assert.notNull((Object)property, (String)"MongoPersistentProperty must not be null!");
        if (!property.isIdProperty()) {
            return null;
        }
        MongoPersistentProperty currentIdProperty = (MongoPersistentProperty)this.getIdProperty();
        boolean currentIdPropertyIsSet = currentIdProperty != null;
        boolean currentIdPropertyIsExplicit = currentIdPropertyIsSet ? currentIdProperty.isExplicitIdProperty() : false;
        boolean newIdPropertyIsExplicit = property.isExplicitIdProperty();
        if (!currentIdPropertyIsSet) {
            return property;
        }
        Field currentIdPropertyField = currentIdProperty.getField();
        if (newIdPropertyIsExplicit && currentIdPropertyIsExplicit) {
            throw new MappingException(String.format("Attempt to add explicit id property %s but already have an property %s registered as explicit id. Check your mapping configuration!", property.getField(), currentIdPropertyField));
        }
        if (newIdPropertyIsExplicit && !currentIdPropertyIsExplicit) {
            return property;
        }
        if (newIdPropertyIsExplicit || !currentIdPropertyIsExplicit) {
            throw new MappingException(String.format("Attempt to add id property %s but already have an property %s registered as id. Check your mapping configuration!", property.getField(), currentIdPropertyField));
        }
        return null;
    }

    @Nullable
    private static Expression detectExpression(@Nullable String potentialExpression) {
        if (!StringUtils.hasText((String)potentialExpression)) {
            return null;
        }
        Expression expression = PARSER.parseExpression(potentialExpression, ParserContext.TEMPLATE_EXPRESSION);
        return expression instanceof LiteralExpression ? null : expression;
    }

    private static class PropertyTypeAssertionHandler
    implements PropertyHandler<MongoPersistentProperty> {
        private PropertyTypeAssertionHandler() {
        }

        public void doWithPersistentProperty(MongoPersistentProperty persistentProperty) {
            PropertyTypeAssertionHandler.potentiallyAssertTextScoreType(persistentProperty);
            PropertyTypeAssertionHandler.potentiallyAssertLanguageType(persistentProperty);
            PropertyTypeAssertionHandler.potentiallyAssertDBRefTargetType(persistentProperty);
        }

        private static void potentiallyAssertLanguageType(MongoPersistentProperty persistentProperty) {
            if (persistentProperty.isExplicitLanguageProperty()) {
                PropertyTypeAssertionHandler.assertPropertyType(persistentProperty, String.class);
            }
        }

        private static void potentiallyAssertTextScoreType(MongoPersistentProperty persistentProperty) {
            if (persistentProperty.isTextScoreProperty()) {
                PropertyTypeAssertionHandler.assertPropertyType(persistentProperty, Float.class, Double.class);
            }
        }

        private static void potentiallyAssertDBRefTargetType(MongoPersistentProperty persistentProperty) {
            if (persistentProperty.isDbReference() && persistentProperty.getDBRef().lazy() && (persistentProperty.isArray() || Modifier.isFinal(persistentProperty.getActualType().getModifiers()))) {
                throw new MappingException(String.format("Invalid lazy DBRef property for %s. Found %s which must not be an array nor a final class.", persistentProperty.getField(), persistentProperty.getActualType()));
            }
        }

        private static void assertPropertyType(MongoPersistentProperty persistentProperty, Class<?> ... validMatches) {
            for (Class<?> potentialMatch : validMatches) {
                if (!ClassUtils.isAssignable(potentialMatch, (Class)persistentProperty.getActualType())) continue;
                return;
            }
            throw new MappingException(String.format("Missmatching types for %s. Found %s expected one of %s.", persistentProperty.getField(), persistentProperty.getActualType(), StringUtils.arrayToCommaDelimitedString((Object[])validMatches)));
        }
    }

    private static class AssertFieldNameUniquenessHandler
    implements PropertyHandler<MongoPersistentProperty>,
    AssociationHandler<MongoPersistentProperty> {
        private final Map<String, MongoPersistentProperty> properties = new HashMap<String, MongoPersistentProperty>();

        private AssertFieldNameUniquenessHandler() {
        }

        public void doWithPersistentProperty(MongoPersistentProperty persistentProperty) {
            this.assertUniqueness(persistentProperty);
        }

        public void doWithAssociation(Association<MongoPersistentProperty> association) {
            this.assertUniqueness((MongoPersistentProperty)association.getInverse());
        }

        private void assertUniqueness(MongoPersistentProperty property) {
            String fieldName = property.getFieldName();
            MongoPersistentProperty existingProperty = this.properties.get(fieldName);
            if (existingProperty != null) {
                throw new MappingException(String.format(BasicMongoPersistentEntity.AMBIGUOUS_FIELD_MAPPING, property.toString(), existingProperty.toString(), fieldName));
            }
            this.properties.put(fieldName, property);
        }
    }

    static enum MongoPersistentPropertyComparator implements Comparator<MongoPersistentProperty>
    {
        INSTANCE;


        @Override
        public int compare(@Nullable MongoPersistentProperty o1, @Nullable MongoPersistentProperty o2) {
            if (o1 != null && o1.getFieldOrder() == Integer.MAX_VALUE) {
                return 1;
            }
            if (o2 != null && o2.getFieldOrder() == Integer.MAX_VALUE) {
                return -1;
            }
            if (o1 == null && o2 == null) {
                return -1;
            }
            return o1.getFieldOrder() - o2.getFieldOrder();
        }
    }
}

