/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import java.math.BigInteger;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.convert.EntityInstantiators;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverters;
import org.springframework.data.mongodb.core.convert.MongoCustomConversions;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class AbstractMongoConverter
implements MongoConverter,
InitializingBean {
    protected final GenericConversionService conversionService;
    protected CustomConversions conversions = new MongoCustomConversions();
    protected EntityInstantiators instantiators = new EntityInstantiators();

    public AbstractMongoConverter(@Nullable GenericConversionService conversionService) {
        this.conversionService = conversionService == null ? new DefaultConversionService() : conversionService;
    }

    public void setCustomConversions(CustomConversions conversions) {
        Assert.notNull((Object)conversions, (String)"Conversions must not be null!");
        this.conversions = conversions;
    }

    public void setInstantiators(@Nullable EntityInstantiators instantiators) {
        this.instantiators = instantiators == null ? new EntityInstantiators() : instantiators;
    }

    private void initializeConverters() {
        this.conversionService.addConverter((Converter)MongoConverters.ObjectIdToStringConverter.INSTANCE);
        this.conversionService.addConverter((Converter)MongoConverters.StringToObjectIdConverter.INSTANCE);
        if (!this.conversionService.canConvert(ObjectId.class, BigInteger.class)) {
            this.conversionService.addConverter((Converter)MongoConverters.ObjectIdToBigIntegerConverter.INSTANCE);
        }
        if (!this.conversionService.canConvert(BigInteger.class, ObjectId.class)) {
            this.conversionService.addConverter((Converter)MongoConverters.BigIntegerToObjectIdConverter.INSTANCE);
        }
        this.conversions.registerConvertersIn((ConverterRegistry)this.conversionService);
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public void afterPropertiesSet() {
        this.initializeConverters();
    }
}

