/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.index;

import java.beans.ConstructorProperties;
import lombok.NonNull;
import org.bson.Document;
import org.springframework.data.mongodb.core.index.IndexFilter;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;

public class PartialIndexFilter
implements IndexFilter {
    @NonNull
    private final Object filterExpression;

    public static PartialIndexFilter of(Document where) {
        return new PartialIndexFilter(where);
    }

    public static PartialIndexFilter of(CriteriaDefinition where) {
        return new PartialIndexFilter(where);
    }

    @Override
    public Document getFilterObject() {
        if (this.filterExpression instanceof Document) {
            return (Document)this.filterExpression;
        }
        if (this.filterExpression instanceof CriteriaDefinition) {
            return ((CriteriaDefinition)this.filterExpression).getCriteriaObject();
        }
        throw new IllegalArgumentException(String.format("Unknown type %s used as filter expression.", this.filterExpression.getClass()));
    }

    @ConstructorProperties(value={"filterExpression"})
    private PartialIndexFilter(@NonNull Object filterExpression) {
        if (filterExpression == null) {
            throw new IllegalArgumentException("filterExpression is null");
        }
        this.filterExpression = filterExpression;
    }
}

