/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import com.mongodb.util.JSON;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import org.springframework.data.mongodb.repository.query.MongoParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoParameters;
import org.springframework.data.mongodb.repository.query.StringBasedMongoQuery;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.Parameters;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

class ExpressionEvaluatingParameterBinder {
    private final SpelExpressionParser expressionParser;
    private final EvaluationContextProvider evaluationContextProvider;

    public ExpressionEvaluatingParameterBinder(SpelExpressionParser expressionParser, EvaluationContextProvider evaluationContextProvider) {
        Assert.notNull((Object)expressionParser, (String)"ExpressionParser must not be null!");
        Assert.notNull((Object)evaluationContextProvider, (String)"EvaluationContextProvider must not be null!");
        this.expressionParser = expressionParser;
        this.evaluationContextProvider = evaluationContextProvider;
    }

    public String bind(String raw, MongoParameterAccessor accessor, BindingContext bindingContext) {
        if (!StringUtils.hasText((String)raw)) {
            return null;
        }
        return this.replacePlaceholders(raw, accessor, bindingContext);
    }

    private String replacePlaceholders(String input, MongoParameterAccessor accessor, BindingContext bindingContext) {
        if (!bindingContext.hasBindings()) {
            return input;
        }
        boolean isCompletlyParameterizedQuery = input.matches("^\\?\\d+$");
        StringBuilder result = new StringBuilder(input);
        for (StringBasedMongoQuery.ParameterBinding binding : bindingContext.getBindings()) {
            String parameter = binding.getParameter();
            int idx = result.indexOf(parameter);
            if (idx == -1) continue;
            String valueForBinding = this.getParameterValueForBinding(accessor, bindingContext.getParameters(), binding);
            int start = idx;
            int end = idx + parameter.length();
            if (valueForBinding.startsWith("{") && !isCompletlyParameterizedQuery) {
                char beforeStart = result.charAt(start - 1);
                char afterEnd = result.charAt(end);
                if (!(beforeStart != '\'' && beforeStart != '\"' || afterEnd != '\'' && afterEnd != '\"')) {
                    --start;
                    ++end;
                }
            }
            result.replace(start, end, valueForBinding);
        }
        return result.toString();
    }

    private String getParameterValueForBinding(MongoParameterAccessor accessor, MongoParameters parameters, StringBasedMongoQuery.ParameterBinding binding) {
        Object value;
        Object object = value = binding.isExpression() ? this.evaluateExpression(binding.getExpression(), parameters, accessor.getValues()) : accessor.getBindableValue(binding.getParameterIndex());
        if (value instanceof String && binding.isQuoted()) {
            return (String)value;
        }
        if (value instanceof byte[]) {
            String base64representation = DatatypeConverter.printBase64Binary((byte[])((byte[])value));
            if (!binding.isQuoted()) {
                return "{ '$binary' : '" + base64representation + "', '$type' : " + 0 + "}";
            }
            return base64representation;
        }
        return JSON.serialize((Object)value);
    }

    private Object evaluateExpression(String expressionString, MongoParameters parameters, Object[] parameterValues) {
        EvaluationContext evaluationContext = this.evaluationContextProvider.getEvaluationContext((Parameters)parameters, parameterValues);
        Expression expression = this.expressionParser.parseExpression(expressionString);
        return expression.getValue(evaluationContext, Object.class);
    }

    static class BindingContext {
        final MongoParameters parameters;
        final List<StringBasedMongoQuery.ParameterBinding> bindings;

        public BindingContext(MongoParameters parameters, List<StringBasedMongoQuery.ParameterBinding> bindings) {
            this.parameters = parameters;
            this.bindings = bindings;
        }

        boolean hasBindings() {
            return !CollectionUtils.isEmpty(this.bindings);
        }

        public List<StringBasedMongoQuery.ParameterBinding> getBindings() {
            return Collections.unmodifiableList(this.bindings);
        }

        public MongoParameters getParameters() {
            return this.parameters;
        }
    }
}

