/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapping.event;

import org.springframework.context.ApplicationListener;
import org.springframework.data.auditing.IsNewAwareAuditingHandler;
import org.springframework.data.mongodb.core.mapping.event.BeforeConvertEvent;
import org.springframework.util.Assert;

public class AuditingEventListener
implements ApplicationListener<BeforeConvertEvent<Object>> {
    private final IsNewAwareAuditingHandler auditingHandler;

    public AuditingEventListener(IsNewAwareAuditingHandler auditingHandler) {
        Assert.notNull((Object)auditingHandler, (String)"IsNewAwareAuditingHandler must not be null!");
        this.auditingHandler = auditingHandler;
    }

    public void onApplicationEvent(BeforeConvertEvent<Object> event) {
        Object entity = event.getSource();
        this.auditingHandler.markAudited(entity);
    }
}

