/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bson.BSONObject;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.ExposedFields;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.aggregation.FieldsExposingAggregationOperation;
import org.springframework.data.mongodb.core.aggregation.SpelExpressionTransformer;
import org.springframework.util.Assert;

public class ProjectionOperation
implements FieldsExposingAggregationOperation {
    private static final List<Projection> NONE = Collections.emptyList();
    private static final String EXCLUSION_ERROR = "Exclusion of field %s not allowed. Projections by the mongodb aggregation framework only support the exclusion of the %s field!";
    private final List<Projection> projections;

    public ProjectionOperation() {
        this(NONE, NONE);
    }

    public ProjectionOperation(Fields fields) {
        this(NONE, ProjectionOperationBuilder.FieldProjection.from(fields));
    }

    private ProjectionOperation(List<? extends Projection> current, List<? extends Projection> projections) {
        Assert.notNull(current, (String)"Current projections must not be null!");
        Assert.notNull(projections, (String)"Projections must not be null!");
        this.projections = new ArrayList<Projection>(current.size() + projections.size());
        this.projections.addAll(current);
        this.projections.addAll(projections);
    }

    private ProjectionOperation and(Projection projection) {
        return new ProjectionOperation(this.projections, Arrays.asList(projection));
    }

    private ProjectionOperation andReplaceLastOneWith(Projection projection) {
        List projections = this.projections.isEmpty() ? Collections.emptyList() : this.projections.subList(0, this.projections.size() - 1);
        return new ProjectionOperation(projections, Arrays.asList(projection));
    }

    public ProjectionOperationBuilder and(String name) {
        return new ProjectionOperationBuilder(name, this, null);
    }

    public ExpressionProjectionOperationBuilder andExpression(String expression, Object ... params) {
        return new ExpressionProjectionOperationBuilder(expression, this, params);
    }

    public ProjectionOperation andExclude(String ... fieldNames) {
        for (String fieldName : fieldNames) {
            Assert.isTrue((boolean)Fields.UNDERSCORE_ID.equals(fieldName), (String)String.format(EXCLUSION_ERROR, fieldName, Fields.UNDERSCORE_ID));
        }
        List<ProjectionOperationBuilder.FieldProjection> excludeProjections = ProjectionOperationBuilder.FieldProjection.from(Fields.fields(fieldNames), false);
        return new ProjectionOperation(this.projections, excludeProjections);
    }

    public ProjectionOperation andInclude(String ... fieldNames) {
        List<ProjectionOperationBuilder.FieldProjection> projections = ProjectionOperationBuilder.FieldProjection.from(Fields.fields(fieldNames), true);
        return new ProjectionOperation(this.projections, projections);
    }

    public ProjectionOperation andInclude(Fields fields) {
        return new ProjectionOperation(this.projections, ProjectionOperationBuilder.FieldProjection.from(fields, true));
    }

    @Override
    public ExposedFields getFields() {
        ExposedFields fields = null;
        for (Projection projection : this.projections) {
            ExposedFields.ExposedField field = projection.getExposedField();
            fields = fields == null ? ExposedFields.from(field) : fields.and(field);
        }
        return fields;
    }

    @Override
    public DBObject toDBObject(AggregationOperationContext context) {
        BasicDBObject fieldObject = new BasicDBObject();
        for (Projection projection : this.projections) {
            fieldObject.putAll((BSONObject)projection.toDBObject(context));
        }
        return new BasicDBObject("$project", (Object)fieldObject);
    }

    private static abstract class Projection {
        private final ExposedFields.ExposedField field;

        public Projection(Field field) {
            Assert.notNull((Object)field, (String)"Field must not be null!");
            this.field = new ExposedFields.ExposedField(field, true);
        }

        public ExposedFields.ExposedField getExposedField() {
            return this.field;
        }

        public abstract DBObject toDBObject(AggregationOperationContext var1);
    }

    public static class ProjectionOperationBuilder
    extends AbstractProjectionOperationBuilder {
        private final String name;
        private final ProjectionOperation operation;
        private final OperationProjection previousProjection;

        public ProjectionOperationBuilder(String name, ProjectionOperation operation, OperationProjection previousProjection) {
            super(name, operation);
            this.name = name;
            this.operation = operation;
            this.previousProjection = previousProjection;
        }

        public ProjectionOperation previousOperation() {
            return this.operation.andExclude(Fields.UNDERSCORE_ID).and(new PreviousOperationProjection(this.name));
        }

        public ProjectionOperation nested(Fields fields) {
            return this.operation.and(new NestedFieldProjection(this.name, fields));
        }

        @Override
        public ProjectionOperation as(String alias) {
            if (this.previousProjection != null) {
                return this.operation.andReplaceLastOneWith(this.previousProjection.withAlias(alias));
            }
            return this.operation.and(new FieldProjection(Fields.field(alias, this.name), null));
        }

        public ProjectionOperationBuilder plus(Number number) {
            Assert.notNull((Object)number, (String)"Number must not be null!");
            return this.project("add", number);
        }

        public ProjectionOperationBuilder plus(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"Field reference must not be null!");
            return this.project("add", Fields.field(fieldReference));
        }

        public ProjectionOperationBuilder minus(Number number) {
            Assert.notNull((Object)number, (String)"Number must not be null!");
            return this.project("subtract", number);
        }

        public ProjectionOperationBuilder minus(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"Field reference must not be null!");
            return this.project("subtract", Fields.field(fieldReference));
        }

        public ProjectionOperationBuilder multiply(Number number) {
            Assert.notNull((Object)number, (String)"Number must not be null!");
            return this.project("multiply", number);
        }

        public ProjectionOperationBuilder multiply(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"Field reference must not be null!");
            return this.project("multiply", Fields.field(fieldReference));
        }

        public ProjectionOperationBuilder divide(Number number) {
            Assert.notNull((Object)number, (String)"Number must not be null!");
            Assert.isTrue((Math.abs(number.intValue()) != 0 ? 1 : 0) != 0, (String)"Number must not be zero!");
            return this.project("divide", number);
        }

        public ProjectionOperationBuilder divide(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"Field reference must not be null!");
            return this.project("divide", Fields.field(fieldReference));
        }

        public ProjectionOperationBuilder mod(Number number) {
            Assert.notNull((Object)number, (String)"Number must not be null!");
            Assert.isTrue((Math.abs(number.intValue()) != 0 ? 1 : 0) != 0, (String)"Number must not be zero!");
            return this.project("mod", number);
        }

        public ProjectionOperationBuilder mod(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"Field reference must not be null!");
            return this.project("mod", Fields.field(fieldReference));
        }

        @Override
        public DBObject toDBObject(AggregationOperationContext context) {
            return this.operation.toDBObject(context);
        }

        public ProjectionOperationBuilder project(String operation, Object ... values) {
            OperationProjection projectionOperation = new OperationProjection(Fields.field(this.name), operation, values);
            return new ProjectionOperationBuilder(this.name, this.operation.and(projectionOperation), projectionOperation);
        }

        static class NestedFieldProjection
        extends Projection {
            private final String name;
            private final Fields fields;

            public NestedFieldProjection(String name, Fields fields) {
                super(Fields.field(name));
                this.name = name;
                this.fields = fields;
            }

            @Override
            public DBObject toDBObject(AggregationOperationContext context) {
                BasicDBObject nestedObject = new BasicDBObject();
                for (Field field : this.fields) {
                    nestedObject.put(field.getName(), (Object)context.getReference(field.getTarget()).toString());
                }
                return new BasicDBObject(this.name, (Object)nestedObject);
            }
        }

        static class OperationProjection
        extends Projection {
            private final Field field;
            private final String operation;
            private final List<Object> values;

            public OperationProjection(Field field, String operation, Object[] values) {
                super(field);
                Assert.hasText((String)operation, (String)"Operation must not be null or empty!");
                Assert.notNull((Object)values, (String)"Values must not be null!");
                this.field = field;
                this.operation = operation;
                this.values = Arrays.asList(values);
            }

            @Override
            public DBObject toDBObject(AggregationOperationContext context) {
                BasicDBList values = new BasicDBList();
                values.addAll(this.buildReferences(context));
                BasicDBObject inner = new BasicDBObject("$" + this.operation, (Object)values);
                return new BasicDBObject(this.field.getName(), (Object)inner);
            }

            private List<Object> buildReferences(AggregationOperationContext context) {
                ArrayList<Object> result = new ArrayList<Object>(this.values.size());
                result.add(context.getReference(this.field.getTarget()).toString());
                for (Object element : this.values) {
                    result.add(element instanceof Field ? context.getReference((Field)element).toString() : element);
                }
                return result;
            }

            public OperationProjection withAlias(String alias) {
                return new OperationProjection(Fields.field(alias, this.field.getName()), this.operation, this.values.toArray());
            }
        }

        static class FieldProjection
        extends Projection {
            private final Field field;
            private final Object value;

            public FieldProjection(String name, Object value) {
                this(Fields.field(name), value);
            }

            private FieldProjection(Field field, Object value) {
                super(field);
                this.field = field;
                this.value = value;
            }

            public static List<? extends Projection> from(Fields fields) {
                return FieldProjection.from(fields, null);
            }

            public static List<FieldProjection> from(Fields fields, Object value) {
                Assert.notNull((Object)fields, (String)"Fields must not be null!");
                ArrayList<FieldProjection> projections = new ArrayList<FieldProjection>();
                for (Field field : fields) {
                    projections.add(new FieldProjection(field, value));
                }
                return projections;
            }

            @Override
            public DBObject toDBObject(AggregationOperationContext context) {
                return new BasicDBObject(this.field.getName(), this.renderFieldValue(context));
            }

            private Object renderFieldValue(AggregationOperationContext context) {
                if (this.value == null || Boolean.TRUE.equals(this.value)) {
                    ExposedFields.FieldReference reference = context.getReference(this.field.getTarget());
                    return reference.isSynthetic() && !this.field.isAliased() ? Integer.valueOf(1) : reference.toString();
                }
                if (Boolean.FALSE.equals(this.value)) {
                    return 0;
                }
                return this.value;
            }
        }

        static class PreviousOperationProjection
        extends Projection {
            private final String name;

            public PreviousOperationProjection(String name) {
                super(Fields.field(name));
                this.name = name;
            }

            @Override
            public DBObject toDBObject(AggregationOperationContext context) {
                return new BasicDBObject(this.name, (Object)Fields.UNDERSCORE_ID_REF);
            }
        }
    }

    public static class ExpressionProjectionOperationBuilder
    extends AbstractProjectionOperationBuilder {
        private final Object[] params;

        public ExpressionProjectionOperationBuilder(Object value, ProjectionOperation operation, Object[] parameters) {
            super(value, operation);
            this.params = parameters;
        }

        @Override
        public ProjectionOperation as(String alias) {
            Field expressionField = Fields.field(alias, "expr");
            return this.operation.and(new ExpressionProjection(expressionField, this.value.toString(), this.params));
        }

        static class ExpressionProjection
        extends Projection {
            private static final SpelExpressionTransformer TRANSFORMER = new SpelExpressionTransformer();
            private final String expression;
            private final Object[] params;

            public ExpressionProjection(Field field, String expression, Object[] parameters) {
                super(field);
                Assert.hasText((String)expression, (String)"Expression must not be null!");
                Assert.notNull((Object)parameters, (String)"Parameters must not be null!");
                this.expression = expression;
                this.params = parameters;
            }

            @Override
            public DBObject toDBObject(AggregationOperationContext context) {
                return new BasicDBObject(this.getExposedField().getName(), TRANSFORMER.transform(this.expression, context, this.params));
            }
        }
    }

    private static abstract class AbstractProjectionOperationBuilder
    implements AggregationOperation {
        protected final Object value;
        protected final ProjectionOperation operation;

        public AbstractProjectionOperationBuilder(Object value, ProjectionOperation operation) {
            Assert.notNull((Object)value, (String)"value must not be null or empty!");
            Assert.notNull((Object)operation, (String)"ProjectionOperation must not be null!");
            this.value = value;
            this.operation = operation;
        }

        @Override
        public DBObject toDBObject(AggregationOperationContext context) {
            return this.operation.toDBObject(context);
        }

        public abstract ProjectionOperation as(String var1);
    }
}

