/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bson.BSONObject;
import org.springframework.data.domain.Range;
import org.springframework.data.mongodb.core.aggregation.AbstractAggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.ExposedFields;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.aggregation.InheritingExposedFieldsAggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.NestedDelegatingExpressionAggregationOperationContext;
import org.springframework.util.Assert;

public class ArrayOperators {
    public static ArrayOperatorFactory arrayOf(String fieldReference) {
        return new ArrayOperatorFactory(fieldReference);
    }

    public static ArrayOperatorFactory arrayOf(AggregationExpression expression) {
        return new ArrayOperatorFactory(expression);
    }

    public static class In
    extends AbstractAggregationExpression {
        private In(List<Object> values) {
            super(values);
        }

        @Override
        protected String getMongoMethod() {
            return "$in";
        }

        public static InBuilder arrayOf(final String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new InBuilder(){

                @Override
                public In containsValue(Object value) {
                    Assert.notNull((Object)value, (String)"Value must not be null!");
                    return new In(Arrays.asList(value, Fields.field(fieldReference)));
                }
            };
        }

        public static InBuilder arrayOf(final AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new InBuilder(){

                @Override
                public In containsValue(Object value) {
                    Assert.notNull((Object)value, (String)"Value must not be null!");
                    return new In(Arrays.asList(value, expression));
                }
            };
        }

        public static interface InBuilder {
            public In containsValue(Object var1);
        }
    }

    public static class Zip
    extends AbstractAggregationExpression {
        protected Zip(Map<String, Object> value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$zip";
        }

        public static ZipBuilder arrayOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new ZipBuilder(Fields.field(fieldReference));
        }

        public static ZipBuilder arrayOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new ZipBuilder(expression);
        }

        public Zip useLongestLength() {
            return new Zip(this.append("useLongestLength", true));
        }

        public Zip defaultTo(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new Zip(this.append("defaults", Fields.field(fieldReference)));
        }

        public Zip defaultTo(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new Zip(this.append("defaults", expression));
        }

        public Zip defaultTo(Object[] array) {
            Assert.notNull((Object)array, (String)"Array must not be null!");
            return new Zip(this.append("defaults", array));
        }

        public static class ZipBuilder {
            private final List<Object> sourceArrays = new ArrayList<Object>();

            private ZipBuilder(Object sourceArray) {
                this.sourceArrays.add(sourceArray);
            }

            public Zip zip(Object ... arrays) {
                Assert.notNull((Object)arrays, (String)"Arrays must not be null!");
                for (Object value : arrays) {
                    if (value instanceof String) {
                        this.sourceArrays.add(Fields.field((String)value));
                        continue;
                    }
                    this.sourceArrays.add(value);
                }
                return new Zip(Collections.singletonMap("inputs", this.sourceArrays));
            }
        }
    }

    public static class Reduce
    implements AggregationExpression {
        private final Object input;
        private final Object initialValue;
        private final List<AggregationExpression> reduceExpressions;

        private Reduce(Object input, Object initialValue, List<AggregationExpression> reduceExpressions) {
            this.input = input;
            this.initialValue = initialValue;
            this.reduceExpressions = reduceExpressions;
        }

        @Override
        public DBObject toDbObject(AggregationOperationContext context) {
            BasicDBObject dbo = new BasicDBObject();
            dbo.put("input", this.getMappedValue(this.input, context));
            dbo.put("initialValue", this.getMappedValue(this.initialValue, context));
            if (this.reduceExpressions.iterator().next() instanceof PropertyExpression) {
                BasicDBObject properties = new BasicDBObject();
                for (AggregationExpression e : this.reduceExpressions) {
                    properties.putAll((BSONObject)e.toDbObject(context));
                }
                dbo.put("in", (Object)properties);
            } else {
                dbo.put("in", (Object)this.reduceExpressions.iterator().next().toDbObject(context));
            }
            return new BasicDBObject("$reduce", (Object)dbo);
        }

        private Object getMappedValue(Object value, AggregationOperationContext context) {
            if (value instanceof DBObject) {
                return value;
            }
            if (value instanceof AggregationExpression) {
                return ((AggregationExpression)value).toDbObject(context);
            }
            if (value instanceof Field) {
                return context.getReference((Field)value).toString();
            }
            return context.getMappedObject((DBObject)new BasicDBObject("###val###", value)).get("###val###");
        }

        public static InitialValueBuilder arrayOf(final String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            return new InitialValueBuilder(){

                @Override
                public ReduceBuilder withInitialValue(final Object initialValue) {
                    Assert.notNull((Object)initialValue, (String)"Initial value must not be null");
                    return new ReduceBuilder(){

                        @Override
                        public Reduce reduce(AggregationExpression expression) {
                            Assert.notNull((Object)expression, (String)"AggregationExpression must not be null");
                            return new Reduce(Fields.field(fieldReference), initialValue, Collections.singletonList(expression));
                        }

                        @Override
                        public Reduce reduce(PropertyExpression ... expressions) {
                            Assert.notNull((Object)expressions, (String)"PropertyExpressions must not be null");
                            return new Reduce(Fields.field(fieldReference), initialValue, Arrays.asList(expressions));
                        }
                    };
                }
            };
        }

        public static InitialValueBuilder arrayOf(final AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"AggregationExpression must not be null");
            return new InitialValueBuilder(){

                @Override
                public ReduceBuilder withInitialValue(final Object initialValue) {
                    Assert.notNull((Object)initialValue, (String)"Initial value must not be null");
                    return new ReduceBuilder(){

                        @Override
                        public Reduce reduce(AggregationExpression expression) {
                            Assert.notNull((Object)expression, (String)"AggregationExpression must not be null");
                            return new Reduce(expression, initialValue, Collections.singletonList(expression));
                        }

                        @Override
                        public Reduce reduce(PropertyExpression ... expressions) {
                            Assert.notNull((Object)expressions, (String)"PropertyExpressions must not be null");
                            return new Reduce(expression, initialValue, Arrays.asList(expressions));
                        }
                    };
                }
            };
        }

        public static enum Variable implements Field
        {
            THIS{

                @Override
                public String getName() {
                    return "$$this";
                }

                @Override
                public String getTarget() {
                    return "$$this";
                }

                @Override
                public boolean isAliased() {
                    return false;
                }

                public String toString() {
                    return this.getName();
                }
            }
            ,
            VALUE{

                @Override
                public String getName() {
                    return "$$value";
                }

                @Override
                public String getTarget() {
                    return "$$value";
                }

                @Override
                public boolean isAliased() {
                    return false;
                }

                public String toString() {
                    return this.getName();
                }
            };


            public Field referringTo(final String property) {
                return new Field(){

                    @Override
                    public String getName() {
                        return Variable.this.getName() + "." + property;
                    }

                    @Override
                    public String getTarget() {
                        return Variable.this.getTarget() + "." + property;
                    }

                    @Override
                    public boolean isAliased() {
                        return false;
                    }

                    public String toString() {
                        return this.getName();
                    }
                };
            }
        }

        public static class PropertyExpression
        implements AggregationExpression {
            private final String propertyName;
            private final AggregationExpression aggregationExpression;

            protected PropertyExpression(String propertyName, AggregationExpression aggregationExpression) {
                Assert.notNull((Object)propertyName, (String)"Property name must not be null!");
                Assert.notNull((Object)aggregationExpression, (String)"AggregationExpression must not be null!");
                this.propertyName = propertyName;
                this.aggregationExpression = aggregationExpression;
            }

            public static AsBuilder property(final String name) {
                return new AsBuilder(){

                    @Override
                    public PropertyExpression definedAs(AggregationExpression expression) {
                        return new PropertyExpression(name, expression);
                    }
                };
            }

            @Override
            public DBObject toDbObject(AggregationOperationContext context) {
                return new BasicDBObject(this.propertyName, (Object)this.aggregationExpression.toDbObject(context));
            }

            public static interface AsBuilder {
                public PropertyExpression definedAs(AggregationExpression var1);
            }
        }

        public static interface ReduceBuilder {
            public Reduce reduce(AggregationExpression var1);

            public Reduce reduce(PropertyExpression ... var1);
        }

        public static interface InitialValueBuilder {
            public ReduceBuilder withInitialValue(Object var1);
        }
    }

    public static class ReverseArray
    extends AbstractAggregationExpression {
        private ReverseArray(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$reverseArray";
        }

        public static ReverseArray reverseArrayOf(String fieldReference) {
            return new ReverseArray(Fields.field(fieldReference));
        }

        public static ReverseArray reverseArrayOf(AggregationExpression expression) {
            return new ReverseArray(expression);
        }
    }

    public static class RangeOperator
    extends AbstractAggregationExpression {
        private RangeOperator(List<Object> values) {
            super(values);
        }

        @Override
        protected String getMongoMethod() {
            return "$range";
        }

        public static RangeOperatorBuilder rangeStartingAt(String fieldReference) {
            return new RangeOperatorBuilder(Fields.field(fieldReference));
        }

        public static RangeOperatorBuilder rangeStartingAt(AggregationExpression expression) {
            return new RangeOperatorBuilder(expression);
        }

        public static RangeOperatorBuilder rangeStartingAt(long value) {
            return new RangeOperatorBuilder(value);
        }

        public RangeOperator withStepSize(long stepSize) {
            return new RangeOperator(this.append(stepSize));
        }

        public static class RangeOperatorBuilder {
            private final Object startPoint;

            private RangeOperatorBuilder(Object startPoint) {
                this.startPoint = startPoint;
            }

            public RangeOperator to(long index) {
                return new RangeOperator(Arrays.asList(this.startPoint, index));
            }

            public RangeOperator to(AggregationExpression expression) {
                return new RangeOperator(Arrays.asList(this.startPoint, expression));
            }

            public RangeOperator to(String fieldReference) {
                return new RangeOperator(Arrays.asList(this.startPoint, Fields.field(fieldReference)));
            }
        }
    }

    public static class IndexOfArray
    extends AbstractAggregationExpression {
        private IndexOfArray(List<Object> value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$indexOfArray";
        }

        public static IndexOfArrayBuilder arrayOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new IndexOfArrayBuilder(Fields.field(fieldReference));
        }

        public static IndexOfArrayBuilder arrayOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new IndexOfArrayBuilder(expression);
        }

        public IndexOfArray within(Range<Long> range) {
            Assert.notNull(range, (String)"Range must not be null!");
            ArrayList<Comparable> rangeValues = new ArrayList<Comparable>(2);
            rangeValues.add(range.getLowerBound());
            if (range.getUpperBound() != null) {
                rangeValues.add(range.getUpperBound());
            }
            return new IndexOfArray(this.append(rangeValues));
        }

        public static class IndexOfArrayBuilder {
            private final Object targetArray;

            private IndexOfArrayBuilder(Object targetArray) {
                this.targetArray = targetArray;
            }

            public IndexOfArray indexOf(Object value) {
                Assert.notNull((Object)value, (String)"Value must not be null!");
                return new IndexOfArray(Arrays.asList(this.targetArray, value));
            }
        }
    }

    public static class Slice
    extends AbstractAggregationExpression {
        private Slice(List<?> value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$slice";
        }

        public static Slice sliceArrayOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new Slice(Slice.asFields(fieldReference));
        }

        public static Slice sliceArrayOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new Slice(Collections.singletonList(expression));
        }

        public Slice itemCount(int nrElements) {
            return new Slice(this.append(nrElements));
        }

        public SliceElementsBuilder offset(final int position) {
            return new SliceElementsBuilder(){

                @Override
                public Slice itemCount(int nrElements) {
                    return new Slice(Slice.this.append(position)).itemCount(nrElements);
                }
            };
        }

        public static interface SliceElementsBuilder {
            public Slice itemCount(int var1);
        }
    }

    public static class Size
    extends AbstractAggregationExpression {
        private Size(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$size";
        }

        public static Size lengthOfArray(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new Size(Fields.field(fieldReference));
        }

        public static Size lengthOfArray(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new Size(expression);
        }
    }

    public static class IsArray
    extends AbstractAggregationExpression {
        private IsArray(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$isArray";
        }

        public static IsArray isArray(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new IsArray(Fields.field(fieldReference));
        }

        public static IsArray isArray(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new IsArray(expression);
        }
    }

    public static class Filter
    implements AggregationExpression {
        private Object input;
        private ExposedFields.ExposedField as;
        private Object condition;

        private Filter() {
        }

        public static AsBuilder filter(String field) {
            Assert.notNull((Object)field, (String)"Field must not be null!");
            return Filter.filter(Fields.field(field));
        }

        public static AsBuilder filter(Field field) {
            Assert.notNull((Object)field, (String)"Field must not be null!");
            return new FilterExpressionBuilder().filter(field);
        }

        public static AsBuilder filter(List<?> values) {
            Assert.notNull(values, (String)"Values must not be null!");
            return new FilterExpressionBuilder().filter(values);
        }

        @Override
        public DBObject toDbObject(AggregationOperationContext context) {
            return this.toFilter(ExposedFields.from(this.as), context);
        }

        private DBObject toFilter(ExposedFields exposedFields, AggregationOperationContext context) {
            BasicDBObject filterExpression = new BasicDBObject();
            InheritingExposedFieldsAggregationOperationContext operationContext = new InheritingExposedFieldsAggregationOperationContext(exposedFields, context);
            filterExpression.putAll((BSONObject)context.getMappedObject((DBObject)new BasicDBObject("input", this.getMappedInput(context))));
            filterExpression.put("as", (Object)this.as.getTarget());
            filterExpression.putAll((BSONObject)context.getMappedObject((DBObject)new BasicDBObject("cond", this.getMappedCondition(operationContext))));
            return new BasicDBObject("$filter", (Object)filterExpression);
        }

        private Object getMappedInput(AggregationOperationContext context) {
            return this.input instanceof Field ? context.getReference((Field)this.input).toString() : this.input;
        }

        private Object getMappedCondition(AggregationOperationContext context) {
            if (!(this.condition instanceof AggregationExpression)) {
                return this.condition;
            }
            NestedDelegatingExpressionAggregationOperationContext nea = new NestedDelegatingExpressionAggregationOperationContext(context);
            return ((AggregationExpression)this.condition).toDbObject(nea);
        }

        static final class FilterExpressionBuilder
        implements InputBuilder,
        AsBuilder,
        ConditionBuilder {
            private final Filter filter = new Filter();

            FilterExpressionBuilder() {
            }

            public static InputBuilder newBuilder() {
                return new FilterExpressionBuilder();
            }

            @Override
            public AsBuilder filter(List<?> array) {
                Assert.notNull(array, (String)"Array must not be null!");
                this.filter.input = new ArrayList(array);
                return this;
            }

            @Override
            public AsBuilder filter(Field field) {
                Assert.notNull((Object)field, (String)"Field must not be null!");
                this.filter.input = field;
                return this;
            }

            @Override
            public ConditionBuilder as(String variableName) {
                Assert.notNull((Object)variableName, (String)"Variable name  must not be null!");
                this.filter.as = new ExposedFields.ExposedField(variableName, true);
                return this;
            }

            @Override
            public Filter by(AggregationExpression condition) {
                Assert.notNull((Object)condition, (String)"Condition must not be null!");
                this.filter.condition = condition;
                return this.filter;
            }

            @Override
            public Filter by(String expression) {
                Assert.notNull((Object)expression, (String)"Expression must not be null!");
                this.filter.condition = expression;
                return this.filter;
            }

            @Override
            public Filter by(DBObject expression) {
                Assert.notNull((Object)expression, (String)"Expression must not be null!");
                this.filter.condition = expression;
                return this.filter;
            }
        }

        public static interface ConditionBuilder {
            public Filter by(AggregationExpression var1);

            public Filter by(String var1);

            public Filter by(DBObject var1);
        }

        public static interface AsBuilder {
            public ConditionBuilder as(String var1);
        }

        public static interface InputBuilder {
            public AsBuilder filter(List<?> var1);

            public AsBuilder filter(Field var1);
        }
    }

    public static class ConcatArrays
    extends AbstractAggregationExpression {
        private ConcatArrays(List<?> value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$concatArrays";
        }

        public static ConcatArrays arrayOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new ConcatArrays(ConcatArrays.asFields(fieldReference));
        }

        public static ConcatArrays arrayOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new ConcatArrays(Collections.singletonList(expression));
        }

        public ConcatArrays concat(String arrayFieldReference) {
            Assert.notNull((Object)arrayFieldReference, (String)"ArrayFieldReference must not be null!");
            return new ConcatArrays(this.append(Fields.field(arrayFieldReference)));
        }

        public ConcatArrays concat(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new ConcatArrays(this.append(expression));
        }
    }

    public static class ArrayElemAt
    extends AbstractAggregationExpression {
        private ArrayElemAt(List<?> value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$arrayElemAt";
        }

        public static ArrayElemAt arrayOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new ArrayElemAt(ArrayElemAt.asFields(fieldReference));
        }

        public static ArrayElemAt arrayOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new ArrayElemAt(Collections.singletonList(expression));
        }

        public ArrayElemAt elementAt(int index) {
            return new ArrayElemAt(this.append(index));
        }

        public ArrayElemAt elementAt(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new ArrayElemAt(this.append(expression));
        }

        public ArrayElemAt elementAt(String arrayFieldReference) {
            Assert.notNull((Object)arrayFieldReference, (String)"ArrayReference must not be null!");
            return new ArrayElemAt(this.append(Fields.field(arrayFieldReference)));
        }
    }

    public static class ArrayOperatorFactory {
        private final String fieldReference;
        private final AggregationExpression expression;

        public ArrayOperatorFactory(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            this.fieldReference = fieldReference;
            this.expression = null;
        }

        public ArrayOperatorFactory(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            this.fieldReference = null;
            this.expression = expression;
        }

        public ArrayElemAt elementAt(int position) {
            return this.createArrayElemAt().elementAt(position);
        }

        public ArrayElemAt elementAt(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return this.createArrayElemAt().elementAt(expression);
        }

        public ArrayElemAt elementAt(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return this.createArrayElemAt().elementAt(fieldReference);
        }

        private ArrayElemAt createArrayElemAt() {
            return this.usesFieldRef() ? ArrayElemAt.arrayOf(this.fieldReference) : ArrayElemAt.arrayOf(this.expression);
        }

        public ConcatArrays concat(String arrayFieldReference) {
            Assert.notNull((Object)arrayFieldReference, (String)"ArrayFieldReference must not be null!");
            return this.createConcatArrays().concat(arrayFieldReference);
        }

        public ConcatArrays concat(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return this.createConcatArrays().concat(expression);
        }

        private ConcatArrays createConcatArrays() {
            return this.usesFieldRef() ? ConcatArrays.arrayOf(this.fieldReference) : ConcatArrays.arrayOf(this.expression);
        }

        public Filter.AsBuilder filter() {
            return Filter.filter(this.fieldReference);
        }

        public IsArray isArray() {
            return this.usesFieldRef() ? IsArray.isArray(this.fieldReference) : IsArray.isArray(this.expression);
        }

        public Size length() {
            return this.usesFieldRef() ? Size.lengthOfArray(this.fieldReference) : Size.lengthOfArray(this.expression);
        }

        public Slice slice() {
            return this.usesFieldRef() ? Slice.sliceArrayOf(this.fieldReference) : Slice.sliceArrayOf(this.expression);
        }

        public IndexOfArray indexOf(Object value) {
            return this.usesFieldRef() ? IndexOfArray.arrayOf(this.fieldReference).indexOf(value) : IndexOfArray.arrayOf(this.expression).indexOf(value);
        }

        public ReverseArray reverse() {
            return this.usesFieldRef() ? ReverseArray.reverseArrayOf(this.fieldReference) : ReverseArray.reverseArrayOf(this.expression);
        }

        public ReduceInitialValueBuilder reduce(final AggregationExpression expression) {
            return new ReduceInitialValueBuilder(){

                @Override
                public Reduce startingWith(Object initialValue) {
                    return (ArrayOperatorFactory.this.usesFieldRef() ? Reduce.arrayOf(ArrayOperatorFactory.this.fieldReference) : Reduce.arrayOf(expression)).withInitialValue(initialValue).reduce(expression);
                }
            };
        }

        public ReduceInitialValueBuilder reduce(final Reduce.PropertyExpression ... expressions) {
            return new ReduceInitialValueBuilder(){

                @Override
                public Reduce startingWith(Object initialValue) {
                    return (ArrayOperatorFactory.this.usesFieldRef() ? Reduce.arrayOf(ArrayOperatorFactory.this.fieldReference) : Reduce.arrayOf(ArrayOperatorFactory.this.expression)).withInitialValue(initialValue).reduce(expressions);
                }
            };
        }

        public Zip zipWith(Object ... arrays) {
            return (this.usesFieldRef() ? Zip.arrayOf(this.fieldReference) : Zip.arrayOf(this.expression)).zip(arrays);
        }

        public In containsValue(Object value) {
            return (this.usesFieldRef() ? In.arrayOf(this.fieldReference) : In.arrayOf(this.expression)).containsValue(value);
        }

        private boolean usesFieldRef() {
            return this.fieldReference != null;
        }

        public static interface ReduceInitialValueBuilder {
            public Reduce startingWith(Object var1);
        }
    }
}

