/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.data.mongodb.core.aggregation.AbstractAggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class DateOperators {
    public static DateOperatorFactory dateOf(String fieldReference) {
        Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
        return new DateOperatorFactory(fieldReference);
    }

    public static DateOperatorFactory dateOf(AggregationExpression expression) {
        Assert.notNull((Object)expression, (String)"Expression must not be null!");
        return new DateOperatorFactory(expression);
    }

    public static DateOperatorFactory dateValue(Object value) {
        Assert.notNull((Object)value, (String)"Value must not be null!");
        return new DateOperatorFactory(value);
    }

    public static DateFromPartsOperatorFactory dateFromParts() {
        return new DateFromPartsOperatorFactory(Timezone.none());
    }

    public static DateFromString dateFromString(String value) {
        return DateFromString.fromString(value);
    }

    private static <T extends TimezonedDateAggregationExpression> T applyTimezone(T instance, Timezone timezone) {
        return (T)(!ObjectUtils.nullSafeEquals((Object)Timezone.none(), (Object)timezone) && !instance.hasTimezone() ? instance.withTimezone(timezone) : instance);
    }

    public static class DateFromString
    extends TimezonedDateAggregationExpression {
        private DateFromString(Object value) {
            super(value);
        }

        public static DateFromString fromString(Object value) {
            return new DateFromString(Collections.singletonMap("dateString", value));
        }

        public static DateFromString fromStringOf(String fieldReference) {
            return DateFromString.fromString(Fields.field(fieldReference));
        }

        public static DateFromString fromStringOf(AggregationExpression expression) {
            return DateFromString.fromString(expression);
        }

        @Override
        public DateFromString withTimezone(Timezone timezone) {
            return new DateFromString(DateFromString.appendTimezone(this.argumentMap(), timezone));
        }

        @Override
        protected String getMongoMethod() {
            return "$dateFromString";
        }
    }

    public static class DateToParts
    extends TimezonedDateAggregationExpression {
        private DateToParts(Object value) {
            super(value);
        }

        public static DateToParts dateToParts(Object value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return new DateToParts(Collections.singletonMap("date", value));
        }

        public static DateToParts datePartsOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return DateToParts.dateToParts(Fields.field(fieldReference));
        }

        public static DateToParts datePartsOf(AggregationExpression expression) {
            return DateToParts.dateToParts(expression);
        }

        public DateToParts iso8601() {
            return new DateToParts(this.append("iso8601", true));
        }

        @Override
        public DateToParts withTimezone(Timezone timezone) {
            return new DateToParts(DateToParts.appendTimezone(this.argumentMap(), timezone));
        }

        @Override
        protected String getMongoMethod() {
            return "$dateToParts";
        }
    }

    public static class IsoDateFromParts
    extends DateParts<IsoDateFromParts> {
        private IsoDateFromParts(Object value) {
            super(value);
        }

        public static IsoDateFromPartsWithYear dateFromParts() {
            return new IsoDateFromPartsWithYear(){

                @Override
                public IsoDateFromParts isoWeekYear(Object isoWeekYear) {
                    return new IsoDateFromParts(Collections.singletonMap("isoWeekYear", isoWeekYear));
                }
            };
        }

        public IsoDateFromParts isoWeek(Object isoWeek) {
            return new IsoDateFromParts(this.append("isoWeek", isoWeek));
        }

        public IsoDateFromParts isoWeekOf(String fieldReference) {
            return this.isoWeek(Fields.field(fieldReference));
        }

        public IsoDateFromParts isoWeekOf(AggregationExpression expression) {
            return this.isoWeek(expression);
        }

        public IsoDateFromParts isoDayOfWeek(Object day) {
            return new IsoDateFromParts(this.append("isoDayOfWeek", day));
        }

        public IsoDateFromParts isoDayOfWeekOf(String fieldReference) {
            return this.isoDayOfWeek(Fields.field(fieldReference));
        }

        public IsoDateFromParts isoDayOfWeekOf(AggregationExpression expression) {
            return this.isoDayOfWeek(expression);
        }

        @Override
        public IsoDateFromParts hour(Object hour) {
            return new IsoDateFromParts(this.append("hour", hour));
        }

        @Override
        public IsoDateFromParts minute(Object minute) {
            return new IsoDateFromParts(this.append("minute", minute));
        }

        @Override
        public IsoDateFromParts second(Object second) {
            return new IsoDateFromParts(this.append("second", second));
        }

        @Override
        public IsoDateFromParts milliseconds(Object milliseconds) {
            return new IsoDateFromParts(this.append("milliseconds", milliseconds));
        }

        @Override
        public IsoDateFromParts withTimezone(Timezone timezone) {
            return new IsoDateFromParts(IsoDateFromParts.appendTimezone(this.argumentMap(), timezone));
        }

        @Override
        protected String getMongoMethod() {
            return "$dateFromParts";
        }

        public static abstract class IsoDateFromPartsWithYear {
            public abstract IsoDateFromParts isoWeekYear(Object var1);

            public IsoDateFromParts isoWeekYearOf(String fieldReference) {
                Assert.hasText((String)fieldReference, (String)"Field reference must not be null nor empty.");
                return this.isoWeekYear(Fields.field(fieldReference));
            }

            public IsoDateFromParts isoWeekYearOf(AggregationExpression expression) {
                Assert.notNull((Object)expression, (String)"Expression must not be null!");
                return this.isoWeekYear(expression);
            }
        }
    }

    public static class DateFromParts
    extends DateParts<DateFromParts> {
        private DateFromParts(Object value) {
            super(value);
        }

        public static DateFromPartsWithYear dateFromParts() {
            return new DateFromPartsWithYear(){

                @Override
                public DateFromParts year(Object year) {
                    return new DateFromParts(Collections.singletonMap("year", year));
                }
            };
        }

        public DateFromParts month(Object month) {
            return new DateFromParts(this.append("month", month));
        }

        public DateFromParts monthOf(String fieldReference) {
            return this.month(Fields.field(fieldReference));
        }

        public DateFromParts monthOf(AggregationExpression expression) {
            return this.month(expression);
        }

        public DateFromParts day(Object day) {
            return new DateFromParts(this.append("day", day));
        }

        public DateFromParts dayOf(String fieldReference) {
            return this.day(Fields.field(fieldReference));
        }

        public DateFromParts dayOf(AggregationExpression expression) {
            return this.day(expression);
        }

        @Override
        public DateFromParts hour(Object hour) {
            return new DateFromParts(this.append("hour", hour));
        }

        @Override
        public DateFromParts minute(Object minute) {
            return new DateFromParts(this.append("minute", minute));
        }

        @Override
        public DateFromParts second(Object second) {
            return new DateFromParts(this.append("second", second));
        }

        @Override
        public DateFromParts milliseconds(Object milliseconds) {
            return new DateFromParts(this.append("milliseconds", milliseconds));
        }

        @Override
        public DateFromParts withTimezone(Timezone timezone) {
            return new DateFromParts(DateFromParts.appendTimezone(this.argumentMap(), timezone));
        }

        @Override
        protected String getMongoMethod() {
            return "$dateFromParts";
        }

        public static abstract class DateFromPartsWithYear {
            public abstract DateFromParts year(Object var1);

            public DateFromParts yearOf(String fieldReference) {
                Assert.hasText((String)fieldReference, (String)"Field reference must not be null nor empty.");
                return this.year(Fields.field(fieldReference));
            }

            public DateFromParts yearOf(AggregationExpression expression) {
                Assert.notNull((Object)expression, (String)"Expression must not be null!");
                return this.year(expression);
            }
        }
    }

    public static abstract class DateParts<T extends DateParts<T>>
    extends TimezonedDateAggregationExpression {
        protected DateParts(Object value) {
            super(value);
        }

        public abstract T hour(Object var1);

        public T hourOf(String fieldReference) {
            return this.hour(Fields.field(fieldReference));
        }

        public T hourOf(AggregationExpression expression) {
            return this.hour(expression);
        }

        public abstract T minute(Object var1);

        public T minuteOf(String fieldReference) {
            return this.minute(Fields.field(fieldReference));
        }

        public T minuteOf(AggregationExpression expression) {
            return this.minute(expression);
        }

        public abstract T second(Object var1);

        public T secondOf(String fieldReference) {
            return this.second(Fields.field(fieldReference));
        }

        public T secondOf(AggregationExpression expression) {
            return this.second(expression);
        }

        public abstract T milliseconds(Object var1);

        public T millisecondsOf(String fieldReference) {
            return this.milliseconds(Fields.field(fieldReference));
        }

        public T millisecondsOf(AggregationExpression expression) {
            return this.milliseconds(expression);
        }
    }

    public static class IsoWeekYear
    extends TimezonedDateAggregationExpression {
        private IsoWeekYear(Object value) {
            super(value);
        }

        public static IsoWeekYear isoWeekYear(Object value) {
            Assert.notNull((Object)value, (String)"value must not be null!");
            return new IsoWeekYear(value);
        }

        public static IsoWeekYear isoWeekYearOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return IsoWeekYear.isoWeekYear(Fields.field(fieldReference));
        }

        public static IsoWeekYear isoWeekYearOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return IsoWeekYear.isoWeekYear(expression);
        }

        @Override
        public IsoWeekYear withTimezone(Timezone timezone) {
            Assert.notNull((Object)timezone, (String)"Timezone must not be null.");
            return new IsoWeekYear(IsoWeekYear.appendTimezone(this.values().iterator().next(), timezone));
        }

        @Override
        protected String getMongoMethod() {
            return "$isoWeekYear";
        }
    }

    public static class IsoWeek
    extends TimezonedDateAggregationExpression {
        private IsoWeek(Object value) {
            super(value);
        }

        public static IsoWeek isoWeek(Object value) {
            Assert.notNull((Object)value, (String)"value must not be null!");
            return new IsoWeek(value);
        }

        public static IsoWeek isoWeekOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return IsoWeek.isoWeek(Fields.field(fieldReference));
        }

        public static IsoWeek isoWeekOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return IsoWeek.isoWeek(expression);
        }

        @Override
        public IsoWeek withTimezone(Timezone timezone) {
            Assert.notNull((Object)timezone, (String)"Timezone must not be null.");
            return new IsoWeek(IsoWeek.appendTimezone(this.values().iterator().next(), timezone));
        }

        @Override
        protected String getMongoMethod() {
            return "$isoWeek";
        }
    }

    public static class IsoDayOfWeek
    extends TimezonedDateAggregationExpression {
        private IsoDayOfWeek(Object value) {
            super(value);
        }

        public static IsoDayOfWeek isoDayWeek(Object value) {
            Assert.notNull((Object)value, (String)"value must not be null!");
            return new IsoDayOfWeek(value);
        }

        public static IsoDayOfWeek isoDayOfWeek(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return IsoDayOfWeek.isoDayWeek(Fields.field(fieldReference));
        }

        public static IsoDayOfWeek isoDayOfWeek(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return IsoDayOfWeek.isoDayWeek(expression);
        }

        @Override
        public IsoDayOfWeek withTimezone(Timezone timezone) {
            Assert.notNull((Object)timezone, (String)"Timezone must not be null.");
            return new IsoDayOfWeek(IsoDayOfWeek.appendTimezone(this.values().iterator().next(), timezone));
        }

        @Override
        protected String getMongoMethod() {
            return "$isoDayOfWeek";
        }
    }

    public static class DateToString
    extends TimezonedDateAggregationExpression {
        private DateToString(Object value) {
            super(value);
        }

        public static FormatBuilder dateToString(final Object value) {
            Assert.notNull((Object)value, (String)"value must not be null!");
            return new FormatBuilder(){

                @Override
                public DateToString toString(String format) {
                    Assert.notNull((Object)format, (String)"Format must not be null!");
                    return new DateToString(DateToString.argumentMap(value, format, Timezone.none()));
                }
            };
        }

        public static FormatBuilder dateOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return DateToString.dateToString(Fields.field(fieldReference));
        }

        public static FormatBuilder dateOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return DateToString.dateToString(expression);
        }

        @Override
        public DateToString withTimezone(Timezone timezone) {
            Assert.notNull((Object)timezone, (String)"Timezone must not be null.");
            return new DateToString(DateToString.argumentMap(this.get("date"), (String)this.get("format"), timezone));
        }

        @Override
        protected String getMongoMethod() {
            return "$dateToString";
        }

        private static Map<String, Object> argumentMap(Object date, String format, Timezone timezone) {
            LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>(2);
            args.put("format", format);
            args.put("date", date);
            if (!ObjectUtils.nullSafeEquals((Object)timezone, (Object)Timezone.none())) {
                args.put("timezone", timezone.value);
            }
            return args;
        }

        public static interface FormatBuilder {
            public DateToString toString(String var1);
        }
    }

    public static class Millisecond
    extends TimezonedDateAggregationExpression {
        private Millisecond(Object value) {
            super(value);
        }

        public static Millisecond millisecond(Object value) {
            Assert.notNull((Object)value, (String)"value must not be null!");
            return new Millisecond(value);
        }

        public static Millisecond millisecondOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return Millisecond.millisecond(Fields.field(fieldReference));
        }

        public static Millisecond millisecondOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return Millisecond.millisecond(expression);
        }

        @Override
        public Millisecond withTimezone(Timezone timezone) {
            Assert.notNull((Object)timezone, (String)"Timezone must not be null.");
            return new Millisecond(Millisecond.appendTimezone(this.values().iterator().next(), timezone));
        }

        @Override
        protected String getMongoMethod() {
            return "$millisecond";
        }
    }

    public static class Second
    extends TimezonedDateAggregationExpression {
        private Second(Object value) {
            super(value);
        }

        public static Second second(Object value) {
            Assert.notNull((Object)value, (String)"value must not be null!");
            return new Second(value);
        }

        public static Second secondOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return Second.second(Fields.field(fieldReference));
        }

        public static Second secondOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return Second.second(expression);
        }

        @Override
        public Second withTimezone(Timezone timezone) {
            Assert.notNull((Object)timezone, (String)"Timezone must not be null.");
            return new Second(Second.appendTimezone(this.values().iterator().next(), timezone));
        }

        @Override
        protected String getMongoMethod() {
            return "$second";
        }
    }

    public static class Minute
    extends TimezonedDateAggregationExpression {
        private Minute(Object value) {
            super(value);
        }

        public static Minute minute(Object value) {
            Assert.notNull((Object)value, (String)"value must not be null!");
            return new Minute(value);
        }

        public static Minute minuteOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return Minute.minute(Fields.field(fieldReference));
        }

        public static Minute minuteOf(AggregationExpression expression) {
            return Minute.minute(expression);
        }

        @Override
        public Minute withTimezone(Timezone timezone) {
            Assert.notNull((Object)timezone, (String)"Timezone must not be null.");
            return new Minute(Minute.appendTimezone(this.values().iterator().next(), timezone));
        }

        @Override
        protected String getMongoMethod() {
            return "$minute";
        }
    }

    public static class Hour
    extends TimezonedDateAggregationExpression {
        private Hour(Object value) {
            super(value);
        }

        public static Hour hour(Object value) {
            Assert.notNull((Object)value, (String)"value must not be null!");
            return new Hour(value);
        }

        public static Hour hourOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return Hour.hour(Fields.field(fieldReference));
        }

        public static Hour hourOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return Hour.hour(expression);
        }

        @Override
        public Hour withTimezone(Timezone timezone) {
            Assert.notNull((Object)timezone, (String)"Timezone must not be null.");
            return new Hour(Hour.appendTimezone(this.values().iterator().next(), timezone));
        }

        @Override
        protected String getMongoMethod() {
            return "$hour";
        }
    }

    public static class Week
    extends TimezonedDateAggregationExpression {
        private Week(Object value) {
            super(value);
        }

        public static Week week(Object value) {
            Assert.notNull((Object)value, (String)"value must not be null!");
            return new Week(value);
        }

        public static Week weekOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return Week.week(Fields.field(fieldReference));
        }

        public static Week weekOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return Week.week(expression);
        }

        @Override
        public Week withTimezone(Timezone timezone) {
            Assert.notNull((Object)timezone, (String)"Timezone must not be null.");
            return new Week(Week.appendTimezone(this.values().iterator().next(), timezone));
        }

        @Override
        protected String getMongoMethod() {
            return "$week";
        }
    }

    public static class Month
    extends TimezonedDateAggregationExpression {
        private Month(Object value) {
            super(value);
        }

        public static Month month(Object value) {
            Assert.notNull((Object)value, (String)"value must not be null!");
            return new Month(value);
        }

        public static Month monthOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return Month.month(Fields.field(fieldReference));
        }

        public static Month monthOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return Month.month(expression);
        }

        @Override
        public Month withTimezone(Timezone timezone) {
            Assert.notNull((Object)timezone, (String)"Timezone must not be null.");
            return new Month(Month.appendTimezone(this.values().iterator().next(), timezone));
        }

        @Override
        protected String getMongoMethod() {
            return "$month";
        }
    }

    public static class Year
    extends TimezonedDateAggregationExpression {
        private Year(Object value) {
            super(value);
        }

        public static Year year(Object value) {
            Assert.notNull((Object)value, (String)"value must not be null!");
            return new Year(value);
        }

        public static Year yearOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return Year.year(Fields.field(fieldReference));
        }

        public static Year yearOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return Year.year(expression);
        }

        @Override
        public Year withTimezone(Timezone timezone) {
            Assert.notNull((Object)timezone, (String)"Timezone must not be null.");
            return new Year(Year.appendTimezone(this.values().iterator().next(), timezone));
        }

        @Override
        protected String getMongoMethod() {
            return "$year";
        }
    }

    public static class DayOfWeek
    extends TimezonedDateAggregationExpression {
        private DayOfWeek(Object value) {
            super(value);
        }

        public static DayOfWeek dayOfWeek(Object value) {
            Assert.notNull((Object)value, (String)"value must not be null!");
            return new DayOfWeek(value);
        }

        public static DayOfWeek dayOfWeek(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return DayOfWeek.dayOfWeek(Fields.field(fieldReference));
        }

        public static DayOfWeek dayOfWeek(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return DayOfWeek.dayOfWeek((Object)expression);
        }

        @Override
        public DayOfWeek withTimezone(Timezone timezone) {
            Assert.notNull((Object)timezone, (String)"Timezone must not be null.");
            return new DayOfWeek(DayOfWeek.appendTimezone(this.values().iterator().next(), timezone));
        }

        @Override
        protected String getMongoMethod() {
            return "$dayOfWeek";
        }
    }

    public static class DayOfMonth
    extends TimezonedDateAggregationExpression {
        private DayOfMonth(Object value) {
            super(value);
        }

        public static DayOfMonth dayOfMonth(Object value) {
            Assert.notNull((Object)value, (String)"value must not be null!");
            return new DayOfMonth(value);
        }

        public static DayOfMonth dayOfMonth(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return DayOfMonth.dayOfMonth(Fields.field(fieldReference));
        }

        public static DayOfMonth dayOfMonth(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return DayOfMonth.dayOfMonth((Object)expression);
        }

        @Override
        public DayOfMonth withTimezone(Timezone timezone) {
            Assert.notNull((Object)timezone, (String)"Timezone must not be null.");
            return new DayOfMonth(DayOfMonth.appendTimezone(this.values().iterator().next(), timezone));
        }

        @Override
        protected String getMongoMethod() {
            return "$dayOfMonth";
        }
    }

    public static class DayOfYear
    extends TimezonedDateAggregationExpression {
        private DayOfYear(Object value) {
            super(value);
        }

        public static DayOfYear dayOfYear(Object value) {
            Assert.notNull((Object)value, (String)"value must not be null!");
            return new DayOfYear(value);
        }

        public static DayOfYear dayOfYear(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return DayOfYear.dayOfYear(Fields.field(fieldReference));
        }

        public static DayOfYear dayOfYear(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return DayOfYear.dayOfYear((Object)expression);
        }

        @Override
        public DayOfYear withTimezone(Timezone timezone) {
            Assert.notNull((Object)timezone, (String)"Timezone must not be null.");
            return new DayOfYear(DayOfYear.appendTimezone(this.values().iterator().next(), timezone));
        }

        @Override
        protected String getMongoMethod() {
            return "$dayOfYear";
        }
    }

    public static abstract class TimezonedDateAggregationExpression
    extends AbstractAggregationExpression {
        protected TimezonedDateAggregationExpression(Object value) {
            super(value);
        }

        protected static Map<String, Object> appendTimezone(Object source, Timezone timezone) {
            LinkedHashMap<String, Object> args;
            if (source instanceof Map) {
                args = new LinkedHashMap((Map)source);
            } else {
                args = new LinkedHashMap<String, Object>(2);
                args.put("date", source);
            }
            if (!ObjectUtils.nullSafeEquals((Object)Timezone.none(), (Object)timezone)) {
                args.put("timezone", timezone.value);
            } else if (args.containsKey("timezone")) {
                args.remove("timezone");
            }
            return args;
        }

        protected abstract TimezonedDateAggregationExpression withTimezone(Timezone var1);

        protected boolean hasTimezone() {
            return this.contains("timezone");
        }
    }

    public static class DateFromPartsOperatorFactory {
        private final Timezone timezone;

        private DateFromPartsOperatorFactory(Timezone timezone) {
            this.timezone = timezone;
        }

        public IsoDateFromParts isoWeekYear(Object isoWeekYear) {
            return (IsoDateFromParts)DateOperators.applyTimezone(IsoDateFromParts.dateFromParts().isoWeekYear(isoWeekYear), this.timezone);
        }

        public IsoDateFromParts isoWeekYearOf(String fieldReference) {
            return this.isoWeekYear(Fields.field(fieldReference));
        }

        public IsoDateFromParts isoWeekYearOf(AggregationExpression expression) {
            return this.isoWeekYear(expression);
        }

        public DateFromParts year(Object year) {
            return (DateFromParts)DateOperators.applyTimezone(DateFromParts.dateFromParts().year(year), this.timezone);
        }

        public DateFromParts yearOf(String fieldReference) {
            return this.year(Fields.field(fieldReference));
        }

        public DateFromParts yearOf(AggregationExpression expression) {
            return this.year(expression);
        }

        public DateFromPartsOperatorFactory withTimezone(Timezone timezone) {
            Assert.notNull((Object)timezone, (String)"Timezone must not be null!");
            return new DateFromPartsOperatorFactory(timezone);
        }
    }

    public static class DateOperatorFactory {
        private final String fieldReference;
        private final Object dateValue;
        private final AggregationExpression expression;
        private final Timezone timezone;

        private DateOperatorFactory(String fieldReference, AggregationExpression expression, Object value, Timezone timezone) {
            this.fieldReference = fieldReference;
            this.expression = expression;
            this.dateValue = value;
            this.timezone = timezone;
        }

        public DateOperatorFactory(String fieldReference) {
            this(fieldReference, null, null, Timezone.none());
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
        }

        public DateOperatorFactory(AggregationExpression expression) {
            this(null, expression, null, Timezone.none());
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
        }

        public DateOperatorFactory(Object value) {
            this(null, null, value, Timezone.none());
            Assert.notNull((Object)value, (String)"Value must not be null!");
        }

        public DateOperatorFactory withTimezone(Timezone timezone) {
            Assert.notNull((Object)timezone, (String)"Timezone must not be null!");
            return new DateOperatorFactory(this.fieldReference, this.expression, this.dateValue, timezone);
        }

        public DayOfYear dayOfYear() {
            return (DayOfYear)DateOperators.applyTimezone(DayOfYear.dayOfYear(this.dateReference()), this.timezone);
        }

        public DayOfMonth dayOfMonth() {
            return (DayOfMonth)DateOperators.applyTimezone(DayOfMonth.dayOfMonth(this.dateReference()), this.timezone);
        }

        public DayOfWeek dayOfWeek() {
            return (DayOfWeek)DateOperators.applyTimezone(DayOfWeek.dayOfWeek(this.dateReference()), this.timezone);
        }

        public Year year() {
            return (Year)DateOperators.applyTimezone(Year.year(this.dateReference()), this.timezone);
        }

        public Month month() {
            return (Month)DateOperators.applyTimezone(Month.month(this.dateReference()), this.timezone);
        }

        public Week week() {
            return (Week)DateOperators.applyTimezone(Week.week(this.dateReference()), this.timezone);
        }

        public Hour hour() {
            return (Hour)DateOperators.applyTimezone(Hour.hour(this.dateReference()), this.timezone);
        }

        public Minute minute() {
            return (Minute)DateOperators.applyTimezone(Minute.minute(this.dateReference()), this.timezone);
        }

        public Second second() {
            return (Second)DateOperators.applyTimezone(Second.second(this.dateReference()), this.timezone);
        }

        public Millisecond millisecond() {
            return (Millisecond)DateOperators.applyTimezone(Millisecond.millisecond(this.dateReference()), this.timezone);
        }

        public DateToString toString(String format) {
            return (DateToString)DateOperators.applyTimezone(DateToString.dateToString(this.dateReference()).toString(format), this.timezone);
        }

        public IsoDayOfWeek isoDayOfWeek() {
            return (IsoDayOfWeek)DateOperators.applyTimezone(IsoDayOfWeek.isoDayWeek(this.dateReference()), this.timezone);
        }

        public IsoWeek isoWeek() {
            return (IsoWeek)DateOperators.applyTimezone(IsoWeek.isoWeek(this.dateReference()), this.timezone);
        }

        public IsoWeekYear isoWeekYear() {
            return (IsoWeekYear)DateOperators.applyTimezone(IsoWeekYear.isoWeekYear(this.dateReference()), this.timezone);
        }

        public DateToParts toParts() {
            return (DateToParts)DateOperators.applyTimezone(DateToParts.dateToParts(this.dateReference()), this.timezone);
        }

        public DateFromString fromString() {
            return (DateFromString)DateOperators.applyTimezone(DateFromString.fromString(this.dateReference()), this.timezone);
        }

        private Object dateReference() {
            if (this.usesFieldRef()) {
                return Fields.field(this.fieldReference);
            }
            return this.usesExpression() ? this.expression : this.dateValue;
        }

        private boolean usesFieldRef() {
            return this.fieldReference != null;
        }

        private boolean usesExpression() {
            return this.expression != null;
        }
    }

    public static class Timezone {
        private static final Timezone NONE = new Timezone(null);
        private final Object value;

        private Timezone(Object value) {
            this.value = value;
        }

        public static Timezone none() {
            return NONE;
        }

        public static Timezone valueOf(Object value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return new Timezone(value);
        }

        public static Timezone ofField(String fieldReference) {
            return Timezone.valueOf(Fields.field(fieldReference));
        }

        public static Timezone ofExpression(AggregationExpression expression) {
            return Timezone.valueOf(expression);
        }
    }
}

