/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.ldap.repository.query;

import org.jspecify.annotations.Nullable;
import org.springframework.core.convert.converter.Converter;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.convert.DtoInstantiatingConverter;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.EntityInstantiators;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.ldap.core.LdapOperations;
import org.springframework.ldap.query.LdapQuery;
import org.springframework.util.ClassUtils;

@FunctionalInterface
interface LdapQueryExecution {
    public @Nullable Object execute(LdapQuery var1);

    public static final class ResultProcessingConverter
    implements Converter<Object, Object> {
        private final ResultProcessor processor;
        private final MappingContext<? extends PersistentEntity<?, ?>, ? extends PersistentProperty<?>> mappingContext;
        private final EntityInstantiators instantiators;

        public ResultProcessingConverter(ResultProcessor processor, MappingContext<? extends PersistentEntity<?, ?>, ? extends PersistentProperty<?>> mappingContext, EntityInstantiators instantiators) {
            this.processor = processor;
            this.mappingContext = mappingContext;
            this.instantiators = instantiators;
        }

        public @Nullable Object convert(@Nullable Object source) {
            ReturnedType returnedType = this.processor.getReturnedType();
            if (ClassUtils.isPrimitiveOrWrapper((Class)returnedType.getReturnedType())) {
                return source;
            }
            if (source != null && returnedType.isInstance(source)) {
                return source;
            }
            DtoInstantiatingConverter converter = new DtoInstantiatingConverter(returnedType.getReturnedType(), this.mappingContext, this.instantiators);
            return this.processor.processResult(source, (Converter)converter);
        }
    }

    public static final class ResultProcessingExecution
    implements LdapQueryExecution {
        private final LdapQueryExecution delegate;
        private final Converter<Object, Object> converter;

        public ResultProcessingExecution(LdapQueryExecution delegate, Converter<Object, Object> converter) {
            this.delegate = delegate;
            this.converter = converter;
        }

        @Override
        public @Nullable Object execute(LdapQuery query) {
            Object result = this.delegate.execute(query);
            return result != null ? this.converter.convert(result) : null;
        }
    }

    public static final class StreamExecution
    implements LdapQueryExecution {
        private final LdapOperations operations;
        private final Class<?> entityType;
        private final Converter<Object, Object> resultProcessing;

        StreamExecution(LdapOperations operations, Class<?> entityType, Converter<Object, Object> resultProcessing) {
            this.operations = operations;
            this.entityType = entityType;
            this.resultProcessing = resultProcessing;
        }

        @Override
        public Object execute(LdapQuery query) {
            return this.operations.find(query, this.entityType).stream().map(arg_0 -> this.resultProcessing.convert(arg_0));
        }
    }

    public static final class CollectionExecution
    implements LdapQueryExecution {
        private final LdapOperations operations;
        private final Class<?> entityType;

        CollectionExecution(LdapOperations operations, Class<?> entityType) {
            this.operations = operations;
            this.entityType = entityType;
        }

        @Override
        public Object execute(LdapQuery query) {
            return this.operations.find(query, this.entityType);
        }
    }

    public static final class FindOneExecution
    implements LdapQueryExecution {
        private final LdapOperations operations;
        private final Class<?> entityType;

        FindOneExecution(LdapOperations operations, Class<?> entityType) {
            this.operations = operations;
            this.entityType = entityType;
        }

        @Override
        public @Nullable Object execute(LdapQuery query) {
            try {
                return this.operations.findOne(query, this.entityType);
            }
            catch (EmptyResultDataAccessException e) {
                return null;
            }
        }
    }
}

