/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.ldap.repository.cdi;

import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.springframework.data.ldap.repository.support.LdapRepositoryFactory;
import org.springframework.data.repository.cdi.CdiRepositoryBean;
import org.springframework.data.repository.config.CustomRepositoryImplementationDetector;
import org.springframework.ldap.core.LdapOperations;
import org.springframework.util.Assert;

public class LdapRepositoryBean<T>
extends CdiRepositoryBean<T> {
    private final Bean<LdapOperations> operations;

    LdapRepositoryBean(Bean<LdapOperations> operations, Set<Annotation> qualifiers, Class<T> repositoryType, BeanManager beanManager, Optional<CustomRepositoryImplementationDetector> detector) {
        super(qualifiers, repositoryType, beanManager, detector);
        Assert.notNull(operations, (String)"LdapOperations bean must not be null!");
        this.operations = operations;
    }

    protected T create(CreationalContext<T> creationalContext, Class<T> repositoryType) {
        LdapOperations ldapOperations = (LdapOperations)this.getDependencyInstance(this.operations, LdapOperations.class);
        return (T)this.create(() -> new LdapRepositoryFactory(ldapOperations), repositoryType);
    }

    public Class<? extends Annotation> getScope() {
        return this.operations.getScope();
    }
}

