/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.ldap.repository.support;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.springframework.data.ldap.repository.query.AnnotatedLdapRepositoryQuery;
import org.springframework.data.ldap.repository.query.LdapQueryMethod;
import org.springframework.data.ldap.repository.query.PartTreeLdapRepositoryQuery;
import org.springframework.data.ldap.repository.support.QueryDslLdapRepository;
import org.springframework.data.ldap.repository.support.SimpleLdapRepository;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.querydsl.QueryDslPredicateExecutor;
import org.springframework.data.querydsl.QueryDslUtils;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.ldap.core.LdapOperations;
import org.springframework.util.Assert;

public class LdapRepositoryFactory
extends RepositoryFactorySupport {
    private final LdapQueryLookupStrategy queryLookupStrategy;
    private final LdapOperations ldapOperations;

    public LdapRepositoryFactory(LdapOperations ldapOperations) {
        Assert.notNull((Object)ldapOperations, (String)"LdapOperations must not be null!");
        this.queryLookupStrategy = new LdapQueryLookupStrategy(ldapOperations);
        this.ldapOperations = ldapOperations;
    }

    public <T, ID extends Serializable> EntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        return null;
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return LdapRepositoryFactory.isQueryDslRepository(metadata.getRepositoryInterface()) ? QueryDslLdapRepository.class : SimpleLdapRepository.class;
    }

    private static boolean isQueryDslRepository(Class<?> repositoryInterface) {
        return QueryDslUtils.QUERY_DSL_PRESENT && QueryDslPredicateExecutor.class.isAssignableFrom(repositoryInterface);
    }

    protected Object getTargetRepository(RepositoryInformation information) {
        return this.getTargetRepositoryViaReflection(information, new Object[]{this.ldapOperations, this.ldapOperations.getObjectDirectoryMapper(), information.getDomainType()});
    }

    protected QueryLookupStrategy getQueryLookupStrategy(QueryLookupStrategy.Key key) {
        return this.queryLookupStrategy;
    }

    protected QueryLookupStrategy getQueryLookupStrategy(QueryLookupStrategy.Key key, EvaluationContextProvider evaluationContextProvider) {
        return this.queryLookupStrategy;
    }

    private static final class LdapQueryLookupStrategy
    implements QueryLookupStrategy {
        private LdapOperations ldapOperations;

        public LdapQueryLookupStrategy(LdapOperations ldapOperations) {
            this.ldapOperations = ldapOperations;
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
            LdapQueryMethod queryMethod = new LdapQueryMethod(method, metadata, factory);
            Class domainType = metadata.getDomainType();
            if (queryMethod.hasQueryAnnotation()) {
                return new AnnotatedLdapRepositoryQuery(queryMethod, domainType, this.ldapOperations);
            }
            return new PartTreeLdapRepositoryQuery(queryMethod, domainType, this.ldapOperations);
        }
    }
}

