/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.ArrayList;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.antlr.v4.runtime.tree.Tree;
import org.springframework.data.jpa.repository.query.JpqlBaseVisitor;
import org.springframework.data.jpa.repository.query.JpqlParser;
import org.springframework.data.jpa.repository.query.QueryRenderer;
import org.springframework.data.jpa.repository.query.QueryTokenStream;
import org.springframework.data.jpa.repository.query.QueryTokens;
import org.springframework.util.CollectionUtils;

class JpqlQueryRenderer
extends JpqlBaseVisitor<QueryTokenStream> {
    JpqlQueryRenderer() {
    }

    static boolean isSubquery(ParserRuleContext ctx) {
        if (ctx instanceof JpqlParser.SubqueryContext) {
            return true;
        }
        if (ctx instanceof JpqlParser.Update_statementContext) {
            return false;
        }
        if (ctx instanceof JpqlParser.Delete_statementContext) {
            return false;
        }
        return ctx.getParent() != null && JpqlQueryRenderer.isSubquery(ctx.getParent());
    }

    static boolean isSetQuery(ParserRuleContext ctx) {
        if (ctx instanceof JpqlParser.Set_fuctionContext) {
            return true;
        }
        return ctx.getParent() != null && JpqlQueryRenderer.isSetQuery(ctx.getParent());
    }

    @Override
    public QueryTokenStream visitStart(JpqlParser.StartContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.ql_statement());
    }

    @Override
    public QueryTokenStream visitFrom_clause(JpqlParser.From_clauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.FROM()));
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.identification_variable_declaration()));
        if (!ctx.identificationVariableDeclarationOrCollectionMemberDeclaration().isEmpty()) {
            builder.append(QueryTokens.TOKEN_COMMA);
        }
        builder.appendExpression(QueryTokenStream.concat(ctx.identificationVariableDeclarationOrCollectionMemberDeclaration(), arg_0 -> ((JpqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        return builder;
    }

    @Override
    public QueryTokenStream visitIdentificationVariableDeclarationOrCollectionMemberDeclaration(JpqlParser.IdentificationVariableDeclarationOrCollectionMemberDeclarationContext ctx) {
        if (ctx.subquery() != null) {
            QueryRenderer.QueryRendererBuilder nested = QueryRenderer.builder();
            nested.append(QueryTokens.TOKEN_OPEN_PAREN);
            nested.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.subquery()));
            nested.append(QueryTokens.TOKEN_CLOSE_PAREN);
            QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
            builder.appendExpression(nested);
            if (ctx.AS() != null) {
                builder.append(QueryTokens.expression(ctx.AS()));
            }
            if (ctx.identification_variable() != null) {
                builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.identification_variable()));
            }
            return builder;
        }
        return (QueryTokenStream)super.visitIdentificationVariableDeclarationOrCollectionMemberDeclaration(ctx);
    }

    @Override
    public QueryTokenStream visitJoin_association_path_expression(JpqlParser.Join_association_path_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.TREAT() == null) {
            if (ctx.join_collection_valued_path_expression() != null) {
                builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.join_collection_valued_path_expression()));
            } else if (ctx.join_single_valued_path_expression() != null) {
                builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.join_single_valued_path_expression()));
            }
        } else {
            QueryRenderer.QueryRendererBuilder nested = QueryRenderer.builder();
            if (ctx.join_collection_valued_path_expression() != null) {
                nested.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.join_collection_valued_path_expression()));
                nested.append(QueryTokens.expression(ctx.AS()));
                nested.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.subtype()));
            } else if (ctx.join_single_valued_path_expression() != null) {
                nested.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.join_single_valued_path_expression()));
                nested.append(QueryTokens.expression(ctx.AS()));
                nested.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.subtype()));
            }
            builder.append(QueryTokens.token(ctx.TREAT()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline(nested);
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitJoin_collection_valued_path_expression(JpqlParser.Join_collection_valued_path_expressionContext ctx) {
        ArrayList<ParserRuleContext> items = new ArrayList<ParserRuleContext>(2 + ctx.single_valued_embeddable_object_field().size());
        if (ctx.identification_variable() != null) {
            items.add(ctx.identification_variable());
        }
        items.addAll(ctx.single_valued_embeddable_object_field());
        items.add(ctx.collection_valued_field());
        return QueryTokenStream.concat(items, arg_0 -> ((JpqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_DOT);
    }

    @Override
    public QueryTokenStream visitJoin_single_valued_path_expression(JpqlParser.Join_single_valued_path_expressionContext ctx) {
        ArrayList<ParserRuleContext> items = new ArrayList<ParserRuleContext>(2 + ctx.single_valued_embeddable_object_field().size());
        if (ctx.identification_variable() != null) {
            items.add(ctx.identification_variable());
        }
        items.addAll(ctx.single_valued_embeddable_object_field());
        items.add(ctx.single_valued_object_field());
        return QueryTokenStream.concat(items, arg_0 -> ((JpqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_DOT);
    }

    @Override
    public QueryTokenStream visitCollection_member_declaration(JpqlParser.Collection_member_declarationContext ctx) {
        QueryRenderer.QueryRendererBuilder nested = QueryRenderer.builder();
        nested.append(QueryTokens.token(ctx.IN()));
        nested.append(QueryTokens.TOKEN_OPEN_PAREN);
        nested.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.collection_valued_path_expression()));
        nested.append(QueryTokens.TOKEN_CLOSE_PAREN);
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression(nested);
        if (ctx.AS() != null) {
            builder.append(QueryTokens.expression(ctx.AS()));
        }
        if (ctx.identification_variable() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.identification_variable()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitQualified_identification_variable(JpqlParser.Qualified_identification_variableContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.map_field_identification_variable() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.map_field_identification_variable()));
        } else if (ctx.identification_variable() != null) {
            builder.append(QueryTokens.expression(ctx.ENTRY()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.identification_variable()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitMap_field_identification_variable(JpqlParser.Map_field_identification_variableContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.KEY() != null) {
            builder.append(QueryTokens.token(ctx.KEY()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.identification_variable()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.VALUE() != null) {
            builder.append(QueryTokens.token(ctx.VALUE()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.identification_variable()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitSingle_valued_path_expression(JpqlParser.Single_valued_path_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.qualified_identification_variable() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.qualified_identification_variable()));
        } else if (ctx.qualified_identification_variable() != null) {
            builder.append(QueryTokens.token(ctx.TREAT()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.qualified_identification_variable()));
            builder.append(QueryTokens.expression(ctx.AS()));
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.subtype()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.state_field_path_expression() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.state_field_path_expression()));
        } else if (ctx.single_valued_object_path_expression() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.single_valued_object_path_expression()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitGeneral_subpath(JpqlParser.General_subpathContext ctx) {
        if (ctx.simple_subpath() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.simple_subpath());
        }
        if (ctx.treated_subpath() != null) {
            ArrayList<ParserRuleContext> items = new ArrayList<ParserRuleContext>(1 + ctx.single_valued_object_field().size());
            items.add(ctx.treated_subpath());
            items.addAll(ctx.single_valued_object_field());
            return QueryTokenStream.concat(items, arg_0 -> ((JpqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_DOT);
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitSimple_subpath(JpqlParser.Simple_subpathContext ctx) {
        ArrayList<ParserRuleContext> items = new ArrayList<ParserRuleContext>(1 + ctx.single_valued_object_field().size());
        items.add(ctx.general_identification_variable());
        items.addAll(ctx.single_valued_object_field());
        return QueryTokenStream.concat(items, arg_0 -> ((JpqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_DOT);
    }

    @Override
    public QueryTokenStream visitTreated_subpath(JpqlParser.Treated_subpathContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        QueryRenderer.QueryRendererBuilder nested = QueryRenderer.builder();
        nested.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.general_subpath()));
        nested.append(QueryTokens.expression(ctx.AS()));
        nested.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.subtype()));
        builder.append(QueryTokens.token(ctx.TREAT()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline(nested);
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitState_field_path_expression(JpqlParser.State_field_path_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.general_subpath()));
        builder.append(QueryTokens.TOKEN_DOT);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.state_field()));
        return builder;
    }

    @Override
    public QueryTokenStream visitSingle_valued_object_path_expression(JpqlParser.Single_valued_object_path_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.general_subpath()));
        builder.append(QueryTokens.TOKEN_DOT);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.single_valued_object_field()));
        return builder;
    }

    @Override
    public QueryTokenStream visitCollection_valued_path_expression(JpqlParser.Collection_valued_path_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.general_subpath()));
        builder.append(QueryTokens.TOKEN_DOT);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.collection_value_field()));
        return builder;
    }

    @Override
    public QueryTokenStream visitUpdate_clause(JpqlParser.Update_clauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.UPDATE()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.entity_name()));
        if (ctx.AS() != null) {
            builder.append(QueryTokens.expression(ctx.AS()));
        }
        if (ctx.identification_variable() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.identification_variable()));
        }
        builder.append(QueryTokens.expression(ctx.SET()));
        builder.append(QueryTokenStream.concat(ctx.update_item(), arg_0 -> ((JpqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        return builder;
    }

    @Override
    public QueryTokenStream visitUpdate_item(JpqlParser.Update_itemContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        ArrayList<ParserRuleContext> items = new ArrayList<ParserRuleContext>(3 + ctx.single_valued_embeddable_object_field().size());
        if (ctx.identification_variable() != null) {
            items.add(ctx.identification_variable());
        }
        items.addAll(ctx.single_valued_embeddable_object_field());
        if (ctx.state_field() != null) {
            items.add(ctx.state_field());
        } else if (ctx.single_valued_object_field() != null) {
            items.add(ctx.single_valued_object_field());
        }
        builder.appendInline(QueryTokenStream.concat(items, arg_0 -> ((JpqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_DOT));
        builder.append(QueryTokens.TOKEN_EQUALS);
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.new_value()));
        return builder;
    }

    @Override
    public QueryTokenStream visitSelect_clause(JpqlParser.Select_clauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = this.prepareSelectClause(ctx);
        builder.appendExpression(QueryTokenStream.concat(ctx.select_item(), arg_0 -> ((JpqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        return builder;
    }

    QueryRenderer.QueryRendererBuilder prepareSelectClause(JpqlParser.Select_clauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.SELECT()));
        if (ctx.DISTINCT() != null) {
            builder.append(QueryTokens.expression(ctx.DISTINCT()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitSelect_expression(JpqlParser.Select_expressionContext ctx) {
        if (ctx.identification_variable() != null && ctx.OBJECT() != null) {
            QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
            builder.append(QueryTokens.token(ctx.OBJECT()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.identification_variable()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
            return builder;
        }
        return (QueryTokenStream)super.visitSelect_expression(ctx);
    }

    @Override
    public QueryTokenStream visitConstructor_expression(JpqlParser.Constructor_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.NEW()));
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.constructor_name()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline(QueryTokenStream.concat(ctx.constructor_item(), arg_0 -> ((JpqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitAggregate_expression(JpqlParser.Aggregate_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.AVG() != null || ctx.MAX() != null || ctx.MIN() != null || ctx.SUM() != null) {
            if (ctx.AVG() != null) {
                builder.append(QueryTokens.token(ctx.AVG()));
            }
            if (ctx.MAX() != null) {
                builder.append(QueryTokens.token(ctx.MAX()));
            }
            if (ctx.MIN() != null) {
                builder.append(QueryTokens.token(ctx.MIN()));
            }
            if (ctx.SUM() != null) {
                builder.append(QueryTokens.token(ctx.SUM()));
            }
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            if (ctx.DISTINCT() != null) {
                builder.append(QueryTokens.expression(ctx.DISTINCT()));
            }
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.state_valued_path_expression()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.COUNT() != null) {
            builder.append(QueryTokens.token(ctx.COUNT()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            if (ctx.DISTINCT() != null) {
                builder.append(QueryTokens.expression(ctx.DISTINCT()));
            }
            if (ctx.identification_variable() != null) {
                builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.identification_variable()));
            } else if (ctx.state_valued_path_expression() != null) {
                builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.state_valued_path_expression()));
            } else if (ctx.single_valued_object_path_expression() != null) {
                builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.single_valued_object_path_expression()));
            }
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.function_invocation() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.function_invocation()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitGroupby_clause(JpqlParser.Groupby_clauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.GROUP()));
        builder.append(QueryTokens.expression(ctx.BY()));
        builder.appendExpression(QueryTokenStream.concat(ctx.groupby_item(), arg_0 -> ((JpqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        return builder;
    }

    @Override
    public QueryTokenStream visitOrderby_clause(JpqlParser.Orderby_clauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.ORDER()));
        builder.append(QueryTokens.expression(ctx.BY()));
        builder.append(QueryTokenStream.concat(ctx.orderby_item(), arg_0 -> ((JpqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        return builder;
    }

    @Override
    public QueryTokenStream visitSubquery_from_clause(JpqlParser.Subquery_from_clauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.FROM()));
        builder.appendExpression(QueryTokenStream.concat(ctx.subselect_identification_variable_declaration(), arg_0 -> ((JpqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        return builder;
    }

    @Override
    public QueryTokenStream visitConditional_primary(JpqlParser.Conditional_primaryContext ctx) {
        if (ctx.conditional_expression() != null) {
            return QueryTokenStream.group((QueryTokenStream)this.visit((ParseTree)ctx.conditional_expression()));
        }
        return (QueryTokenStream)super.visitConditional_primary(ctx);
    }

    @Override
    public QueryTokenStream visitIn_expression(JpqlParser.In_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.string_expression() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.string_expression()));
        }
        if (ctx.type_discriminator() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.type_discriminator()));
        }
        if (ctx.NOT() != null) {
            builder.append(QueryTokens.expression(ctx.NOT()));
        }
        if (ctx.IN() != null) {
            builder.append(QueryTokens.expression(ctx.IN()));
        }
        if (ctx.in_item() != null && !ctx.in_item().isEmpty()) {
            builder.append(QueryTokenStream.group(QueryTokenStream.concat(ctx.in_item(), arg_0 -> ((JpqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA)));
        } else if (ctx.subquery() != null) {
            builder.append(QueryTokenStream.group((QueryTokenStream)this.visit((ParseTree)ctx.subquery())));
        } else if (ctx.collection_valued_input_parameter() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.collection_valued_input_parameter()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitExists_expression(JpqlParser.Exists_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.NOT() != null) {
            builder.append(QueryTokens.expression(ctx.NOT()));
        }
        builder.append(QueryTokens.expression(ctx.EXISTS()));
        builder.append(QueryTokenStream.group((QueryTokenStream)this.visit((ParseTree)ctx.subquery())));
        return builder;
    }

    @Override
    public QueryTokenStream visitAll_or_any_expression(JpqlParser.All_or_any_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.ALL() != null) {
            builder.append(QueryTokens.expression(ctx.ALL()));
        } else if (ctx.ANY() != null) {
            builder.append(QueryTokens.expression(ctx.ANY()));
        } else if (ctx.SOME() != null) {
            builder.append(QueryTokens.expression(ctx.SOME()));
        }
        builder.append(QueryTokenStream.group((QueryTokenStream)this.visit((ParseTree)ctx.subquery())));
        return builder;
    }

    @Override
    public QueryTokenStream visitArithmetic_factor(JpqlParser.Arithmetic_factorContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.op != null) {
            builder.append(QueryTokens.token(ctx.op));
        }
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_primary()));
        return builder;
    }

    @Override
    public QueryTokenStream visitArithmetic_primary(JpqlParser.Arithmetic_primaryContext ctx) {
        if (ctx.arithmetic_expression() != null) {
            return QueryTokenStream.group((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression()));
        }
        if (ctx.subquery() != null) {
            return QueryTokenStream.group((QueryTokenStream)this.visit((ParseTree)ctx.subquery()));
        }
        return (QueryTokenStream)super.visitArithmetic_primary(ctx);
    }

    @Override
    public QueryTokenStream visitString_expression(JpqlParser.String_expressionContext ctx) {
        QueryRenderer.builder();
        if (ctx.subquery() != null) {
            return QueryTokenStream.group((QueryTokenStream)this.visit((ParseTree)ctx.subquery()));
        }
        return (QueryTokenStream)super.visitString_expression(ctx);
    }

    @Override
    public QueryTokenStream visitDatetime_expression(JpqlParser.Datetime_expressionContext ctx) {
        if (ctx.subquery() != null) {
            return QueryTokenStream.group((QueryTokenStream)this.visit((ParseTree)ctx.subquery()));
        }
        return (QueryTokenStream)super.visitDatetime_expression(ctx);
    }

    @Override
    public QueryTokenStream visitBoolean_expression(JpqlParser.Boolean_expressionContext ctx) {
        if (ctx.subquery() != null) {
            return QueryTokenStream.group((QueryTokenStream)this.visit((ParseTree)ctx.subquery()));
        }
        return (QueryTokenStream)super.visitBoolean_expression(ctx);
    }

    @Override
    public QueryTokenStream visitEnum_expression(JpqlParser.Enum_expressionContext ctx) {
        if (ctx.subquery() != null) {
            return QueryTokenStream.group((QueryTokenStream)this.visit((ParseTree)ctx.subquery()));
        }
        return (QueryTokenStream)super.visitEnum_expression(ctx);
    }

    @Override
    public QueryTokenStream visitType_discriminator(JpqlParser.Type_discriminatorContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.general_identification_variable() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.general_identification_variable()));
        } else if (ctx.single_valued_object_path_expression() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.single_valued_object_path_expression()));
        } else if (ctx.input_parameter() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.input_parameter()));
        }
        return QueryTokenStream.ofFunction(ctx.TYPE(), builder);
    }

    @Override
    public QueryTokenStream visitFunctions_returning_numerics(JpqlParser.Functions_returning_numericsContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.LENGTH() != null) {
            return QueryTokenStream.ofFunction(ctx.LENGTH(), (QueryTokenStream)this.visit((ParseTree)ctx.string_expression(0)));
        }
        if (ctx.LOCATE() != null) {
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.string_expression(0)));
            builder.append(QueryTokens.TOKEN_COMMA);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.string_expression(1)));
            if (ctx.arithmetic_expression() != null) {
                builder.append(QueryTokens.TOKEN_COMMA);
                builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(0)));
            }
            return QueryTokenStream.ofFunction(ctx.LOCATE(), builder);
        }
        if (ctx.ABS() != null) {
            return QueryTokenStream.ofFunction(ctx.ABS(), (QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(0)));
        }
        if (ctx.CEILING() != null) {
            return QueryTokenStream.ofFunction(ctx.CEILING(), (QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(0)));
        }
        if (ctx.EXP() != null) {
            return QueryTokenStream.ofFunction(ctx.EXP(), (QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(0)));
        }
        if (ctx.FLOOR() != null) {
            return QueryTokenStream.ofFunction(ctx.FLOOR(), (QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(0)));
        }
        if (ctx.LN() != null) {
            return QueryTokenStream.ofFunction(ctx.LN(), (QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(0)));
        }
        if (ctx.SIGN() != null) {
            return QueryTokenStream.ofFunction(ctx.SIGN(), (QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(0)));
        }
        if (ctx.SQRT() != null) {
            return QueryTokenStream.ofFunction(ctx.SQRT(), (QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(0)));
        }
        if (ctx.MOD() != null) {
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(0)));
            builder.append(QueryTokens.TOKEN_COMMA);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(1)));
            return QueryTokenStream.ofFunction(ctx.MOD(), builder);
        }
        if (ctx.POWER() != null) {
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(0)));
            builder.append(QueryTokens.TOKEN_COMMA);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(1)));
            return QueryTokenStream.ofFunction(ctx.POWER(), builder);
        }
        if (ctx.ROUND() != null) {
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(0)));
            builder.append(QueryTokens.TOKEN_COMMA);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(1)));
            return QueryTokenStream.ofFunction(ctx.ROUND(), builder);
        }
        if (ctx.SIZE() != null) {
            return QueryTokenStream.ofFunction(ctx.SIZE(), (QueryTokenStream)this.visit((ParseTree)ctx.collection_valued_path_expression()));
        }
        if (ctx.INDEX() != null) {
            return QueryTokenStream.ofFunction(ctx.INDEX(), (QueryTokenStream)this.visit((ParseTree)ctx.identification_variable()));
        }
        if (ctx.extract_datetime_field() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.extract_datetime_field()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitFunctions_returning_strings(JpqlParser.Functions_returning_stringsContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.CONCAT() != null) {
            return QueryTokenStream.ofFunction(ctx.CONCAT(), QueryTokenStream.concat(ctx.string_expression(), arg_0 -> ((JpqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        }
        if (ctx.SUBSTRING() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.string_expression(0)));
            builder.append(QueryTokens.TOKEN_COMMA);
            builder.appendInline(QueryTokenStream.concat(ctx.arithmetic_expression(), arg_0 -> ((JpqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
            return QueryTokenStream.ofFunction(ctx.SUBSTRING(), builder);
        }
        if (ctx.TRIM() != null) {
            if (ctx.trim_specification() != null) {
                builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.trim_specification()));
            }
            if (ctx.trim_character() != null) {
                builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.trim_character()));
            }
            if (ctx.FROM() != null) {
                builder.append(QueryTokens.expression(ctx.FROM()));
            }
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.string_expression(0)));
            return QueryTokenStream.ofFunction(ctx.TRIM(), builder);
        }
        if (ctx.LOWER() != null) {
            return QueryTokenStream.ofFunction(ctx.LOWER(), QueryTokenStream.concat(ctx.string_expression(), arg_0 -> ((JpqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        }
        if (ctx.UPPER() != null) {
            return QueryTokenStream.ofFunction(ctx.UPPER(), QueryTokenStream.concat(ctx.string_expression(), arg_0 -> ((JpqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        }
        if (ctx.LEFT() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.string_expression(0)));
            builder.append(QueryTokens.TOKEN_COMMA);
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(0)));
            return QueryTokenStream.ofFunction(ctx.LEFT(), builder);
        }
        if (ctx.RIGHT() != null) {
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.string_expression(0)));
            builder.append(QueryTokens.TOKEN_COMMA);
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(0)));
            return QueryTokenStream.ofFunction(ctx.RIGHT(), builder);
        }
        if (ctx.REPLACE() != null) {
            return QueryTokenStream.ofFunction(ctx.REPLACE(), QueryTokenStream.concat(ctx.string_expression(), arg_0 -> ((JpqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitArithmetic_cast_function(JpqlParser.Arithmetic_cast_functionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.string_expression()));
        if (ctx.AS() != null) {
            builder.append(QueryTokens.expression(ctx.AS()));
        }
        builder.append(QueryTokens.token(ctx.f));
        return QueryTokenStream.ofFunction(ctx.CAST(), builder);
    }

    @Override
    public QueryTokenStream visitType_cast_function(JpqlParser.Type_cast_functionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.scalar_expression()));
        if (ctx.AS() != null) {
            builder.append(QueryTokens.expression(ctx.AS()));
        }
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.identification_variable()));
        if (!CollectionUtils.isEmpty(ctx.numeric_literal())) {
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline(QueryTokenStream.concat(ctx.numeric_literal(), arg_0 -> ((JpqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        return QueryTokenStream.ofFunction(ctx.CAST(), builder);
    }

    @Override
    public QueryTokenStream visitString_cast_function(JpqlParser.String_cast_functionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.scalar_expression()));
        if (ctx.AS() != null) {
            builder.append(QueryTokens.expression(ctx.AS()));
        }
        builder.append(QueryTokens.token(ctx.STRING()));
        return QueryTokenStream.ofFunction(ctx.CAST(), builder);
    }

    @Override
    public QueryTokenStream visitFunction_invocation(JpqlParser.Function_invocationContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.FUNCTION()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.function_name()));
        if (!ctx.function_arg().isEmpty()) {
            builder.append(QueryTokens.TOKEN_COMMA);
            builder.appendInline(QueryTokenStream.concat(ctx.function_arg(), arg_0 -> ((JpqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        }
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitExtract_datetime_field(JpqlParser.Extract_datetime_fieldContext ctx) {
        QueryRenderer.QueryRendererBuilder nested = QueryRenderer.builder();
        nested.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.datetime_field()));
        nested.append(QueryTokens.expression(ctx.FROM()));
        nested.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.datetime_expression()));
        return QueryTokenStream.ofFunction(ctx.EXTRACT(), nested);
    }

    @Override
    public QueryTokenStream visitDatetime_field(JpqlParser.Datetime_fieldContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.identification_variable());
    }

    @Override
    public QueryTokenStream visitExtract_datetime_part(JpqlParser.Extract_datetime_partContext ctx) {
        QueryRenderer.QueryRendererBuilder nested = QueryRenderer.builder();
        nested.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.datetime_part()));
        nested.append(QueryTokens.expression(ctx.FROM()));
        nested.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.datetime_expression()));
        return QueryTokenStream.ofFunction(ctx.EXTRACT(), nested);
    }

    @Override
    public QueryTokenStream visitCoalesce_expression(JpqlParser.Coalesce_expressionContext ctx) {
        return QueryTokenStream.ofFunction(ctx.COALESCE(), QueryTokenStream.concat(ctx.scalar_expression(), arg_0 -> ((JpqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
    }

    @Override
    public QueryTokenStream visitNullif_expression(JpqlParser.Nullif_expressionContext ctx) {
        return QueryTokenStream.ofFunction(ctx.NULLIF(), QueryTokenStream.concat(ctx.scalar_expression(), arg_0 -> ((JpqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
    }

    @Override
    public QueryTokenStream visitInput_parameter(JpqlParser.Input_parameterContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.INTLITERAL() != null) {
            builder.append(QueryTokens.TOKEN_QUESTION_MARK);
            builder.append(QueryTokens.token(ctx.INTLITERAL()));
        } else if (ctx.identification_variable() != null) {
            builder.append(QueryTokens.TOKEN_COLON);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.identification_variable()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitEntity_name(JpqlParser.Entity_nameContext ctx) {
        return QueryTokenStream.concat(ctx.reserved_word(), arg_0 -> ((JpqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_DOT);
    }

    public QueryTokenStream visitChildren(RuleNode node) {
        ParseTree parseTree;
        ParseTree parseTree2;
        int childCount = node.getChildCount();
        if (childCount == 1 && (parseTree2 = node.getChild(0)) instanceof RuleContext) {
            RuleContext t = (RuleContext)parseTree2;
            return (QueryTokenStream)this.visit((ParseTree)t);
        }
        if (childCount == 1 && (parseTree = node.getChild(0)) instanceof TerminalNode) {
            TerminalNode t = (TerminalNode)parseTree;
            return QueryTokens.token(t);
        }
        return QueryTokenStream.concatExpressions((Tree)node, arg_0 -> ((JpqlQueryRenderer)this).visit(arg_0));
    }
}

