/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import jakarta.persistence.EntityManager;
import jakarta.persistence.metamodel.Metamodel;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.JpaQueryCreator;
import org.springframework.data.jpa.repository.query.JpqlQueryBuilder;
import org.springframework.data.jpa.repository.query.ParameterMetadataProvider;
import org.springframework.data.jpa.repository.support.JpqlQueryTemplates;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.query.parser.PartTree;

public class JpaCountQueryCreator
extends JpaQueryCreator {
    private final boolean distinct;
    private final ReturnedType returnedType;

    public JpaCountQueryCreator(PartTree tree, ReturnedType returnedType, ParameterMetadataProvider provider, JpqlQueryTemplates templates, EntityManager em) {
        super(tree, returnedType, provider, templates, em);
        this.distinct = tree.isDistinct();
        this.returnedType = returnedType;
    }

    public JpaCountQueryCreator(PartTree tree, ReturnedType returnedType, ParameterMetadataProvider provider, JpqlQueryTemplates templates, Metamodel metamodel) {
        super(tree, returnedType, provider, templates, metamodel);
        this.distinct = tree.isDistinct();
        this.returnedType = returnedType;
    }

    @Override
    protected JpqlQueryBuilder.Select buildQuery(Sort sort) {
        JpqlQueryBuilder.SelectStep selectStep = JpqlQueryBuilder.selectFrom(this.returnedType.getDomainType());
        if (this.distinct) {
            selectStep = selectStep.distinct();
        }
        return selectStep.count();
    }
}

