/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.EntityQuery;
import org.springframework.data.jpa.repository.query.ParameterBinding;
import org.springframework.data.jpa.repository.query.ParametrizedQuery;
import org.springframework.data.jpa.repository.query.PreprocessedQuery;
import org.springframework.data.jpa.repository.query.QueryEnhancer;
import org.springframework.data.jpa.repository.query.QueryEnhancerFactory;
import org.springframework.data.jpa.repository.query.QueryProvider;

class DefaultEntityQuery
implements EntityQuery,
DeclaredQuery {
    private final PreprocessedQuery query;
    private final QueryEnhancer queryEnhancer;

    DefaultEntityQuery(PreprocessedQuery query, QueryEnhancerFactory queryEnhancerFactory) {
        this.query = query;
        this.queryEnhancer = queryEnhancerFactory.create(query);
    }

    @Override
    public boolean isNative() {
        return this.query.isNative();
    }

    @Override
    public String getQueryString() {
        return this.query.getQueryString();
    }

    @Override
    public boolean hasParameterBindings() {
        return this.query.hasBindings();
    }

    @Override
    public boolean usesJdbcStyleParameters() {
        return this.query.usesJdbcStyleParameters();
    }

    @Override
    public boolean hasNamedParameter() {
        return this.query.hasNamedBindings();
    }

    @Override
    public List<ParameterBinding> getParameterBindings() {
        return this.query.getBindings();
    }

    @Override
    public boolean hasConstructorExpression() {
        return this.queryEnhancer.hasConstructorExpression();
    }

    @Override
    public boolean isDefaultProjection() {
        return this.queryEnhancer.getProjection().equalsIgnoreCase(this.getAlias());
    }

    @Nullable
    String getAlias() {
        return this.queryEnhancer.detectAlias();
    }

    @Override
    public boolean usesPaging() {
        return this.query.containsPageableInSpel();
    }

    String getProjection() {
        return this.queryEnhancer.getProjection();
    }

    @Override
    public ParametrizedQuery deriveCountQuery(@Nullable String countQueryProjection) {
        return new SimpleParametrizedQuery(this.query.rewrite(this.queryEnhancer.createCountQueryFor(countQueryProjection)));
    }

    @Override
    public QueryProvider rewrite(QueryEnhancer.QueryRewriteInformation rewriteInformation) {
        return this.query.rewrite(this.queryEnhancer.rewrite(rewriteInformation));
    }

    public String toString() {
        return "EntityQuery[" + this.getQueryString() + ", " + String.valueOf(this.getParameterBindings()) + "]";
    }

    static class SimpleParametrizedQuery
    implements ParametrizedQuery {
        private final PreprocessedQuery query;

        SimpleParametrizedQuery(PreprocessedQuery query) {
            this.query = query;
        }

        @Override
        public String getQueryString() {
            return this.query.getQueryString();
        }

        @Override
        public boolean hasParameterBindings() {
            return this.query.hasBindings();
        }

        @Override
        public boolean usesJdbcStyleParameters() {
            return this.query.usesJdbcStyleParameters();
        }

        @Override
        public boolean hasNamedParameter() {
            return this.query.hasNamedBindings();
        }

        @Override
        public List<ParameterBinding> getParameterBindings() {
            return this.query.getBindings();
        }
    }
}

