/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.aot;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.metamodel.EmbeddableType;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.spi.ClassTransformer;
import jakarta.persistence.spi.PersistenceUnitInfo;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.jpa.HibernatePersistenceProvider;
import org.hibernate.jpa.boot.internal.EntityManagerFactoryBuilderImpl;
import org.hibernate.jpa.boot.internal.PersistenceUnitInfoDescriptor;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;
import org.springframework.data.util.Lazy;
import org.springframework.instrument.classloading.SimpleThrowawayClassLoader;
import org.springframework.orm.jpa.persistenceunit.MutablePersistenceUnitInfo;

class AotMetamodel
implements Metamodel {
    private final String persistenceUnit;
    private final Set<Class<?>> managedTypes;
    private final Lazy<EntityManagerFactory> entityManagerFactory = Lazy.of(this::init);
    private final Lazy<Metamodel> metamodel = Lazy.of(() -> ((EntityManagerFactory)this.entityManagerFactory.get()).getMetamodel());
    private final Lazy<EntityManager> entityManager = Lazy.of(() -> ((EntityManagerFactory)this.entityManagerFactory.get()).createEntityManager());

    public AotMetamodel(Set<Class<?>> managedTypes) {
        this("dynamic-tests", managedTypes);
    }

    private AotMetamodel(String persistenceUnit, Set<Class<?>> managedTypes) {
        this.persistenceUnit = persistenceUnit;
        this.managedTypes = managedTypes;
    }

    public static AotMetamodel hibernateModel(Class<?> ... types) {
        return new AotMetamodel(Set.of(types));
    }

    public static AotMetamodel hibernateModel(String persistenceUnit, Class<?> ... types) {
        return new AotMetamodel(persistenceUnit, Set.of(types));
    }

    public <X> EntityType<X> entity(Class<X> cls) {
        return ((Metamodel)this.metamodel.get()).entity(cls);
    }

    public EntityType<?> entity(String s) {
        return ((Metamodel)this.metamodel.get()).entity(s);
    }

    public <X> ManagedType<X> managedType(Class<X> cls) {
        return ((Metamodel)this.metamodel.get()).managedType(cls);
    }

    public <X> EmbeddableType<X> embeddable(Class<X> cls) {
        return ((Metamodel)this.metamodel.get()).embeddable(cls);
    }

    public Set<ManagedType<?>> getManagedTypes() {
        return ((Metamodel)this.metamodel.get()).getManagedTypes();
    }

    public Set<EntityType<?>> getEntities() {
        return ((Metamodel)this.metamodel.get()).getEntities();
    }

    public Set<EmbeddableType<?>> getEmbeddables() {
        return ((Metamodel)this.metamodel.get()).getEmbeddables();
    }

    public EntityManager entityManager() {
        return (EntityManager)this.entityManager.get();
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return (EntityManagerFactory)this.entityManagerFactory.get();
    }

    EntityManagerFactory init() {
        final MutablePersistenceUnitInfo persistenceUnitInfo = new MutablePersistenceUnitInfo(){

            public ClassLoader getNewTempClassLoader() {
                return new SimpleThrowawayClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            }

            public void addTransformer(ClassTransformer classTransformer) {
            }
        };
        persistenceUnitInfo.setPersistenceUnitName(this.persistenceUnit);
        this.managedTypes.stream().map(Class::getName).forEach(arg_0 -> ((MutablePersistenceUnitInfo)persistenceUnitInfo).addManagedClassName(arg_0));
        persistenceUnitInfo.setPersistenceProviderClassName(HibernatePersistenceProvider.class.getName());
        return new EntityManagerFactoryBuilderImpl((PersistenceUnitDescriptor)new PersistenceUnitInfoDescriptor((PersistenceUnitInfo)persistenceUnitInfo){

            public List<String> getManagedClassNames() {
                return persistenceUnitInfo.getManagedClassNames();
            }
        }, Map.of("hibernate.dialect", "org.hibernate.dialect.H2Dialect", "hibernate.boot.allow_jdbc_metadata_access", "false")).build();
    }
}

