/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.provider;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.metamodel.IdentifiableType;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.SingularAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.persistence.jpa.JpaQuery;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.proxy.HibernateProxy;
import org.springframework.data.jpa.provider.HibernateJpaParametersParameterAccessor;
import org.springframework.data.jpa.provider.HibernateUtils;
import org.springframework.data.jpa.provider.JpaClassUtils;
import org.springframework.data.jpa.provider.ProxyIdAccessor;
import org.springframework.data.jpa.provider.QueryComment;
import org.springframework.data.jpa.provider.QueryExtractor;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.JpaParametersParameterAccessor;
import org.springframework.data.util.CloseableIterator;
import org.springframework.lang.Nullable;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ConcurrentReferenceHashMap;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class PersistenceProvider
extends Enum<PersistenceProvider>
implements QueryExtractor,
ProxyIdAccessor,
QueryComment {
    public static final /* enum */ PersistenceProvider HIBERNATE;
    public static final /* enum */ PersistenceProvider ECLIPSELINK;
    public static final /* enum */ PersistenceProvider GENERIC_JPA;
    private static final Class<?> typedParameterValueClass;
    private static final Collection<PersistenceProvider> ALL;
    static ConcurrentReferenceHashMap<Class<?>, PersistenceProvider> CACHE;
    private final Iterable<String> entityManagerClassNames;
    private final Iterable<String> metamodelClassNames;
    private static final /* synthetic */ PersistenceProvider[] $VALUES;

    public static PersistenceProvider[] values() {
        return (PersistenceProvider[])$VALUES.clone();
    }

    public static PersistenceProvider valueOf(String name) {
        return Enum.valueOf(PersistenceProvider.class, name);
    }

    private PersistenceProvider(Iterable<String> entityManagerClassNames, Iterable<String> metamodelClassNames) {
        this.entityManagerClassNames = entityManagerClassNames;
        this.metamodelClassNames = metamodelClassNames;
    }

    private static PersistenceProvider cacheAndReturn(Class<?> type, PersistenceProvider provider) {
        CACHE.put(type, (Object)provider);
        return provider;
    }

    public static PersistenceProvider fromEntityManager(EntityManager em) {
        Assert.notNull((Object)em, (String)"EntityManager must not be null");
        Class<?> entityManagerType = em.getDelegate().getClass();
        PersistenceProvider cachedProvider = (PersistenceProvider)CACHE.get(entityManagerType);
        if (cachedProvider != null) {
            return cachedProvider;
        }
        for (PersistenceProvider provider : ALL) {
            for (String entityManagerClassName : provider.entityManagerClassNames) {
                if (!JpaClassUtils.isEntityManagerOfType(em, entityManagerClassName)) continue;
                return PersistenceProvider.cacheAndReturn(entityManagerType, provider);
            }
        }
        return PersistenceProvider.cacheAndReturn(entityManagerType, GENERIC_JPA);
    }

    public static PersistenceProvider fromMetamodel(Metamodel metamodel) {
        Assert.notNull((Object)metamodel, (String)"Metamodel must not be null");
        Class<?> metamodelType = metamodel.getClass();
        PersistenceProvider cachedProvider = (PersistenceProvider)CACHE.get(metamodelType);
        if (cachedProvider != null) {
            return cachedProvider;
        }
        for (PersistenceProvider provider : PersistenceProvider.values()) {
            for (String metamodelClassName : provider.metamodelClassNames) {
                if (!JpaClassUtils.isMetamodelOfType(metamodel, metamodelClassName)) continue;
                return PersistenceProvider.cacheAndReturn(metamodelType, provider);
            }
        }
        return PersistenceProvider.cacheAndReturn(metamodelType, GENERIC_JPA);
    }

    public JpaParametersParameterAccessor getParameterAccessor(JpaParameters parameters, Object[] values, EntityManager em) {
        return new JpaParametersParameterAccessor(parameters, values);
    }

    public String getCountQueryPlaceholder() {
        return "x";
    }

    @Override
    public boolean canExtractQuery() {
        return true;
    }

    public <T> Set<SingularAttribute<? super T, ?>> getIdClassAttributes(IdentifiableType<T> type) {
        try {
            return type.getIdClassAttributes();
        }
        catch (IllegalArgumentException e) {
            return Collections.emptySet();
        }
    }

    public static Object unwrapTypedParameterValue(Object value) {
        return typedParameterValueClass != null && typedParameterValueClass.isInstance(value) ? null : value;
    }

    public CloseableIterator<Object> executeQueryWithResultStream(Query jpaQuery) {
        throw new UnsupportedOperationException("Streaming results is not implement for this PersistenceProvider: " + this.name());
    }

    private static /* synthetic */ PersistenceProvider[] $values() {
        return new PersistenceProvider[]{HIBERNATE, ECLIPSELINK, GENERIC_JPA};
    }

    static {
        Class type;
        HIBERNATE = new PersistenceProvider(Collections.singletonList("org.hibernate.engine.spi.SessionImplementor"), Collections.singletonList("org.hibernate.metamodel.model.domain.JpaMetamodel")){

            @Override
            public String extractQueryString(Query query) {
                return HibernateUtils.getHibernateQuery(query);
            }

            @Override
            public String getCountQueryPlaceholder() {
                return "*";
            }

            @Override
            public boolean shouldUseAccessorFor(Object entity) {
                return entity instanceof HibernateProxy;
            }

            @Override
            public Object getIdentifierFrom(Object entity) {
                return ((HibernateProxy)entity).getHibernateLazyInitializer().getIdentifier();
            }

            @Override
            public <T> Set<SingularAttribute<? super T, ?>> getIdClassAttributes(IdentifiableType<T> type) {
                return type.hasSingleIdAttribute() ? Collections.emptySet() : super.getIdClassAttributes(type);
            }

            @Override
            public CloseableIterator<Object> executeQueryWithResultStream(Query jpaQuery) {
                return new HibernateScrollableResultsIterator(jpaQuery);
            }

            @Override
            public JpaParametersParameterAccessor getParameterAccessor(JpaParameters parameters, Object[] values, EntityManager em) {
                return new HibernateJpaParametersParameterAccessor(parameters, values, em);
            }

            @Override
            public String getCommentHintKey() {
                return "org.hibernate.comment";
            }
        };
        ECLIPSELINK = new PersistenceProvider(Collections.singleton("org.eclipse.persistence.jpa.JpaEntityManager"), Collections.singleton("org.eclipse.persistence.internal.jpa.metamodel.MetamodelImpl")){

            @Override
            public String extractQueryString(Query query) {
                return ((JpaQuery)query).getDatabaseQuery().getJPQLString();
            }

            @Override
            public boolean shouldUseAccessorFor(Object entity) {
                return false;
            }

            @Override
            @Nullable
            public Object getIdentifierFrom(Object entity) {
                return null;
            }

            @Override
            public CloseableIterator<Object> executeQueryWithResultStream(Query jpaQuery) {
                return new EclipseLinkScrollableResultsIterator<Object>(jpaQuery);
            }

            @Override
            public String getCommentHintKey() {
                return "eclipselink.sql.hint";
            }

            @Override
            public String getCommentHintValue(String comment) {
                return "/* " + comment + " */";
            }
        };
        GENERIC_JPA = new PersistenceProvider(Collections.singleton("jakarta.persistence.EntityManager"), (Iterable)Collections.emptySet()){

            @Override
            @Nullable
            public String extractQueryString(Query query) {
                return null;
            }

            @Override
            public boolean canExtractQuery() {
                return false;
            }

            @Override
            public boolean shouldUseAccessorFor(Object entity) {
                return false;
            }

            @Override
            @Nullable
            public Object getIdentifierFrom(Object entity) {
                return null;
            }

            @Override
            @Nullable
            public String getCommentHintKey() {
                return null;
            }
        };
        $VALUES = PersistenceProvider.$values();
        try {
            type = ClassUtils.forName((String)"org.hibernate.query.TypedParameterValue", (ClassLoader)PersistenceProvider.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            type = null;
        }
        typedParameterValueClass = type;
        ALL = List.of(HIBERNATE, ECLIPSELINK, GENERIC_JPA);
        CACHE = new ConcurrentReferenceHashMap();
    }

    static interface Constants {
        public static final String GENERIC_JPA_ENTITY_MANAGER_INTERFACE = "jakarta.persistence.EntityManager";
        public static final String ECLIPSELINK_ENTITY_MANAGER_INTERFACE = "org.eclipse.persistence.jpa.JpaEntityManager";
        public static final String HIBERNATE_ENTITY_MANAGER_INTERFACE = "org.hibernate.engine.spi.SessionImplementor";
        public static final String HIBERNATE_JPA_METAMODEL_TYPE = "org.hibernate.metamodel.model.domain.JpaMetamodel";
        public static final String ECLIPSELINK_JPA_METAMODEL_TYPE = "org.eclipse.persistence.internal.jpa.metamodel.MetamodelImpl";
    }

    private static class EclipseLinkScrollableResultsIterator<T>
    implements CloseableIterator<T> {
        @Nullable
        private final ScrollableCursor scrollableCursor;

        EclipseLinkScrollableResultsIterator(Query jpaQuery) {
            jpaQuery.setHint("eclipselink.cursor.scrollable", (Object)true);
            this.scrollableCursor = (ScrollableCursor)jpaQuery.getSingleResult();
        }

        public boolean hasNext() {
            return this.scrollableCursor != null && this.scrollableCursor.hasNext();
        }

        public T next() {
            if (this.scrollableCursor == null) {
                throw new NoSuchElementException("No ScrollableCursor");
            }
            return (T)this.scrollableCursor.next();
        }

        public void close() {
            if (this.scrollableCursor != null) {
                this.scrollableCursor.close();
            }
        }
    }

    private static class HibernateScrollableResultsIterator
    implements CloseableIterator<Object> {
        @Nullable
        private final ScrollableResults<Object[]> scrollableResults;

        HibernateScrollableResultsIterator(Query jpaQuery) {
            org.hibernate.query.Query query = (org.hibernate.query.Query)jpaQuery.unwrap(org.hibernate.query.Query.class);
            this.scrollableResults = query.setReadOnly(TransactionSynchronizationManager.isCurrentTransactionReadOnly()).scroll(ScrollMode.FORWARD_ONLY);
        }

        public Object next() {
            if (this.scrollableResults == null) {
                throw new NoSuchElementException("No ScrollableResults");
            }
            Object[] row = (Object[])this.scrollableResults.get();
            return row.length == 1 ? row[0] : row;
        }

        public boolean hasNext() {
            return this.scrollableResults != null && this.scrollableResults.next();
        }

        public void close() {
            if (this.scrollableResults != null) {
                this.scrollableResults.close();
            }
        }
    }
}

