/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.EscapeCharacter;
import org.springframework.data.jpa.repository.support.FluentQuerySupport;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.query.FluentQuery;
import org.springframework.data.support.PageableExecutionUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class FetchableFluentQueryByExample<S, R>
extends FluentQuerySupport<R>
implements FluentQuery.FetchableFluentQuery<R> {
    private final Example<S> example;
    private final Function<Sort, TypedQuery<S>> finder;
    private final Function<Example<S>, Long> countOperation;
    private final Function<Example<S>, Boolean> existsOperation;
    private final EntityManager entityManager;
    private final EscapeCharacter escapeCharacter;

    public FetchableFluentQueryByExample(Example<S> example, Function<Sort, TypedQuery<S>> finder, Function<Example<S>, Long> countOperation, Function<Example<S>, Boolean> existsOperation, MappingContext<? extends PersistentEntity<?, ?>, ? extends PersistentProperty<?>> context, EntityManager entityManager, EscapeCharacter escapeCharacter) {
        this(example, example.getProbeType(), Sort.unsorted(), null, finder, countOperation, existsOperation, context, entityManager, escapeCharacter);
    }

    private FetchableFluentQueryByExample(Example<S> example, Class<R> returnType, Sort sort, @Nullable Collection<String> properties, Function<Sort, TypedQuery<S>> finder, Function<Example<S>, Long> countOperation, Function<Example<S>, Boolean> existsOperation, MappingContext<? extends PersistentEntity<?, ?>, ? extends PersistentProperty<?>> context, EntityManager entityManager, EscapeCharacter escapeCharacter) {
        super(returnType, sort, properties, context);
        this.example = example;
        this.finder = finder;
        this.countOperation = countOperation;
        this.existsOperation = existsOperation;
        this.entityManager = entityManager;
        this.escapeCharacter = escapeCharacter;
    }

    public FluentQuery.FetchableFluentQuery<R> sortBy(Sort sort) {
        Assert.notNull((Object)sort, (String)"Sort must not be null!");
        return new FetchableFluentQueryByExample<S, R>(this.example, this.resultType, this.sort.and(sort), this.properties, this.finder, this.countOperation, this.existsOperation, this.context, this.entityManager, this.escapeCharacter);
    }

    public <NR> FluentQuery.FetchableFluentQuery<NR> as(Class<NR> resultType) {
        Assert.notNull(resultType, (String)"Projection target type must not be null!");
        if (!resultType.isInterface()) {
            throw new UnsupportedOperationException("Class-based DTOs are not yet supported.");
        }
        return new FetchableFluentQueryByExample<S, NR>(this.example, resultType, this.sort, this.properties, this.finder, this.countOperation, this.existsOperation, this.context, this.entityManager, this.escapeCharacter);
    }

    public FluentQuery.FetchableFluentQuery<R> project(Collection<String> properties) {
        return new FetchableFluentQueryByExample<S, R>(this.example, this.resultType, this.sort, this.mergeProperties(properties), this.finder, this.countOperation, this.existsOperation, this.context, this.entityManager, this.escapeCharacter);
    }

    public R oneValue() {
        TypedQuery<S> limitedQuery = this.finder.apply(this.sort);
        limitedQuery.setMaxResults(2);
        List results = limitedQuery.getResultList();
        if (results.size() > 1) {
            throw new IncorrectResultSizeDataAccessException(1);
        }
        return results.isEmpty() ? null : (R)this.getConversionFunction().apply(results.get(0));
    }

    public R firstValue() {
        TypedQuery<S> limitedQuery = this.finder.apply(this.sort);
        limitedQuery.setMaxResults(1);
        List results = limitedQuery.getResultList();
        return results.isEmpty() ? null : (R)this.getConversionFunction().apply(results.get(0));
    }

    public List<R> all() {
        List resultList = this.finder.apply(this.sort).getResultList();
        return this.convert(resultList);
    }

    public Page<R> page(Pageable pageable) {
        return pageable.isUnpaged() ? new PageImpl(this.all()) : this.readPage(pageable);
    }

    public Stream<R> stream() {
        return this.finder.apply(this.sort).getResultStream().map(this.getConversionFunction());
    }

    public long count() {
        return this.countOperation.apply(this.example);
    }

    public boolean exists() {
        return this.existsOperation.apply(this.example);
    }

    private Page<R> readPage(Pageable pageable) {
        TypedQuery<S> pagedQuery = this.finder.apply(this.sort);
        if (pageable.isPaged()) {
            pagedQuery.setFirstResult((int)pageable.getOffset());
            pagedQuery.setMaxResults(pageable.getPageSize());
        }
        List<R> paginatedResults = this.convert(pagedQuery.getResultList());
        return PageableExecutionUtils.getPage(paginatedResults, (Pageable)pageable, () -> this.countOperation.apply(this.example));
    }

    private List<R> convert(List<S> resultList) {
        Function<Object, R> conversionFunction = this.getConversionFunction();
        ArrayList<R> mapped = new ArrayList<R>(resultList.size());
        for (S s : resultList) {
            mapped.add(conversionFunction.apply(s));
        }
        return mapped;
    }

    private Function<Object, R> getConversionFunction() {
        return this.getConversionFunction(this.example.getProbeType(), this.resultType);
    }
}

