/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.persistence.Query;
import javax.persistence.criteria.ParameterExpression;
import org.springframework.data.jpa.repository.query.ParameterBinder;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CriteriaQueryParameterBinder
extends ParameterBinder {
    private final Iterator<ParameterExpression<?>> expressions;

    CriteriaQueryParameterBinder(Parameters parameters, Object[] values, Iterable<ParameterExpression<?>> expressions) {
        super(parameters, values);
        Assert.notNull(expressions);
        this.expressions = expressions.iterator();
    }

    @Override
    protected void bind(Query query, Parameter parameter, Object value, int position) {
        ParameterExpression<?> expression = this.expressions.next();
        Collection<?> valueToBind = Collection.class.equals((Object)expression.getJavaType()) ? CriteriaQueryParameterBinder.toCollection(value) : value;
        query.setParameter(expression, valueToBind);
    }

    private static Collection<?> toCollection(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Collection) {
            return (Collection)value;
        }
        if (ObjectUtils.isArray((Object)value)) {
            return Arrays.asList(ObjectUtils.toObjectArray((Object)value));
        }
        return Collections.singleton(value);
    }
}

