/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.aot;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.data.jdbc.repository.aot.AotQuery;
import org.springframework.data.jdbc.repository.aot.StringAotQuery;
import org.springframework.data.repository.aot.generate.QueryMetadata;

record AotQueries(AotQuery result, @Nullable AotQuery count) {
    public static AotQueries create(AotQuery query) {
        return new AotQueries(query, null);
    }

    public static AotQueries create(AotQuery query, AotQuery count) {
        return new AotQueries(query, count);
    }

    public QueryMetadata toMetadata() {
        return new AotQueryMetadata();
    }

    private class AotQueryMetadata
    implements QueryMetadata {
        private AotQueryMetadata() {
        }

        public Map<String, Object> serialize() {
            StringAotQuery.NamedStringAotQuery nsq;
            StringAotQuery sq;
            LinkedHashMap<String, Object> serialized = new LinkedHashMap<String, Object>();
            AotQuery aotQuery = AotQueries.this.result();
            if (aotQuery instanceof StringAotQuery) {
                sq = (StringAotQuery)aotQuery;
                serialized.put("query", sq.getQueryString());
            }
            if ((aotQuery = AotQueries.this.result()) instanceof StringAotQuery.NamedStringAotQuery) {
                nsq = (StringAotQuery.NamedStringAotQuery)aotQuery;
                serialized.put("name", nsq.getQueryName());
            }
            if ((aotQuery = AotQueries.this.count()) instanceof StringAotQuery) {
                sq = (StringAotQuery)aotQuery;
                serialized.put("count-query", sq.getQueryString());
            }
            if ((aotQuery = AotQueries.this.count()) instanceof StringAotQuery.NamedStringAotQuery) {
                nsq = (StringAotQuery.NamedStringAotQuery)aotQuery;
                serialized.put("count-name", nsq.getQueryName());
            }
            return serialized;
        }
    }
}

