/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.mybatis;

import java.util.Collections;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.data.jdbc.core.convert.Identifier;

public class MyBatisContext {
    private final @Nullable Object id;
    private final @Nullable Object instance;
    private final @Nullable Identifier identifier;
    private final @Nullable Class domainType;
    private final Map<String, Object> additionalValues;

    public MyBatisContext(@Nullable Object id, @Nullable Object instance, @Nullable Class<?> domainType, Map<String, Object> additionalValues) {
        this.id = id;
        this.identifier = null;
        this.instance = instance;
        this.domainType = domainType;
        this.additionalValues = additionalValues;
    }

    public MyBatisContext(Identifier identifier, @Nullable Object instance, @Nullable Class<?> domainType) {
        this.id = null;
        this.identifier = identifier;
        this.instance = instance;
        this.domainType = domainType;
        this.additionalValues = Collections.emptyMap();
    }

    public @Nullable Object getId() {
        return this.id;
    }

    public @Nullable Identifier getIdentifier() {
        return this.identifier;
    }

    public @Nullable Object getInstance() {
        return this.instance;
    }

    public @Nullable Class getDomainType() {
        return this.domainType;
    }

    public @Nullable Object get(String key) {
        Object value = null;
        if (this.identifier != null) {
            value = this.identifier.toMap().get(key);
        }
        return value == null ? this.additionalValues.get(key) : value;
    }
}

