/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.mapping;

import java.util.Objects;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface AggregateReference<T, ID> {
    public static <T, ID> AggregateReference<T, ID> to(ID id) {
        return new IdOnlyAggregateReference(id);
    }

    public ID getId();

    public static class IdOnlyAggregateReference<T, ID>
    implements AggregateReference<T, ID> {
        private final ID id;

        public IdOnlyAggregateReference(ID id) {
            Assert.notNull(id, (String)"Id must not be null");
            this.id = id;
        }

        @Override
        public ID getId() {
            return this.id;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IdOnlyAggregateReference that = (IdOnlyAggregateReference)o;
            return this.id.equals(that.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }

        public String toString() {
            return "IdOnlyAggregateReference{id=" + String.valueOf(this.id) + "}";
        }
    }
}

