/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jdbc.core.AggregateChangeExecutor;
import org.springframework.data.jdbc.core.JdbcAggregateOperations;
import org.springframework.data.jdbc.core.convert.DataAccessStrategy;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.mapping.IdentifierAccessor;
import org.springframework.data.mapping.callback.EntityCallbacks;
import org.springframework.data.relational.core.EntityLifecycleEventDelegate;
import org.springframework.data.relational.core.conversion.AggregateChange;
import org.springframework.data.relational.core.conversion.BatchingAggregateChange;
import org.springframework.data.relational.core.conversion.DeleteAggregateChange;
import org.springframework.data.relational.core.conversion.MutableAggregateChange;
import org.springframework.data.relational.core.conversion.RelationalConverter;
import org.springframework.data.relational.core.conversion.RelationalEntityDeleteWriter;
import org.springframework.data.relational.core.conversion.RelationalEntityInsertWriter;
import org.springframework.data.relational.core.conversion.RelationalEntityUpdateWriter;
import org.springframework.data.relational.core.conversion.RelationalEntityVersionUtils;
import org.springframework.data.relational.core.conversion.RootAggregateChange;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.mapping.event.AfterConvertCallback;
import org.springframework.data.relational.core.mapping.event.AfterConvertEvent;
import org.springframework.data.relational.core.mapping.event.AfterDeleteCallback;
import org.springframework.data.relational.core.mapping.event.AfterDeleteEvent;
import org.springframework.data.relational.core.mapping.event.AfterSaveCallback;
import org.springframework.data.relational.core.mapping.event.AfterSaveEvent;
import org.springframework.data.relational.core.mapping.event.BeforeConvertCallback;
import org.springframework.data.relational.core.mapping.event.BeforeConvertEvent;
import org.springframework.data.relational.core.mapping.event.BeforeDeleteCallback;
import org.springframework.data.relational.core.mapping.event.BeforeDeleteEvent;
import org.springframework.data.relational.core.mapping.event.BeforeSaveCallback;
import org.springframework.data.relational.core.mapping.event.BeforeSaveEvent;
import org.springframework.data.relational.core.mapping.event.Identifier;
import org.springframework.data.relational.core.query.Query;
import org.springframework.data.support.PageableExecutionUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class JdbcAggregateTemplate
implements JdbcAggregateOperations {
    private final EntityLifecycleEventDelegate eventDelegate = new EntityLifecycleEventDelegate();
    private final RelationalMappingContext context;
    private final RelationalEntityDeleteWriter jdbcEntityDeleteWriter;
    private final DataAccessStrategy accessStrategy;
    private final AggregateChangeExecutor executor;
    private final JdbcConverter converter;
    private EntityCallbacks entityCallbacks = EntityCallbacks.create();

    public JdbcAggregateTemplate(ApplicationContext publisher, RelationalMappingContext context, JdbcConverter converter, DataAccessStrategy dataAccessStrategy) {
        Assert.notNull((Object)publisher, (String)"ApplicationContext must not be null");
        Assert.notNull((Object)context, (String)"RelationalMappingContext must not be null");
        Assert.notNull((Object)converter, (String)"RelationalConverter must not be null");
        Assert.notNull((Object)dataAccessStrategy, (String)"DataAccessStrategy must not be null");
        this.eventDelegate.setPublisher((ApplicationEventPublisher)publisher);
        this.context = context;
        this.accessStrategy = dataAccessStrategy;
        this.converter = converter;
        this.jdbcEntityDeleteWriter = new RelationalEntityDeleteWriter(context);
        this.executor = new AggregateChangeExecutor(converter, this.accessStrategy);
        this.setEntityCallbacks(EntityCallbacks.create((BeanFactory)publisher));
    }

    public JdbcAggregateTemplate(ApplicationEventPublisher publisher, RelationalMappingContext context, JdbcConverter converter, DataAccessStrategy dataAccessStrategy) {
        Assert.notNull((Object)publisher, (String)"ApplicationEventPublisher must not be null");
        Assert.notNull((Object)context, (String)"RelationalMappingContext must not be null");
        Assert.notNull((Object)converter, (String)"RelationalConverter must not be null");
        Assert.notNull((Object)dataAccessStrategy, (String)"DataAccessStrategy must not be null");
        this.eventDelegate.setPublisher(publisher);
        this.context = context;
        this.accessStrategy = dataAccessStrategy;
        this.converter = converter;
        this.jdbcEntityDeleteWriter = new RelationalEntityDeleteWriter(context);
        this.executor = new AggregateChangeExecutor(converter, this.accessStrategy);
    }

    public void setEntityCallbacks(EntityCallbacks entityCallbacks) {
        Assert.notNull((Object)entityCallbacks, (String)"Callbacks must not be null");
        this.entityCallbacks = entityCallbacks;
    }

    public void setEntityLifecycleEventsEnabled(boolean enabled) {
        this.eventDelegate.setEventsEnabled(enabled);
    }

    @Override
    public <T> T save(T instance) {
        Assert.notNull(instance, (String)"Aggregate instance must not be null");
        this.verifyIdProperty(instance);
        return this.performSave(new EntityAndChangeCreator<T>(instance, this.changeCreatorSelectorForSave(instance)));
    }

    @Override
    public <T> Iterable<T> saveAll(Iterable<T> instances) {
        Assert.notNull(instances, (String)"Aggregate instances must not be null");
        if (!instances.iterator().hasNext()) {
            return Collections.emptyList();
        }
        ArrayList<EntityAndChangeCreator<T>> entityAndChangeCreators = new ArrayList<EntityAndChangeCreator<T>>();
        for (T instance : instances) {
            this.verifyIdProperty(instance);
            entityAndChangeCreators.add(new EntityAndChangeCreator<T>(instance, this.changeCreatorSelectorForSave(instance)));
        }
        return this.performSaveAll(entityAndChangeCreators);
    }

    @Override
    public <T> T insert(T instance) {
        Assert.notNull(instance, (String)"Aggregate instance must not be null");
        return (T)this.performSave(new EntityAndChangeCreator<Object>(instance, entity -> this.createInsertChange(this.prepareVersionForInsert(entity))));
    }

    @Override
    public <T> Iterable<T> insertAll(Iterable<T> instances) {
        Assert.notNull(instances, (String)"Aggregate instances must not be null");
        if (!instances.iterator().hasNext()) {
            return Collections.emptyList();
        }
        ArrayList<EntityAndChangeCreator<T>> entityAndChangeCreators = new ArrayList<EntityAndChangeCreator<T>>();
        for (T instance : instances) {
            Function<Object, RootAggregateChange> changeCreator = entity -> this.createInsertChange(this.prepareVersionForInsert(entity));
            EntityAndChangeCreator<Object> entityChange = new EntityAndChangeCreator<Object>(instance, changeCreator);
            entityAndChangeCreators.add(entityChange);
        }
        return this.performSaveAll(entityAndChangeCreators);
    }

    @Override
    public <T> T update(T instance) {
        Assert.notNull(instance, (String)"Aggregate instance must not be null");
        return (T)this.performSave(new EntityAndChangeCreator<Object>(instance, entity -> this.createUpdateChange(this.prepareVersionForUpdate(entity))));
    }

    @Override
    public <T> Iterable<T> updateAll(Iterable<T> instances) {
        Assert.notNull(instances, (String)"Aggregate instances must not be null");
        if (!instances.iterator().hasNext()) {
            return Collections.emptyList();
        }
        ArrayList<EntityAndChangeCreator<T>> entityAndChangeCreators = new ArrayList<EntityAndChangeCreator<T>>();
        for (T instance : instances) {
            Function<Object, RootAggregateChange> changeCreator = entity -> this.createUpdateChange(this.prepareVersionForUpdate(entity));
            EntityAndChangeCreator<Object> entityChange = new EntityAndChangeCreator<Object>(instance, changeCreator);
            entityAndChangeCreators.add(entityChange);
        }
        return this.performSaveAll(entityAndChangeCreators);
    }

    @Override
    public long count(Class<?> domainType) {
        Assert.notNull(domainType, (String)"Domain type must not be null");
        return this.accessStrategy.count(domainType);
    }

    @Override
    public <T> long count(Query query, Class<T> domainType) {
        return this.accessStrategy.count(query, domainType);
    }

    @Override
    public <T> boolean exists(Query query, Class<T> domainType) {
        return this.accessStrategy.exists(query, domainType);
    }

    @Override
    public <T> boolean existsById(Object id, Class<T> domainType) {
        Assert.notNull((Object)id, (String)"Id must not be null");
        Assert.notNull(domainType, (String)"Domain type must not be null");
        return this.accessStrategy.existsById(id, domainType);
    }

    @Override
    public <T> T findById(Object id, Class<T> domainType) {
        Assert.notNull((Object)id, (String)"Id must not be null");
        Assert.notNull(domainType, (String)"Domain type must not be null");
        T entity = this.accessStrategy.findById(id, domainType);
        if (entity == null) {
            return null;
        }
        return this.triggerAfterConvert(entity);
    }

    @Override
    public <T> Iterable<T> findAll(Class<T> domainType, Sort sort) {
        Assert.notNull(domainType, (String)"Domain type must not be null");
        Iterable<T> all = this.accessStrategy.findAll(domainType, sort);
        return this.triggerAfterConvert((T)all);
    }

    @Override
    public <T> Page<T> findAll(Class<T> domainType, Pageable pageable) {
        Assert.notNull(domainType, (String)"Domain type must not be null");
        Iterable<T> items = this.triggerAfterConvert((T)this.accessStrategy.findAll(domainType, pageable));
        List content = StreamSupport.stream(items.spliterator(), false).collect(Collectors.toList());
        return PageableExecutionUtils.getPage(content, (Pageable)pageable, () -> this.accessStrategy.count(domainType));
    }

    @Override
    public <T> Optional<T> findOne(Query query, Class<T> domainType) {
        return this.accessStrategy.findOne(query, domainType);
    }

    @Override
    public <T> Iterable<T> findAll(Query query, Class<T> domainType) {
        return this.accessStrategy.findAll(query, domainType);
    }

    @Override
    public <T> Page<T> findAll(Query query, Class<T> domainType, Pageable pageable) {
        Iterable<T> items = this.triggerAfterConvert((T)this.accessStrategy.findAll(query, domainType, pageable));
        List content = StreamSupport.stream(items.spliterator(), false).collect(Collectors.toList());
        return PageableExecutionUtils.getPage(content, (Pageable)pageable, () -> this.accessStrategy.count(query, domainType));
    }

    @Override
    public <T> Iterable<T> findAll(Class<T> domainType) {
        Assert.notNull(domainType, (String)"Domain type must not be null");
        Iterable<T> all = this.accessStrategy.findAll(domainType);
        return this.triggerAfterConvert((T)all);
    }

    @Override
    public <T> Iterable<T> findAllById(Iterable<?> ids, Class<T> domainType) {
        Assert.notNull(ids, (String)"Ids must not be null");
        Assert.notNull(domainType, (String)"Domain type must not be null");
        Iterable<T> allById = this.accessStrategy.findAllById(ids, domainType);
        return this.triggerAfterConvert((T)allById);
    }

    public <S> void delete(S aggregateRoot) {
        Assert.notNull(aggregateRoot, (String)"Aggregate root must not be null");
        Class<?> domainType = aggregateRoot.getClass();
        IdentifierAccessor identifierAccessor = ((RelationalPersistentEntity)this.context.getRequiredPersistentEntity(domainType)).getIdentifierAccessor(aggregateRoot);
        this.deleteTree(identifierAccessor.getRequiredIdentifier(), aggregateRoot, domainType);
    }

    public <S> void deleteById(Object id, Class<S> domainType) {
        Assert.notNull((Object)id, (String)"Id must not be null");
        Assert.notNull(domainType, (String)"Domain type must not be null");
        this.deleteTree(id, null, domainType);
    }

    @Override
    public <T> void deleteAllById(Iterable<?> ids, Class<T> domainType) {
        if (!ids.iterator().hasNext()) {
            return;
        }
        BatchingAggregateChange batchingAggregateChange = BatchingAggregateChange.forDelete(domainType);
        ids.forEach(id -> {
            DeleteAggregateChange<Object> change = this.createDeletingChange(id, null, domainType);
            this.triggerBeforeDelete(null, id, (MutableAggregateChange)change);
            batchingAggregateChange.add(change);
        });
        this.executor.executeDelete(batchingAggregateChange);
        ids.forEach(id -> this.triggerAfterDelete(null, id, (AggregateChange)batchingAggregateChange));
    }

    @Override
    public void deleteAll(Class<?> domainType) {
        Assert.notNull(domainType, (String)"Domain type must not be null");
        MutableAggregateChange<?> change = this.createDeletingChange(domainType);
        this.executor.executeDelete(change);
    }

    @Override
    public <T> void deleteAll(Iterable<? extends T> instances) {
        if (!instances.iterator().hasNext()) {
            return;
        }
        HashMap<Class, List> groupedByType = new HashMap<Class, List>();
        for (T instance : instances) {
            Class<?> type = instance.getClass();
            List list = groupedByType.computeIfAbsent(type, __ -> new ArrayList());
            list.add(instance);
        }
        for (Class type : groupedByType.keySet()) {
            this.doDeleteAll((Iterable)groupedByType.get(type), type);
        }
    }

    private <T> void verifyIdProperty(T instance) {
        ((RelationalPersistentEntity)this.context.getRequiredPersistentEntity(instance.getClass())).getRequiredIdProperty();
    }

    private <T> void doDeleteAll(Iterable<? extends T> instances, Class<T> domainType) {
        BatchingAggregateChange batchingAggregateChange = BatchingAggregateChange.forDelete(domainType);
        LinkedHashMap<Object, Object> instancesBeforeExecute = new LinkedHashMap<Object, Object>();
        instances.forEach(instance -> {
            Object id = ((RelationalPersistentEntity)this.context.getRequiredPersistentEntity(domainType)).getIdentifierAccessor(instance).getRequiredIdentifier();
            DeleteAggregateChange<Object> change = this.createDeletingChange(id, instance, domainType);
            instancesBeforeExecute.put(id, this.triggerBeforeDelete((Object)instance, id, (MutableAggregateChange)change));
            batchingAggregateChange.add(change);
        });
        this.executor.executeDelete(batchingAggregateChange);
        instancesBeforeExecute.forEach((id, instance) -> this.triggerAfterDelete((Object)instance, id, (AggregateChange)batchingAggregateChange));
    }

    private <T> T afterExecute(AggregateChange<T> change, T entityAfterExecution) {
        Object identifier = ((RelationalPersistentEntity)this.context.getRequiredPersistentEntity(change.getEntityType())).getIdentifierAccessor(entityAfterExecution).getIdentifier();
        Assert.notNull((Object)identifier, (String)"After saving the identifier must not be null");
        return this.triggerAfterSave(entityAfterExecution, change);
    }

    private <T> RootAggregateChange<T> beforeExecute(EntityAndChangeCreator<T> instance) {
        Assert.notNull(instance.entity, (String)"Aggregate instance must not be null");
        Object aggregateRoot = this.triggerBeforeConvert(instance.entity);
        RootAggregateChange change = instance.changeCreator.apply(aggregateRoot);
        aggregateRoot = this.triggerBeforeSave((T)change.getRoot(), (AggregateChange<T>)change);
        change.setRoot(aggregateRoot);
        return change;
    }

    private <T> void deleteTree(Object id, @Nullable T entity, Class<T> domainType) {
        DeleteAggregateChange<T> change = this.createDeletingChange(id, entity, domainType);
        entity = this.triggerBeforeDelete(entity, id, (MutableAggregateChange<T>)change);
        this.executor.executeDelete(change);
        this.triggerAfterDelete(entity, id, (AggregateChange<T>)change);
    }

    private <T> T performSave(EntityAndChangeCreator<T> instance) {
        BatchingAggregateChange batchingAggregateChange = BatchingAggregateChange.forSave((Class)ClassUtils.getUserClass(instance.entity));
        batchingAggregateChange.add(this.beforeExecute(instance));
        Iterator afterExecutionIterator = this.executor.executeSave(batchingAggregateChange).iterator();
        Assert.isTrue((boolean)afterExecutionIterator.hasNext(), (String)"Instances after execution must not be empty");
        return this.afterExecute((AggregateChange<T>)batchingAggregateChange, afterExecutionIterator.next());
    }

    private <T> List<T> performSaveAll(Iterable<EntityAndChangeCreator<T>> instances) {
        BatchingAggregateChange batchingAggregateChange = null;
        for (EntityAndChangeCreator<T> instance : instances) {
            if (batchingAggregateChange == null) {
                batchingAggregateChange = BatchingAggregateChange.forSave((Class)ClassUtils.getUserClass(instance.entity));
            }
            batchingAggregateChange.add(this.beforeExecute(instance));
        }
        Assert.notNull(batchingAggregateChange, (String)"Iterable in saveAll must not be empty");
        List instancesAfterExecution = this.executor.executeSave(batchingAggregateChange);
        ArrayList results = new ArrayList(instancesAfterExecution.size());
        for (Object instance : instancesAfterExecution) {
            results.add(this.afterExecute((AggregateChange<T>)batchingAggregateChange, instance));
        }
        return results;
    }

    private <T> Function<T, RootAggregateChange<T>> changeCreatorSelectorForSave(T instance) {
        return ((RelationalPersistentEntity)this.context.getRequiredPersistentEntity(instance.getClass())).isNew(instance) ? entity -> this.createInsertChange(this.prepareVersionForInsert(entity)) : entity -> this.createUpdateChange(this.prepareVersionForUpdate(entity));
    }

    private <T> RootAggregateChange<T> createInsertChange(T instance) {
        RootAggregateChange aggregateChange = MutableAggregateChange.forSave(instance);
        new RelationalEntityInsertWriter(this.context).write(instance, aggregateChange);
        return aggregateChange;
    }

    private <T> RootAggregateChange<T> createUpdateChange(EntityAndPreviousVersion<T> entityAndVersion) {
        RootAggregateChange aggregateChange = MutableAggregateChange.forSave(entityAndVersion.entity, (Number)entityAndVersion.version);
        new RelationalEntityUpdateWriter(this.context).write(entityAndVersion.entity, aggregateChange);
        return aggregateChange;
    }

    private <T> T prepareVersionForInsert(T instance) {
        RelationalPersistentEntity<T> persistentEntity = this.getRequiredPersistentEntity(instance);
        Object preparedInstance = instance;
        if (persistentEntity.hasVersionProperty()) {
            RelationalPersistentProperty versionProperty = (RelationalPersistentProperty)persistentEntity.getRequiredVersionProperty();
            long initialVersion = versionProperty.getActualType().isPrimitive() ? 1L : 0L;
            preparedInstance = RelationalEntityVersionUtils.setVersionNumberOnEntity(instance, (Number)initialVersion, persistentEntity, (RelationalConverter)this.converter);
        }
        return preparedInstance;
    }

    private <T> EntityAndPreviousVersion<T> prepareVersionForUpdate(T instance) {
        RelationalPersistentEntity<T> persistentEntity = this.getRequiredPersistentEntity(instance);
        Object preparedInstance = instance;
        Number previousVersion = null;
        if (persistentEntity.hasVersionProperty()) {
            previousVersion = RelationalEntityVersionUtils.getVersionNumberFromEntity(instance, persistentEntity, (RelationalConverter)this.converter);
            long newVersion = (previousVersion == null ? 0L : previousVersion.longValue()) + 1L;
            preparedInstance = RelationalEntityVersionUtils.setVersionNumberOnEntity(instance, (Number)newVersion, persistentEntity, (RelationalConverter)this.converter);
        }
        return new EntityAndPreviousVersion<T>(preparedInstance, previousVersion);
    }

    private <T> RelationalPersistentEntity<T> getRequiredPersistentEntity(T instance) {
        return (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(instance.getClass());
    }

    private <T> DeleteAggregateChange<T> createDeletingChange(Object id, @Nullable T entity, Class<T> domainType) {
        RelationalPersistentEntity<T> persistentEntity;
        Number previousVersion = null;
        if (entity != null && (persistentEntity = this.getRequiredPersistentEntity(entity)).hasVersionProperty()) {
            previousVersion = RelationalEntityVersionUtils.getVersionNumberFromEntity(entity, persistentEntity, (RelationalConverter)this.converter);
        }
        DeleteAggregateChange aggregateChange = MutableAggregateChange.forDelete(domainType, previousVersion);
        this.jdbcEntityDeleteWriter.write(id, (MutableAggregateChange)aggregateChange);
        return aggregateChange;
    }

    private MutableAggregateChange<?> createDeletingChange(Class<?> domainType) {
        DeleteAggregateChange aggregateChange = MutableAggregateChange.forDelete(domainType);
        this.jdbcEntityDeleteWriter.write(null, (MutableAggregateChange)aggregateChange);
        return aggregateChange;
    }

    private <T> Iterable<T> triggerAfterConvert(Iterable<T> all) {
        ArrayList<T> result = new ArrayList<T>();
        for (T e : all) {
            result.add(this.triggerAfterConvert(e));
        }
        return result;
    }

    private <T> T triggerAfterConvert(T entity) {
        this.eventDelegate.publishEvent(() -> new AfterConvertEvent(entity));
        return (T)this.entityCallbacks.callback(AfterConvertCallback.class, entity, new Object[0]);
    }

    private <T> T triggerBeforeConvert(T aggregateRoot) {
        this.eventDelegate.publishEvent(() -> new BeforeConvertEvent(aggregateRoot));
        return (T)this.entityCallbacks.callback(BeforeConvertCallback.class, aggregateRoot, new Object[0]);
    }

    private <T> T triggerBeforeSave(T aggregateRoot, AggregateChange<T> change) {
        this.eventDelegate.publishEvent(() -> new BeforeSaveEvent(aggregateRoot, change));
        return (T)this.entityCallbacks.callback(BeforeSaveCallback.class, aggregateRoot, new Object[]{change});
    }

    private <T> T triggerAfterSave(T aggregateRoot, AggregateChange<T> change) {
        this.eventDelegate.publishEvent(() -> new AfterSaveEvent(aggregateRoot, change));
        return (T)this.entityCallbacks.callback(AfterSaveCallback.class, aggregateRoot, new Object[0]);
    }

    private <T> void triggerAfterDelete(@Nullable T aggregateRoot, Object id, AggregateChange<T> change) {
        this.eventDelegate.publishEvent(() -> new AfterDeleteEvent(Identifier.of((Object)id), aggregateRoot, change));
        if (aggregateRoot != null) {
            this.entityCallbacks.callback(AfterDeleteCallback.class, aggregateRoot, new Object[0]);
        }
    }

    @Nullable
    private <T> T triggerBeforeDelete(@Nullable T aggregateRoot, Object id, MutableAggregateChange<T> change) {
        this.eventDelegate.publishEvent(() -> new BeforeDeleteEvent(Identifier.of((Object)id), aggregateRoot, (AggregateChange)change));
        if (aggregateRoot != null) {
            return (T)this.entityCallbacks.callback(BeforeDeleteCallback.class, aggregateRoot, new Object[]{change});
        }
        return null;
    }

    private record EntityAndChangeCreator<T>(T entity, Function<T, RootAggregateChange<T>> changeCreator) {
    }

    private record EntityAndPreviousVersion<T>(T entity, @Nullable Number version) {
    }
}

