/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.mapping.schema;

import java.util.ArrayList;
import java.util.List;
import org.springframework.data.jdbc.core.mapping.schema.Column;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

record Table(@Nullable String schema, String name, List<Column> keyColumns, List<Column> columns) {
    public Table(@Nullable String schema, String name) {
        this(schema, name, new ArrayList<Column>(), new ArrayList<Column>());
    }

    public Table(String name) {
        this(null, name);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Table table = (Table)o;
        return ObjectUtils.nullSafeEquals((Object)this.schema, (Object)table.schema) && ObjectUtils.nullSafeEquals((Object)this.name, (Object)table.name);
    }

    @Override
    public int hashCode() {
        int result = 17;
        result += ObjectUtils.nullSafeHashCode((Object)this.schema);
        return result += ObjectUtils.nullSafeHashCode((Object)this.name);
    }
}

