/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.util.Map;
import java.util.Optional;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.jdbc.core.convert.InsertStrategy;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.dialect.IdGeneration;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.lang.Nullable;

class IdGeneratingInsertStrategy
implements InsertStrategy {
    private final Dialect dialect;
    private final NamedParameterJdbcOperations jdbcOperations;
    private final SqlIdentifier idColumn;

    IdGeneratingInsertStrategy(Dialect dialect, NamedParameterJdbcOperations jdbcOperations, @Nullable SqlIdentifier idColumn) {
        this.dialect = dialect;
        this.jdbcOperations = jdbcOperations;
        this.idColumn = idColumn;
    }

    @Override
    public Object execute(String sql, SqlParameterSource sqlParameterSource) {
        GeneratedKeyHolder holder = new GeneratedKeyHolder();
        IdGeneration idGeneration = this.dialect.getIdGeneration();
        if (idGeneration.driverRequiresKeyColumnNames()) {
            String[] keyColumnNames = this.getKeyColumnNames();
            if (keyColumnNames.length == 0) {
                this.jdbcOperations.update(sql, sqlParameterSource, (KeyHolder)holder);
            } else {
                this.jdbcOperations.update(sql, sqlParameterSource, (KeyHolder)holder, keyColumnNames);
            }
        } else {
            this.jdbcOperations.update(sql, sqlParameterSource, (KeyHolder)holder);
        }
        try {
            return holder.getKey();
        }
        catch (DataRetrievalFailureException | InvalidDataAccessApiUsageException e) {
            Map keys = holder.getKeys();
            if (keys == null || this.idColumn == null) {
                return null;
            }
            return keys.get(this.idColumn.getReference(this.dialect.getIdentifierProcessing()));
        }
    }

    private String[] getKeyColumnNames() {
        return Optional.ofNullable(this.idColumn).map(idColumn -> new String[]{idColumn.getReference(this.dialect.getIdentifierProcessing())}).orElse(new String[0]);
    }
}

