/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.query;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.jdbc.repository.query.Modifying;
import org.springframework.data.jdbc.repository.query.Query;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.repository.query.RelationalEntityMetadata;
import org.springframework.data.relational.repository.query.RelationalParameters;
import org.springframework.data.relational.repository.query.SimpleRelationalEntityMetadata;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.StringUtils;

public class JdbcQueryMethod
extends QueryMethod {
    private final Method method;
    private final MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> mappingContext;
    private final Map<Class<? extends Annotation>, Optional<Annotation>> annotationCache;
    private final NamedQueries namedQueries;
    @Nullable
    private RelationalEntityMetadata<?> metadata;

    public JdbcQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries, MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> mappingContext) {
        super(method, metadata, factory);
        this.namedQueries = namedQueries;
        this.method = method;
        this.mappingContext = mappingContext;
        this.annotationCache = new ConcurrentReferenceHashMap();
    }

    protected RelationalParameters createParameters(Method method) {
        return new RelationalParameters(method);
    }

    public RelationalEntityMetadata<?> getEntityInformation() {
        if (this.metadata == null) {
            Class returnedObjectType = this.getReturnedObjectType();
            Class domainClass = this.getDomainClass();
            if (ClassUtils.isPrimitiveOrWrapper((Class)returnedObjectType)) {
                this.metadata = new SimpleRelationalEntityMetadata(domainClass, (RelationalPersistentEntity)this.mappingContext.getRequiredPersistentEntity(domainClass));
            } else {
                RelationalPersistentEntity returnedEntity = (RelationalPersistentEntity)this.mappingContext.getPersistentEntity(returnedObjectType);
                RelationalPersistentEntity managedEntity = (RelationalPersistentEntity)this.mappingContext.getRequiredPersistentEntity(domainClass);
                returnedEntity = returnedEntity == null || returnedEntity.getType().isInterface() ? managedEntity : returnedEntity;
                RelationalPersistentEntity tableEntity = domainClass.isAssignableFrom(returnedObjectType) ? returnedEntity : managedEntity;
                this.metadata = new SimpleRelationalEntityMetadata(returnedEntity.getType(), tableEntity);
            }
        }
        return this.metadata;
    }

    public RelationalParameters getParameters() {
        return (RelationalParameters)super.getParameters();
    }

    @Nullable
    String getDeclaredQuery() {
        String annotatedValue = this.getQueryValue();
        return StringUtils.hasText((String)annotatedValue) ? annotatedValue : this.getNamedQuery();
    }

    @Nullable
    private String getQueryValue() {
        return (String)this.getMergedAnnotationAttribute("value");
    }

    @Nullable
    private String getNamedQuery() {
        String name = this.getNamedQueryName();
        return this.namedQueries.hasQuery(name) ? this.namedQueries.getQuery(name) : null;
    }

    public String getNamedQueryName() {
        String annotatedName = (String)this.getMergedAnnotationAttribute("name");
        return StringUtils.hasText((String)annotatedName) ? annotatedName : super.getNamedQueryName();
    }

    @Nullable
    Class<? extends RowMapper> getRowMapperClass() {
        return (Class)this.getMergedAnnotationAttribute("rowMapperClass");
    }

    @Nullable
    String getRowMapperRef() {
        return (String)this.getMergedAnnotationAttribute("rowMapperRef");
    }

    @Nullable
    Class<? extends ResultSetExtractor> getResultSetExtractorClass() {
        return (Class)this.getMergedAnnotationAttribute("resultSetExtractorClass");
    }

    @Nullable
    String getResultSetExtractorRef() {
        return (String)this.getMergedAnnotationAttribute("resultSetExtractorRef");
    }

    public boolean isModifyingQuery() {
        return AnnotationUtils.findAnnotation((Method)this.method, Modifying.class) != null;
    }

    @Nullable
    private <T> T getMergedAnnotationAttribute(String attribute) {
        Query queryAnnotation = (Query)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)this.method, Query.class);
        return (T)AnnotationUtils.getValue((Annotation)queryAnnotation, (String)attribute);
    }

    public boolean hasAnnotatedQuery() {
        return this.findAnnotatedQuery().isPresent();
    }

    private Optional<String> findAnnotatedQuery() {
        return this.lookupQueryAnnotation().map(Query::value).filter(StringUtils::hasText);
    }

    Optional<Query> lookupQueryAnnotation() {
        return this.doFindAnnotation(Query.class);
    }

    private <A extends Annotation> Optional<A> doFindAnnotation(Class<A> annotationType) {
        return this.annotationCache.computeIfAbsent(annotationType, it -> Optional.ofNullable(AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)this.method, (Class)it)));
    }
}

