/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.util.ClassUtils;

public enum JdbcColumnTypes {
    INSTANCE{

        @Override
        public Class<?> resolvePrimitiveType(Class<?> type) {
            return javaToDbType.entrySet().stream().filter(e -> ((Class)e.getKey()).isAssignableFrom(type)).map(e -> (Class)e.getValue()).findFirst().orElseGet(() -> ClassUtils.resolvePrimitiveIfNecessary((Class)type));
        }
    };

    private static final Map<Class<?>, Class<?>> javaToDbType;

    public abstract Class<?> resolvePrimitiveType(Class<?> var1);

    static {
        javaToDbType = new LinkedHashMap();
        javaToDbType.put(Enum.class, String.class);
        javaToDbType.put(ZonedDateTime.class, String.class);
        javaToDbType.put(Temporal.class, Date.class);
    }
}

