/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.support;

import java.lang.reflect.Method;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.jdbc.core.convert.EntityRowMapper;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.repository.QueryMappingConfiguration;
import org.springframework.data.jdbc.repository.support.JdbcQueryMethod;
import org.springframework.data.jdbc.repository.support.JdbcRepositoryQuery;
import org.springframework.data.mapping.callback.EntityCallbacks;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;

class JdbcQueryLookupStrategy
implements QueryLookupStrategy {
    private final ApplicationEventPublisher publisher;
    private final EntityCallbacks callbacks;
    private final RelationalMappingContext context;
    private final JdbcConverter converter;
    private final QueryMappingConfiguration queryMappingConfiguration;
    private final NamedParameterJdbcOperations operations;

    public RepositoryQuery resolveQuery(Method method, RepositoryMetadata repositoryMetadata, ProjectionFactory projectionFactory, NamedQueries namedQueries) {
        JdbcQueryMethod queryMethod = new JdbcQueryMethod(method, repositoryMetadata, projectionFactory);
        RowMapper<?> mapper = queryMethod.isModifyingQuery() ? null : this.createMapper(queryMethod);
        return new JdbcRepositoryQuery(this.publisher, this.callbacks, this.context, queryMethod, this.operations, mapper);
    }

    private RowMapper<?> createMapper(JdbcQueryMethod queryMethod) {
        Class returnedObjectType = queryMethod.getReturnedObjectType();
        RelationalPersistentEntity persistentEntity = (RelationalPersistentEntity)this.context.getPersistentEntity(returnedObjectType);
        if (persistentEntity == null) {
            return SingleColumnRowMapper.newInstance((Class)returnedObjectType, (ConversionService)this.converter.getConversionService());
        }
        return this.determineDefaultMapper(queryMethod);
    }

    private RowMapper<?> determineDefaultMapper(JdbcQueryMethod queryMethod) {
        Class domainType = queryMethod.getReturnedObjectType();
        RowMapper configuredQueryMapper = this.queryMappingConfiguration.getRowMapper(domainType);
        if (configuredQueryMapper != null) {
            return configuredQueryMapper;
        }
        EntityRowMapper defaultEntityRowMapper = new EntityRowMapper((RelationalPersistentEntity)this.context.getRequiredPersistentEntity(domainType), this.converter);
        return defaultEntityRowMapper;
    }

    public JdbcQueryLookupStrategy(ApplicationEventPublisher publisher, EntityCallbacks callbacks, RelationalMappingContext context, JdbcConverter converter, QueryMappingConfiguration queryMappingConfiguration, NamedParameterJdbcOperations operations) {
        this.publisher = publisher;
        this.callbacks = callbacks;
        this.context = context;
        this.converter = converter;
        this.queryMappingConfiguration = queryMappingConfiguration;
        this.operations = operations;
    }
}

