/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.util.Map;
import org.springframework.data.jdbc.core.convert.RelationResolver;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.domain.Identifier;
import org.springframework.lang.Nullable;

public interface DataAccessStrategy
extends RelationResolver {
    @Deprecated
    public <T> Object insert(T var1, Class<T> var2, Map<String, Object> var3);

    default public <T> Object insert(T instance, Class<T> domainType, Identifier identifier) {
        return this.insert(instance, domainType, identifier.toMap());
    }

    public <T> boolean update(T var1, Class<T> var2);

    public void delete(Object var1, Class<?> var2);

    public void delete(Object var1, PersistentPropertyPath<RelationalPersistentProperty> var2);

    public <T> void deleteAll(Class<T> var1);

    public void deleteAll(PersistentPropertyPath<RelationalPersistentProperty> var1);

    public long count(Class<?> var1);

    @Nullable
    public <T> T findById(Object var1, Class<T> var2);

    public <T> Iterable<T> findAll(Class<T> var1);

    public <T> Iterable<T> findAllById(Iterable<?> var1, Class<T> var2);

    @Override
    default public Iterable<Object> findAllByPath(Identifier identifier, PersistentPropertyPath<RelationalPersistentProperty> path) {
        Object rootId = identifier.toMap().get(((RelationalPersistentProperty)path.getRequiredLeafProperty()).getReverseColumnName());
        return this.findAllByProperty(rootId, (RelationalPersistentProperty)path.getRequiredLeafProperty());
    }

    @Deprecated
    public <T> Iterable<T> findAllByProperty(Object var1, RelationalPersistentProperty var2);

    public <T> boolean existsById(Object var1, Class<T> var2);
}

